/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.GeneralLedgerConstants;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntryFieldUtil;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.context.SpringContext;

public class LaborOriginEntry
extends OriginEntryFull
implements LaborTransaction {
    private static LaborOriginEntryFieldUtil laborOriginEntryFieldUtil;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    protected String positionNumber;
    protected Date transactionPostingDate;
    protected Date payPeriodEndDate;
    protected BigDecimal transactionTotalHours;
    protected Integer payrollEndDateFiscalYear;
    protected String payrollEndDateFiscalPeriodCode;
    protected String financialDocumentApprovedCode;
    protected String transactionEntryOffsetCode;
    protected Timestamp transactionEntryProcessedTimestamp;
    protected String emplid;
    protected Integer employeeRecord;
    protected String earnCode;
    protected String payGroup;
    protected String salaryAdministrationPlan;
    protected String grade;
    protected String runIdentifier;
    protected String laborLedgerOriginalChartOfAccountsCode;
    protected String laborLedgerOriginalAccountNumber;
    protected String laborLedgerOriginalSubAccountNumber;
    protected String laborLedgerOriginalFinancialObjectCode;
    protected String laborLedgerOriginalFinancialSubObjectCode;
    protected String hrmsCompany;
    protected String setid;
    protected Date transactionDateTimeStamp;
    protected DocumentType referenceFinancialSystemDocumentType;
    protected OriginationCode referenceFinancialSystemOrigination;
    protected AccountingPeriod payrollEndDateFiscalPeriod;

    public LaborOriginEntry(LaborLedgerPendingEntry pendingEntry) {
        this.accountNumber = pendingEntry.getAccountNumber();
        this.documentNumber = pendingEntry.getDocumentNumber();
        this.referenceFinancialDocumentNumber = pendingEntry.getReferenceFinancialDocumentNumber();
        this.referenceFinancialDocumentTypeCode = pendingEntry.getReferenceFinancialDocumentTypeCode();
        this.financialDocumentReversalDate = pendingEntry.getFinancialDocumentReversalDate();
        this.financialDocumentTypeCode = pendingEntry.getFinancialDocumentTypeCode();
        this.financialBalanceTypeCode = pendingEntry.getFinancialBalanceTypeCode();
        this.chartOfAccountsCode = pendingEntry.getChartOfAccountsCode();
        this.financialObjectTypeCode = pendingEntry.getFinancialObjectTypeCode();
        this.financialObjectCode = pendingEntry.getFinancialObjectCode();
        this.financialSubObjectCode = pendingEntry.getFinancialSubObjectCode();
        this.financialSystemOriginationCode = pendingEntry.getFinancialSystemOriginationCode();
        this.referenceFinancialSystemOriginationCode = pendingEntry.getReferenceFinancialSystemOriginationCode();
        this.organizationDocumentNumber = pendingEntry.getOrganizationDocumentNumber();
        this.organizationReferenceId = pendingEntry.getOrganizationReferenceId();
        this.projectCode = pendingEntry.getProjectCode();
        this.subAccountNumber = pendingEntry.getSubAccountNumber();
        this.transactionDate = pendingEntry.getTransactionDate();
        this.transactionDebitCreditCode = pendingEntry.getTransactionDebitCreditCode();
        this.transactionEncumbranceUpdateCode = pendingEntry.getTransactionEncumbranceUpdateCode();
        this.transactionLedgerEntrySequenceNumber = pendingEntry.getTransactionLedgerEntrySequenceNumber();
        this.transactionLedgerEntryAmount = pendingEntry.getTransactionLedgerEntryAmount();
        this.transactionLedgerEntryDescription = pendingEntry.getTransactionLedgerEntryDescription();
        this.universityFiscalPeriodCode = pendingEntry.getUniversityFiscalPeriodCode();
        this.universityFiscalYear = pendingEntry.getUniversityFiscalYear();
        this.positionNumber = pendingEntry.getPositionNumber();
        this.transactionPostingDate = pendingEntry.getTransactionPostingDate();
        this.payPeriodEndDate = pendingEntry.getPayPeriodEndDate();
        this.transactionTotalHours = pendingEntry.getTransactionTotalHours();
        this.payrollEndDateFiscalYear = pendingEntry.getPayrollEndDateFiscalYear();
        this.payrollEndDateFiscalPeriodCode = pendingEntry.getPayrollEndDateFiscalPeriodCode();
        this.emplid = pendingEntry.getEmplid();
        this.employeeRecord = pendingEntry.getEmployeeRecord();
        this.earnCode = pendingEntry.getEarnCode();
        this.payGroup = pendingEntry.getPayGroup();
        this.salaryAdministrationPlan = pendingEntry.getSalaryAdministrationPlan();
        this.grade = pendingEntry.getGrade();
        this.runIdentifier = pendingEntry.getRunIdentifier();
        this.laborLedgerOriginalChartOfAccountsCode = pendingEntry.getLaborLedgerOriginalChartOfAccountsCode();
        this.laborLedgerOriginalAccountNumber = pendingEntry.getLaborLedgerOriginalAccountNumber();
        this.laborLedgerOriginalSubAccountNumber = pendingEntry.getLaborLedgerOriginalSubAccountNumber();
        this.laborLedgerOriginalFinancialObjectCode = pendingEntry.getLaborLedgerOriginalFinancialObjectCode();
        this.laborLedgerOriginalFinancialSubObjectCode = pendingEntry.getLaborLedgerOriginalFinancialSubObjectCode();
        this.hrmsCompany = pendingEntry.getHrmsCompany();
        this.setid = pendingEntry.getSetid();
        this.transactionEntryOffsetCode = pendingEntry.getTransactionEntryOffsetCode();
        this.payrollEndDateFiscalPeriod = pendingEntry.getPayrollEndDateFiscalPeriod();
    }

    public LaborOriginEntry(String financialDocumentTypeCode, String financialSystemOriginationCode) {
        super(financialDocumentTypeCode, financialSystemOriginationCode);
    }

    public LaborOriginEntry() {
        this(null, null);
    }

    public LaborOriginEntry(LaborTransaction t) {
        this();
        this.copyFieldsFromTransaction(t);
        this.setPositionNumber(t.getPositionNumber());
        this.setTransactionPostingDate(t.getTransactionPostingDate());
        this.setPayPeriodEndDate(t.getPayPeriodEndDate());
        this.setTransactionTotalHours(t.getTransactionTotalHours());
        this.setPayrollEndDateFiscalYear(t.getPayrollEndDateFiscalYear());
        this.setPayrollEndDateFiscalPeriodCode(t.getPayrollEndDateFiscalPeriodCode());
        this.setFinancialDocumentApprovedCode(t.getFinancialDocumentApprovedCode());
        this.setTransactionEntryOffsetCode(t.getTransactionEntryOffsetCode());
        this.setTransactionEntryProcessedTimestamp(t.getTransactionEntryProcessedTimestamp());
        this.setEmplid(t.getEmplid());
        this.setEmployeeRecord(t.getEmployeeRecord());
        this.setEarnCode(t.getEarnCode());
        this.setPayGroup(t.getPayGroup());
        this.setSalaryAdministrationPlan(t.getSalaryAdministrationPlan());
        this.setGrade(t.getGrade());
        this.setRunIdentifier(t.getRunIdentifier());
        this.setLaborLedgerOriginalChartOfAccountsCode(t.getLaborLedgerOriginalChartOfAccountsCode());
        this.setLaborLedgerOriginalAccountNumber(t.getLaborLedgerOriginalAccountNumber());
        this.setLaborLedgerOriginalSubAccountNumber(t.getLaborLedgerOriginalSubAccountNumber());
        this.setLaborLedgerOriginalFinancialObjectCode(t.getLaborLedgerOriginalFinancialObjectCode());
        this.setLaborLedgerOriginalFinancialSubObjectCode(t.getLaborLedgerOriginalFinancialSubObjectCode());
        this.setHrmsCompany(t.getHrmsCompany());
        this.setSetid(t.getSetid());
        this.referenceFinancialSystemDocumentType = t.getReferenceFinancialSystemDocumentType();
        this.setReferenceFinancialSystemOrigination(t.getReferenceFinancialSystemOrigination());
        this.setPayrollEndDateFiscalPeriod(t.getPayrollEndDateFiscalPeriod());
    }

    public LaborOriginEntry(String line) {
        this.setFromTextFileForBatch(line, 0);
    }

    @Override
    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    @Override
    public Date getTransactionPostingDate() {
        return this.transactionPostingDate;
    }

    public void setTransactionPostingDate(Date transactionPostingDate) {
        this.transactionPostingDate = transactionPostingDate;
    }

    @Override
    public Date getPayPeriodEndDate() {
        return this.payPeriodEndDate;
    }

    public void setPayPeriodEndDate(Date payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
    }

    @Override
    public BigDecimal getTransactionTotalHours() {
        return this.transactionTotalHours;
    }

    public void setTransactionTotalHours(BigDecimal transactionTotalHours) {
        this.transactionTotalHours = transactionTotalHours;
    }

    @Override
    public Integer getPayrollEndDateFiscalYear() {
        return this.payrollEndDateFiscalYear;
    }

    public void setPayrollEndDateFiscalYear(Integer payrollEndDateFiscalYear) {
        this.payrollEndDateFiscalYear = payrollEndDateFiscalYear;
    }

    @Override
    public String getPayrollEndDateFiscalPeriodCode() {
        return this.payrollEndDateFiscalPeriodCode;
    }

    public void setPayrollEndDateFiscalPeriodCode(String payrollEndDateFiscalPeriodCode) {
        this.payrollEndDateFiscalPeriodCode = payrollEndDateFiscalPeriodCode;
    }

    @Override
    public String getFinancialDocumentApprovedCode() {
        return this.financialDocumentApprovedCode;
    }

    public void setFinancialDocumentApprovedCode(String financialDocumentApprovedCode) {
        this.financialDocumentApprovedCode = financialDocumentApprovedCode;
    }

    @Override
    public String getTransactionEntryOffsetCode() {
        return this.transactionEntryOffsetCode;
    }

    public void setTransactionEntryOffsetCode(String transactionEntryOffsetCode) {
        this.transactionEntryOffsetCode = transactionEntryOffsetCode;
    }

    @Override
    public Timestamp getTransactionEntryProcessedTimestamp() {
        return this.transactionEntryProcessedTimestamp;
    }

    public void setTransactionEntryProcessedTimestamp(Timestamp transactionEntryProcessedTimestamp) {
        this.transactionEntryProcessedTimestamp = transactionEntryProcessedTimestamp;
    }

    @Override
    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    @Override
    public Integer getEmployeeRecord() {
        return this.employeeRecord;
    }

    public void setEmployeeRecord(Integer employeeRecord) {
        this.employeeRecord = employeeRecord;
    }

    @Override
    public String getEarnCode() {
        return this.earnCode;
    }

    public void setEarnCode(String earnCode) {
        this.earnCode = earnCode;
    }

    @Override
    public String getPayGroup() {
        return this.payGroup;
    }

    public void setPayGroup(String payGroup) {
        this.payGroup = payGroup;
    }

    @Override
    public String getSalaryAdministrationPlan() {
        return this.salaryAdministrationPlan;
    }

    public void setSalaryAdministrationPlan(String salaryAdministrationPlan) {
        this.salaryAdministrationPlan = salaryAdministrationPlan;
    }

    @Override
    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    @Override
    public String getRunIdentifier() {
        return this.runIdentifier;
    }

    public void setRunIdentifier(String runIdentifier) {
        this.runIdentifier = runIdentifier;
    }

    @Override
    public String getLaborLedgerOriginalChartOfAccountsCode() {
        return this.laborLedgerOriginalChartOfAccountsCode;
    }

    public void setLaborLedgerOriginalChartOfAccountsCode(String laborLedgerOriginalChartOfAccountsCode) {
        this.laborLedgerOriginalChartOfAccountsCode = laborLedgerOriginalChartOfAccountsCode;
    }

    @Override
    public String getLaborLedgerOriginalAccountNumber() {
        return this.laborLedgerOriginalAccountNumber;
    }

    public void setLaborLedgerOriginalAccountNumber(String laborLedgerOriginalAccountNumber) {
        this.laborLedgerOriginalAccountNumber = laborLedgerOriginalAccountNumber;
    }

    @Override
    public String getLaborLedgerOriginalSubAccountNumber() {
        return this.laborLedgerOriginalSubAccountNumber;
    }

    public void setLaborLedgerOriginalSubAccountNumber(String laborLedgerOriginalSubAccountNumber) {
        this.laborLedgerOriginalSubAccountNumber = laborLedgerOriginalSubAccountNumber;
    }

    @Override
    public String getLaborLedgerOriginalFinancialObjectCode() {
        return this.laborLedgerOriginalFinancialObjectCode;
    }

    public void setLaborLedgerOriginalFinancialObjectCode(String laborLedgerOriginalFinancialObjectCode) {
        this.laborLedgerOriginalFinancialObjectCode = laborLedgerOriginalFinancialObjectCode;
    }

    @Override
    public String getLaborLedgerOriginalFinancialSubObjectCode() {
        return this.laborLedgerOriginalFinancialSubObjectCode;
    }

    public void setLaborLedgerOriginalFinancialSubObjectCode(String laborLedgerOriginalFinancialSubObjectCode) {
        this.laborLedgerOriginalFinancialSubObjectCode = laborLedgerOriginalFinancialSubObjectCode;
    }

    @Override
    public String getHrmsCompany() {
        return this.hrmsCompany;
    }

    public void setHrmsCompany(String hrmsCompany) {
        this.hrmsCompany = hrmsCompany;
    }

    @Override
    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String setid) {
        this.setid = setid;
    }

    public Date getTransactionDateTimeStamp() {
        return this.transactionDateTimeStamp;
    }

    public void setTransactionDateTimeStamp(Date transactionDateTimeStamp) {
        this.transactionDateTimeStamp = transactionDateTimeStamp;
    }

    @Override
    public AccountingPeriod getPayrollEndDateFiscalPeriod() {
        return this.payrollEndDateFiscalPeriod;
    }

    public void setPayrollEndDateFiscalPeriod(AccountingPeriod payrollEndDateFiscalPeriod) {
        this.payrollEndDateFiscalPeriod = payrollEndDateFiscalPeriod;
    }

    @Override
    public DocumentType getReferenceFinancialSystemDocumentType() {
        this.referenceFinancialSystemDocumentType = ((DocumentTypeService)SpringContext.getBean(DocumentTypeService.class)).updateDocumentTypeIfNecessary(this.referenceFinancialDocumentTypeCode, this.referenceFinancialSystemDocumentType);
        return this.referenceFinancialSystemDocumentType;
    }

    @Override
    public OriginationCode getReferenceFinancialSystemOrigination() {
        return this.referenceFinancialSystemOrigination;
    }

    public void setReferenceFinancialSystemOrigination(OriginationCode referenceFinancialSystemOrigination) {
        this.referenceFinancialSystemOrigination = referenceFinancialSystemOrigination;
    }

    public void clearTransactionTotalHours() {
        this.transactionTotalHours = null;
    }

    public String getLine() {
        StringBuilder sb = new StringBuilder();
        Map lMap = LaborOriginEntry.getLaborOriginEntryFieldUtil().getFieldLengthMap();
        Map pMap = LaborOriginEntry.getLaborOriginEntryFieldUtil().getFieldBeginningPositionMap();
        int entryLength = (Integer)pMap.get("setid") + (Integer)lMap.get("setid");
        if (this.universityFiscalYear == null) {
            sb.append(GeneralLedgerConstants.getSpaceUniversityFiscalYear());
        } else {
            sb.append(this.universityFiscalYear);
        }
        sb.append(this.getField((Integer)lMap.get("chartOfAccountsCode"), this.chartOfAccountsCode));
        sb.append(this.getField((Integer)lMap.get("accountNumber"), this.accountNumber));
        sb.append(this.getField((Integer)lMap.get("subAccountNumber"), this.subAccountNumber));
        sb.append(this.getField((Integer)lMap.get("financialObjectCode"), this.financialObjectCode));
        sb.append(this.getField((Integer)lMap.get("financialSubObjectCode"), this.financialSubObjectCode));
        sb.append(this.getField((Integer)lMap.get("financialBalanceTypeCode"), this.financialBalanceTypeCode));
        sb.append(this.getField((Integer)lMap.get("financialObjectTypeCode"), this.financialObjectTypeCode));
        sb.append(this.getField((Integer)lMap.get("universityFiscalPeriodCode"), this.universityFiscalPeriodCode));
        sb.append(this.getField((Integer)lMap.get("financialDocumentTypeCode"), this.financialDocumentTypeCode));
        sb.append(this.getField((Integer)lMap.get("financialSystemOriginationCode"), this.financialSystemOriginationCode));
        sb.append(this.getField((Integer)lMap.get("documentNumber"), this.documentNumber));
        String seqNum = "";
        if (this.transactionLedgerEntrySequenceNumber != null) {
            seqNum = this.transactionLedgerEntrySequenceNumber.toString();
        }
        sb.append(StringUtils.leftPad((String)seqNum.trim(), (int)((Integer)lMap.get("transactionLedgerEntrySequenceNumber")), (String)"0"));
        sb.append(this.getField((Integer)lMap.get("positionNumber"), this.positionNumber));
        sb.append(this.getField((Integer)lMap.get("projectCode"), this.projectCode));
        sb.append(this.getField((Integer)lMap.get("transactionLedgerEntryDescription"), this.transactionLedgerEntryDescription));
        if (this.transactionLedgerEntryAmount == null) {
            sb.append(GeneralLedgerConstants.getZeroTransactionLedgerEntryAmount());
        } else {
            String a = ((KualiDecimal)this.transactionLedgerEntryAmount.abs()).toString();
            if (this.transactionLedgerEntryAmount.isNegative()) {
                sb.append("-");
            } else {
                sb.append("+");
            }
            sb.append(GeneralLedgerConstants.getZeroTransactionLedgerEntryAmount(), 1, (Integer)lMap.get("transactionLedgerEntryAmount") - a.length());
            sb.append(a);
        }
        sb.append(this.getField((Integer)lMap.get("transactionDebitCreditCode"), this.transactionDebitCreditCode));
        sb.append(this.formatDate(this.transactionDate));
        sb.append(this.getField((Integer)lMap.get("organizationDocumentNumber"), this.organizationDocumentNumber));
        sb.append(this.getField((Integer)lMap.get("organizationReferenceId"), this.organizationReferenceId));
        sb.append(this.getField((Integer)lMap.get("referenceFinancialDocumentTypeCode"), this.referenceFinancialDocumentTypeCode));
        sb.append(this.getField((Integer)lMap.get("referenceFinancialSystemOriginationCode"), this.referenceFinancialSystemOriginationCode));
        sb.append(this.getField((Integer)lMap.get("referenceFinancialDocumentNumber"), this.referenceFinancialDocumentNumber));
        sb.append(this.formatDate(this.financialDocumentReversalDate));
        sb.append(this.getField((Integer)lMap.get("transactionEncumbranceUpdateCode"), this.transactionEncumbranceUpdateCode));
        sb.append(this.formatDate(this.transactionPostingDate));
        sb.append(this.formatDate(this.payPeriodEndDate));
        if (this.transactionTotalHours == null) {
            sb.append(StringUtils.rightPad((String)"", (int)((Integer)lMap.get("transactionTotalHours")), (String)" "));
        } else {
            String totalhour = this.getField((Integer)lMap.get("transactionTotalHours"), this.transactionTotalHours.toString());
            sb.append(StringUtils.leftPad((String)totalhour.trim(), (int)((Integer)lMap.get("transactionTotalHours")), (String)" "));
        }
        if (this.payrollEndDateFiscalYear == null) {
            sb.append(StringUtils.rightPad((String)"", (int)((Integer)lMap.get("payrollEndDateFiscalYear")), (String)" "));
        } else {
            sb.append(this.getField((Integer)lMap.get("payrollEndDateFiscalYear"), this.payrollEndDateFiscalYear.toString()));
        }
        sb.append(this.getField((Integer)lMap.get("payrollEndDateFiscalPeriodCode"), this.payrollEndDateFiscalPeriodCode));
        sb.append(this.getField((Integer)lMap.get("emplid"), this.emplid));
        if (this.employeeRecord == null) {
            sb.append(StringUtils.rightPad((String)"", (int)((Integer)lMap.get("employeeRecord")), (String)" "));
        } else {
            String empRecord = this.getField((Integer)lMap.get("employeeRecord"), this.employeeRecord.toString());
            sb.append(StringUtils.leftPad((String)empRecord.trim(), (int)((Integer)lMap.get("employeeRecord")), (String)" "));
        }
        sb.append(this.getField((Integer)lMap.get("earnCode"), this.earnCode));
        sb.append(this.getField((Integer)lMap.get("payGroup"), this.payGroup));
        sb.append(this.getField((Integer)lMap.get("salaryAdministrationPlan"), this.salaryAdministrationPlan));
        sb.append(this.getField((Integer)lMap.get("grade"), this.grade));
        sb.append(this.getField((Integer)lMap.get("runIdentifier"), this.runIdentifier));
        sb.append(this.getField((Integer)lMap.get("laborLedgerOriginalChartOfAccountsCode"), this.laborLedgerOriginalChartOfAccountsCode));
        sb.append(this.getField((Integer)lMap.get("laborLedgerOriginalAccountNumber"), this.laborLedgerOriginalAccountNumber));
        sb.append(this.getField((Integer)lMap.get("laborLedgerOriginalSubAccountNumber"), this.laborLedgerOriginalSubAccountNumber));
        sb.append(this.getField((Integer)lMap.get("laborLedgerOriginalFinancialObjectCode"), this.laborLedgerOriginalFinancialObjectCode));
        sb.append(this.getField((Integer)lMap.get("laborLedgerOriginalFinancialSubObjectCode"), this.laborLedgerOriginalFinancialSubObjectCode));
        sb.append(this.getField((Integer)lMap.get("hrmsCompany"), this.hrmsCompany));
        sb.append(this.getField((Integer)lMap.get("setid"), this.setid));
        while (entryLength > sb.toString().length()) {
            sb.append(' ');
        }
        Matcher controlCharacterMatcher = MATCH_CONTROL_CHARACTERS.matcher(sb);
        return controlCharacterMatcher.replaceAll(" ");
    }

    public List<Message> setFromTextFileForBatch(String line, int lineNumber) {
        Account account;
        ArrayList<Message> returnList = new ArrayList<Message>();
        Map pMap = LaborOriginEntry.getLaborOriginEntryFieldUtil().getFieldBeginningPositionMap();
        Map lMap = LaborOriginEntry.getLaborOriginEntryFieldUtil().getFieldLengthMap();
        int entryLength = (Integer)pMap.get("setid") + (Integer)lMap.get("setid");
        Matcher controlCharacterMatcher = MATCH_CONTROL_CHARACTERS.matcher(line);
        line = controlCharacterMatcher.replaceAll(" ");
        line = StringUtils.rightPad((String)line, (int)entryLength, (char)' ');
        String fiscalYearString = line.substring((Integer)pMap.get("universityFiscalYear"), (Integer)pMap.get("chartOfAccountsCode"));
        if (!GeneralLedgerConstants.getSpaceUniversityFiscalYear().equals(fiscalYearString)) {
            try {
                this.setUniversityFiscalYear(Integer.valueOf(fiscalYearString));
            }
            catch (NumberFormatException e) {
                returnList.add(new Message("Fiscal year '" + fiscalYearString + "' contains an invalid value.", 1));
                this.setUniversityFiscalYear(null);
            }
        } else {
            this.setUniversityFiscalYear(null);
        }
        this.setChartOfAccountsCode(this.getValue(line, (Integer)pMap.get("chartOfAccountsCode"), (Integer)pMap.get("accountNumber")));
        this.setAccountNumber(this.getValue(line, (Integer)pMap.get("accountNumber"), (Integer)pMap.get("subAccountNumber")));
        AccountService acctserv = (AccountService)SpringContext.getBean(AccountService.class);
        if (StringUtils.isEmpty((CharSequence)this.getChartOfAccountsCode()) && StringUtils.isNotEmpty((CharSequence)this.getAccountNumber()) && !acctserv.accountsCanCrossCharts() && (account = acctserv.getUniqueAccountForAccountNumber(this.getAccountNumber())) != null) {
            this.setChartOfAccountsCode(account.getChartOfAccountsCode());
        }
        this.setSubAccountNumber(this.getValue(line, (Integer)pMap.get("subAccountNumber"), (Integer)pMap.get("financialObjectCode")));
        this.setFinancialObjectCode(this.getValue(line, (Integer)pMap.get("financialObjectCode"), (Integer)pMap.get("financialSubObjectCode")));
        this.setFinancialSubObjectCode(this.getValue(line, (Integer)pMap.get("financialSubObjectCode"), (Integer)pMap.get("financialBalanceTypeCode")));
        this.setFinancialBalanceTypeCode(this.getValue(line, (Integer)pMap.get("financialBalanceTypeCode"), (Integer)pMap.get("financialObjectTypeCode")));
        this.setFinancialObjectTypeCode(this.getValue(line, (Integer)pMap.get("financialObjectTypeCode"), (Integer)pMap.get("universityFiscalPeriodCode")));
        this.setUniversityFiscalPeriodCode(this.getValue(line, (Integer)pMap.get("universityFiscalPeriodCode"), (Integer)pMap.get("financialDocumentTypeCode")));
        this.setFinancialDocumentTypeCode(this.getValue(line, (Integer)pMap.get("financialDocumentTypeCode"), (Integer)pMap.get("financialSystemOriginationCode")));
        this.setFinancialSystemOriginationCode(this.getValue(line, (Integer)pMap.get("financialSystemOriginationCode"), (Integer)pMap.get("documentNumber")));
        this.setDocumentNumber(this.getValue(line, (Integer)pMap.get("documentNumber"), (Integer)pMap.get("transactionLedgerEntrySequenceNumber")));
        String sequenceNumberString = line.substring((Integer)pMap.get("transactionLedgerEntrySequenceNumber"), (Integer)pMap.get("positionNumber"));
        if (!GeneralLedgerConstants.getSpaceTransactionEntrySequenceNumber().equals(sequenceNumberString) && !GeneralLedgerConstants.getZeroTransactionEntrySequenceNumber().equals(sequenceNumberString)) {
            try {
                this.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceNumberString.trim()));
            }
            catch (NumberFormatException e) {
                returnList.add(new Message("Transaction Sequence Number '" + sequenceNumberString + "' contains an invalid value.", 1));
                this.setTransactionLedgerEntrySequenceNumber(null);
            }
        } else {
            this.setTransactionLedgerEntrySequenceNumber(null);
        }
        this.setPositionNumber(this.getValue(line, (Integer)pMap.get("positionNumber"), (Integer)pMap.get("projectCode")));
        this.setProjectCode(this.getValue(line, (Integer)pMap.get("projectCode"), (Integer)pMap.get("transactionLedgerEntryDescription")));
        this.setTransactionLedgerEntryDescription(this.getValue(line, (Integer)pMap.get("transactionLedgerEntryDescription"), (Integer)pMap.get("transactionLedgerEntryAmount")));
        String amountString = line.substring((Integer)pMap.get("transactionLedgerEntryAmount"), (Integer)pMap.get("transactionDebitCreditCode"));
        if (!amountString.trim().equals("")) {
            try {
                this.setTransactionLedgerEntryAmount(new KualiDecimal(amountString.trim()));
            }
            catch (NumberFormatException e) {
                returnList.add(new Message("Transaction Amount '" + amountString + "' contains an invalid value.", 1));
                this.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
            }
        } else {
            returnList.add(new Message("Transaction Amount cannot be blank.", 1));
            this.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        }
        this.setTransactionDebitCreditCode(line.substring((Integer)pMap.get("transactionDebitCreditCode"), (Integer)pMap.get("transactionDate")));
        String transactionDateString = line.substring((Integer)pMap.get("transactionDate"), (Integer)pMap.get("organizationDocumentNumber"));
        if (!transactionDateString.trim().equals("")) {
            try {
                this.setTransactionDate(this.parseDate(transactionDateString.stripTrailing(), false));
            }
            catch (ParseException e) {
                this.setTransactionDate(null);
                returnList.add(new Message("Transaction Date '" + transactionDateString + "' contains an invalid value.", 1));
            }
        } else {
            this.setTransactionDate(null);
        }
        this.setOrganizationDocumentNumber(this.getValue(line, (Integer)pMap.get("organizationDocumentNumber"), (Integer)pMap.get("organizationReferenceId")));
        this.setOrganizationReferenceId(this.getValue(line, (Integer)pMap.get("organizationReferenceId"), (Integer)pMap.get("referenceFinancialDocumentTypeCode")));
        this.setReferenceFinancialDocumentTypeCode(this.getValue(line, (Integer)pMap.get("referenceFinancialDocumentTypeCode"), (Integer)pMap.get("referenceFinancialSystemOriginationCode")));
        this.setReferenceFinancialSystemOriginationCode(this.getValue(line, (Integer)pMap.get("referenceFinancialSystemOriginationCode"), (Integer)pMap.get("referenceFinancialDocumentNumber")));
        this.setReferenceFinancialDocumentNumber(this.getValue(line, (Integer)pMap.get("referenceFinancialDocumentNumber"), (Integer)pMap.get("financialDocumentReversalDate")));
        String revDateStr = line.substring((Integer)pMap.get("financialDocumentReversalDate"), (Integer)pMap.get("transactionEncumbranceUpdateCode"));
        if (!revDateStr.trim().equals("")) {
            try {
                this.setFinancialDocumentReversalDate(this.parseDate(revDateStr.stripTrailing(), false));
            }
            catch (ParseException e) {
                this.setFinancialDocumentReversalDate(null);
                returnList.add(new Message("Reversal Date '" + revDateStr + "' contains an invalid value.", 1));
            }
        } else {
            this.setFinancialDocumentReversalDate(null);
        }
        this.setTransactionEncumbranceUpdateCode(line.substring((Integer)pMap.get("transactionEncumbranceUpdateCode"), (Integer)pMap.get("transactionPostingDate")));
        String postDateStr = line.substring((Integer)pMap.get("transactionPostingDate"), (Integer)pMap.get("payPeriodEndDate"));
        if (!postDateStr.trim().equals("")) {
            try {
                this.setTransactionPostingDate(this.parseDate(postDateStr.stripTrailing(), false));
            }
            catch (ParseException e) {
                this.setTransactionPostingDate(null);
                returnList.add(new Message("Transaction Posting Date '" + postDateStr + "' contains an invalid value.", 1));
            }
        } else {
            this.setTransactionPostingDate(null);
        }
        String payPeriodDateStr = line.substring((Integer)pMap.get("payPeriodEndDate"), (Integer)pMap.get("transactionTotalHours"));
        if (!payPeriodDateStr.trim().equals("")) {
            try {
                this.setPayPeriodEndDate(this.parseDate(payPeriodDateStr.stripTrailing(), false));
            }
            catch (ParseException e) {
                this.setPayPeriodEndDate(null);
                returnList.add(new Message("Pay Period End Date '" + payPeriodDateStr + "' contains an invalid value.", 1));
            }
        } else {
            this.setPayPeriodEndDate(null);
        }
        String transTotHrsStr = line.substring((Integer)pMap.get("transactionTotalHours"), (Integer)pMap.get("payrollEndDateFiscalYear"));
        if (!transTotHrsStr.trim().equals("")) {
            try {
                this.setTransactionTotalHours(new BigDecimal(transTotHrsStr.trim()));
            }
            catch (NumberFormatException e) {
                this.setTransactionTotalHours(null);
                returnList.add(new Message("Transaction Total Hours '" + transTotHrsStr.trim() + "' contains an invalid value.", 1));
            }
        } else {
            this.setTransactionTotalHours(null);
        }
        String payEndFisYrStr = line.substring((Integer)pMap.get("payrollEndDateFiscalYear"), (Integer)pMap.get("payrollEndDateFiscalPeriodCode"));
        if (!GeneralLedgerConstants.getSpaceUniversityFiscalYear().equals(payEndFisYrStr)) {
            try {
                this.setPayrollEndDateFiscalYear(Integer.valueOf(payEndFisYrStr.stripTrailing()));
            }
            catch (NumberFormatException e) {
                returnList.add(new Message("Payroll End Date Fiscal Year '" + payEndFisYrStr + "' contains an invalid value.", 1));
                this.setPayrollEndDateFiscalYear(null);
            }
        } else {
            this.setPayrollEndDateFiscalYear(null);
        }
        this.setPayrollEndDateFiscalPeriodCode(this.getValue(line, (Integer)pMap.get("payrollEndDateFiscalPeriodCode"), (Integer)pMap.get("emplid")));
        this.setEmplid(this.getValue(line, (Integer)pMap.get("emplid"), (Integer)pMap.get("employeeRecord")));
        String empRecordStr = line.substring((Integer)pMap.get("employeeRecord"), (Integer)pMap.get("earnCode"));
        if (!empRecordStr.trim().equals("")) {
            try {
                this.setEmployeeRecord(Integer.valueOf(empRecordStr.trim()));
            }
            catch (NumberFormatException e) {
                returnList.add(new Message("Employee Record '" + empRecordStr.trim() + "' contains an invalid value.", 1));
                this.setEmployeeRecord(null);
            }
        } else {
            this.setEmployeeRecord(null);
        }
        this.setEarnCode(this.getValue(line, (Integer)pMap.get("earnCode"), (Integer)pMap.get("payGroup")));
        this.setPayGroup(this.getValue(line, (Integer)pMap.get("payGroup"), (Integer)pMap.get("salaryAdministrationPlan")));
        this.setSalaryAdministrationPlan(this.getValue(line, (Integer)pMap.get("salaryAdministrationPlan"), (Integer)pMap.get("grade")));
        this.setGrade(this.getValue(line, (Integer)pMap.get("grade"), (Integer)pMap.get("runIdentifier")));
        this.setRunIdentifier(this.getValue(line, (Integer)pMap.get("runIdentifier"), (Integer)pMap.get("laborLedgerOriginalChartOfAccountsCode")));
        this.setLaborLedgerOriginalChartOfAccountsCode(this.getValue(line, (Integer)pMap.get("laborLedgerOriginalChartOfAccountsCode"), (Integer)pMap.get("laborLedgerOriginalAccountNumber")));
        this.setLaborLedgerOriginalAccountNumber(this.getValue(line, (Integer)pMap.get("laborLedgerOriginalAccountNumber"), (Integer)pMap.get("laborLedgerOriginalSubAccountNumber")));
        this.setLaborLedgerOriginalSubAccountNumber(this.getValue(line, (Integer)pMap.get("laborLedgerOriginalSubAccountNumber"), (Integer)pMap.get("laborLedgerOriginalFinancialObjectCode")));
        this.setLaborLedgerOriginalFinancialObjectCode(this.getValue(line, (Integer)pMap.get("laborLedgerOriginalFinancialObjectCode"), (Integer)pMap.get("laborLedgerOriginalFinancialSubObjectCode")));
        this.setLaborLedgerOriginalFinancialSubObjectCode(this.getValue(line, (Integer)pMap.get("laborLedgerOriginalFinancialSubObjectCode"), (Integer)pMap.get("hrmsCompany")));
        this.setHrmsCompany(this.getValue(line, (Integer)pMap.get("hrmsCompany"), (Integer)pMap.get("setid")));
        this.setSetid(this.getValue(line, (Integer)pMap.get("setid"), entryLength));
        return returnList;
    }

    public Object getFieldValue(String fieldName) {
        if ("universityFiscalYear".equals(fieldName)) {
            return this.getUniversityFiscalYear();
        }
        if ("chartOfAccountsCode".equals(fieldName)) {
            return this.getChartOfAccountsCode();
        }
        if ("accountNumber".equals(fieldName)) {
            return this.getAccountNumber();
        }
        if ("subAccountNumber".equals(fieldName)) {
            return this.getSubAccountNumber();
        }
        if ("financialObjectCode".equals(fieldName)) {
            return this.getFinancialObjectCode();
        }
        if ("financialSubObjectCode".equals(fieldName)) {
            return this.getFinancialSubObjectCode();
        }
        if ("financialBalanceTypeCode".equals(fieldName)) {
            return this.getFinancialBalanceTypeCode();
        }
        if ("financialObjectTypeCode".equals(fieldName)) {
            return this.getFinancialObjectTypeCode();
        }
        if ("universityFiscalPeriodCode".equals(fieldName)) {
            return this.getUniversityFiscalPeriodCode();
        }
        if ("financialDocumentTypeCode".equals(fieldName)) {
            return this.getFinancialDocumentTypeCode();
        }
        if ("financialSystemOriginationCode".equals(fieldName)) {
            return this.getFinancialSystemOriginationCode();
        }
        if ("documentNumber".equals(fieldName)) {
            return this.getDocumentNumber();
        }
        if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
            return this.getTransactionLedgerEntrySequenceNumber();
        }
        if ("positionNumber".equals(fieldName)) {
            return this.getPositionNumber();
        }
        if ("transactionLedgerEntryDescription".equals(fieldName)) {
            return this.getTransactionLedgerEntryDescription();
        }
        if ("transactionLedgerEntryAmount".equals(fieldName)) {
            return this.getTransactionLedgerEntryAmount();
        }
        if ("transactionDebitCreditCode".equals(fieldName)) {
            return this.getTransactionDebitCreditCode();
        }
        if ("transactionDate".equals(fieldName)) {
            return this.getTransactionDate();
        }
        if ("organizationDocumentNumber".equals(fieldName)) {
            return this.getOrganizationDocumentNumber();
        }
        if ("projectCode".equals(fieldName)) {
            return this.getProjectCode();
        }
        if ("organizationReferenceId".equals(fieldName)) {
            return this.getOrganizationReferenceId();
        }
        if ("referenceFinancialDocumentTypeCode".equals(fieldName)) {
            return this.getReferenceFinancialDocumentTypeCode();
        }
        if ("referenceFinancialSystemOriginationCode".equals(fieldName)) {
            return this.getReferenceFinancialSystemOriginationCode();
        }
        if ("referenceFinancialDocumentNumber".equals(fieldName)) {
            return this.getReferenceFinancialDocumentNumber();
        }
        if ("financialDocumentReversalDate".equals(fieldName)) {
            return this.getFinancialDocumentReversalDate();
        }
        if ("transactionEncumbranceUpdateCode".equals(fieldName)) {
            return this.getTransactionEncumbranceUpdateCode();
        }
        if ("transactionPostingDate".equals(fieldName)) {
            return this.getTransactionPostingDate();
        }
        if ("payPeriodEndDate".equals(fieldName)) {
            return this.getPayPeriodEndDate();
        }
        if ("transactionTotalHours".equals(fieldName)) {
            return this.getTransactionTotalHours();
        }
        if ("payrollEndDateFiscalYear".equals(fieldName)) {
            return this.getPayrollEndDateFiscalYear();
        }
        if ("payrollEndDateFiscalPeriodCode".equals(fieldName)) {
            return this.getPayrollEndDateFiscalPeriodCode();
        }
        if ("financialDocumentApprovedCode".equals(fieldName)) {
            return this.getFinancialDocumentApprovedCode();
        }
        if ("transactionEntryOffsetCode".equals(fieldName)) {
            return this.getTransactionEntryOffsetCode();
        }
        if ("financialDocumentApprovedCode".equals(fieldName)) {
            return this.getFinancialDocumentApprovedCode();
        }
        if ("transactionEntryProcessedTimestamp".equals(fieldName)) {
            return this.getTransactionEntryProcessedTimestamp();
        }
        if ("emplid".equals(fieldName)) {
            return this.getEmplid();
        }
        if ("employeeRecord".equals(fieldName)) {
            return this.getEmployeeRecord();
        }
        if ("earnCode".equals(fieldName)) {
            return this.getEarnCode();
        }
        if ("payGroup".equals(fieldName)) {
            return this.getPayGroup();
        }
        if ("salaryAdministrationPlan".equals(fieldName)) {
            return this.getSalaryAdministrationPlan();
        }
        if ("grade".equals(fieldName)) {
            return this.getGrade();
        }
        if ("runIdentifier".equals(fieldName)) {
            return this.getRunIdentifier();
        }
        if ("laborLedgerOriginalChartOfAccountsCode".equals(fieldName)) {
            return this.getLaborLedgerOriginalChartOfAccountsCode();
        }
        if ("laborLedgerOriginalAccountNumber".equals(fieldName)) {
            return this.getLaborLedgerOriginalAccountNumber();
        }
        if ("laborLedgerOriginalSubAccountNumber".equals(fieldName)) {
            return this.getLaborLedgerOriginalSubAccountNumber();
        }
        if ("laborLedgerOriginalFinancialObjectCode".equals(fieldName)) {
            return this.getLaborLedgerOriginalFinancialObjectCode();
        }
        if ("laborLedgerOriginalFinancialSubObjectCode".equals(fieldName)) {
            return this.getLaborLedgerOriginalFinancialSubObjectCode();
        }
        if ("hrmsCompany".equals(fieldName)) {
            return this.getHrmsCompany();
        }
        if ("setid".equals(fieldName)) {
            return this.getSetid();
        }
        throw new IllegalArgumentException("Invalid Field Name " + fieldName);
    }

    public void setFieldValue(String fieldName, String fieldValue) {
        if ("universityFiscalYear".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setUniversityFiscalYear(Integer.parseInt(fieldValue));
            } else {
                this.setUniversityFiscalYear(null);
            }
        } else if ("chartOfAccountsCode".equals(fieldName)) {
            this.setChartOfAccountsCode(fieldValue);
        } else if ("accountNumber".equals(fieldName)) {
            this.setAccountNumber(fieldValue);
        } else if ("subAccountNumber".equals(fieldName)) {
            this.setSubAccountNumber(fieldValue);
        } else if ("financialObjectCode".equals(fieldName)) {
            this.setFinancialObjectCode(fieldValue);
        } else if ("financialSubObjectCode".equals(fieldName)) {
            this.setFinancialSubObjectCode(fieldValue);
        } else if ("financialBalanceTypeCode".equals(fieldName)) {
            this.setFinancialBalanceTypeCode(fieldValue);
        } else if ("financialObjectTypeCode".equals(fieldName)) {
            this.setFinancialObjectTypeCode(fieldValue);
        } else if ("universityFiscalPeriodCode".equals(fieldName)) {
            this.setUniversityFiscalPeriodCode(fieldValue);
        } else if ("financialDocumentTypeCode".equals(fieldName)) {
            this.setFinancialDocumentTypeCode(fieldValue);
        } else if ("financialSystemOriginationCode".equals(fieldName)) {
            this.setFinancialSystemOriginationCode(fieldValue);
        } else if ("documentNumber".equals(fieldName)) {
            this.setDocumentNumber(fieldValue);
        } else if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setTransactionLedgerEntrySequenceNumber(Integer.parseInt(fieldValue));
            } else {
                this.setTransactionLedgerEntrySequenceNumber(null);
            }
        } else if ("positionNumber".equals(fieldName)) {
            this.setPositionNumber(fieldValue);
        } else if ("projectCode".equals(fieldName)) {
            this.setProjectCode(fieldValue);
        } else if ("transactionLedgerEntryDescription".equals(fieldName)) {
            this.setTransactionLedgerEntryDescription(fieldValue);
        } else if ("transactionLedgerEntryAmount".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setTransactionLedgerEntryAmount(new KualiDecimal(fieldValue));
            } else {
                this.clearTransactionLedgerEntryAmount();
            }
        } else if ("transactionDebitCreditCode".equals(fieldName)) {
            this.setTransactionDebitCreditCode(fieldValue);
        } else if ("transactionDate".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    this.setTransactionDate(new Date(df.parse(fieldValue).getTime()));
                }
                catch (ParseException e) {
                    this.setTransactionDate(null);
                }
            } else {
                this.setTransactionDate(null);
            }
        } else if ("organizationDocumentNumber".equals(fieldName)) {
            this.setOrganizationDocumentNumber(fieldValue);
        } else if ("organizationReferenceId".equals(fieldName)) {
            this.setOrganizationReferenceId(fieldValue);
        } else if ("referenceFinancialDocumentTypeCode".equals(fieldName)) {
            this.setReferenceFinancialDocumentTypeCode(fieldValue);
        } else if ("referenceFinancialSystemOriginationCode".equals(fieldName)) {
            this.setReferenceFinancialSystemOriginationCode(fieldValue);
        } else if ("referenceFinancialDocumentNumber".equals(fieldName)) {
            this.setReferenceFinancialDocumentNumber(fieldValue);
        } else if ("financialDocumentReversalDate".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    this.setFinancialDocumentReversalDate(new Date(df.parse(fieldValue).getTime()));
                }
                catch (ParseException e) {
                    this.setFinancialDocumentReversalDate(null);
                }
            } else {
                this.setFinancialDocumentReversalDate(null);
            }
        } else if ("transactionEncumbranceUpdateCode".equals(fieldName)) {
            this.setTransactionEncumbranceUpdateCode(fieldValue);
        } else if ("transactionPostingDate".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    this.setTransactionPostingDate(new Date(df.parse(fieldValue).getTime()));
                }
                catch (ParseException e) {
                    this.setTransactionPostingDate(null);
                }
            } else {
                this.setTransactionPostingDate(null);
            }
        } else if ("payPeriodEndDate".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    this.setPayPeriodEndDate(new Date(df.parse(fieldValue).getTime()));
                }
                catch (ParseException e) {
                    this.setPayPeriodEndDate(null);
                }
            } else {
                this.setPayPeriodEndDate(null);
            }
        } else if ("transactionTotalHours".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setTransactionTotalHours(new BigDecimal(fieldValue));
            } else {
                this.clearTransactionTotalHours();
            }
        } else if ("payrollEndDateFiscalYear".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setPayrollEndDateFiscalYear(Integer.parseInt(fieldValue));
            } else {
                this.setPayrollEndDateFiscalYear(null);
            }
        } else if ("payrollEndDateFiscalPeriodCode".equals(fieldName)) {
            this.setPayrollEndDateFiscalPeriodCode(fieldValue);
        } else if ("emplid".equals(fieldName)) {
            this.setEmplid(fieldValue);
        } else if ("employeeRecord".equals(fieldName)) {
            if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                this.setEmployeeRecord(Integer.parseInt(fieldValue));
            } else {
                this.setEmployeeRecord(null);
            }
        } else if ("earnCode".equals(fieldName)) {
            this.setEarnCode(fieldValue);
        } else if ("payGroup".equals(fieldName)) {
            this.setPayGroup(fieldValue);
        } else if ("salaryAdministrationPlan".equals(fieldName)) {
            this.setSalaryAdministrationPlan(fieldValue);
        } else if ("grade".equals(fieldName)) {
            this.setGrade(fieldValue);
        } else if ("runIdentifier".equals(fieldName)) {
            this.setRunIdentifier(fieldValue);
        } else if ("laborLedgerOriginalChartOfAccountsCode".equals(fieldName)) {
            this.setLaborLedgerOriginalChartOfAccountsCode(fieldValue);
        } else if ("laborLedgerOriginalAccountNumber".equals(fieldName)) {
            this.setLaborLedgerOriginalAccountNumber(fieldValue);
        } else if ("laborLedgerOriginalSubAccountNumber".equals(fieldName)) {
            this.setLaborLedgerOriginalSubAccountNumber(fieldValue);
        } else if ("laborLedgerOriginalFinancialObjectCode".equals(fieldName)) {
            this.setLaborLedgerOriginalFinancialObjectCode(fieldValue);
        } else if ("laborLedgerOriginalFinancialSubObjectCode".equals(fieldName)) {
            this.setLaborLedgerOriginalFinancialSubObjectCode(fieldValue);
        } else if ("hrmsCompany".equals(fieldName)) {
            this.setHrmsCompany(fieldValue);
        } else if ("setid".equals(fieldName)) {
            this.setSetid(fieldValue);
        } else {
            throw new IllegalArgumentException("Invalid Field Name " + fieldName);
        }
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return LaborConstants.getSpaceTransactionDate();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        return sdf.format(date);
    }

    protected static LaborOriginEntryFieldUtil getLaborOriginEntryFieldUtil() {
        if (laborOriginEntryFieldUtil == null) {
            laborOriginEntryFieldUtil = new LaborOriginEntryFieldUtil();
        }
        return laborOriginEntryFieldUtil;
    }
}

