/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.businessobject.TransientBalanceInquiryAttributes;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.July1PositionFunding;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.inquiry.CurrentFundsInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.dataaccess.LaborDao;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ObjectUtil;

public class CurrentFundsLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    private static final String USING_TEMPLATE = "using {}";
    private static final String REMOVING_RECORD_FROM_THE_COLLECTION = "Removing record {} from the collection.";
    private static final String MARKING_RECORD_FOR_REMOVAL_FROM_THE_COLLECTION = "Marking record [{}, {}, {}, {}]  for removal from the collection.";
    private static final String COULD_NOT_INSTANTIATE_CLASS = "Using {} for results because I couldn't instantiate the {}";
    private LaborDao laborDao;
    private LaborInquiryOptionsService laborInquiryOptionsService;
    private BusinessObjectService businessObjectService;

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("positionNumber".equals(propertyName)) {
            LedgerBalance balance = (LedgerBalance)bo;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, balance.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new CurrentFundsInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LOG.info("getSearchResults() - Entry");
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        boolean isConsolidated = this.laborInquiryOptionsService.isConsolidationSelected(fieldValues, this.getRows());
        String searchObjectCodeVal = fieldValues.get("financialObjectCode");
        if (StringUtils.isNotBlank((CharSequence)searchObjectCodeVal)) {
            HashMap<String, String> objectCodeFieldValues = new HashMap<String, String>();
            objectCodeFieldValues.put("universityFiscalYear", fieldValues.get("universityFiscalYear"));
            objectCodeFieldValues.put("chartOfAccountsCode", fieldValues.get("chartOfAccountsCode"));
            objectCodeFieldValues.put("financialObjectCode", searchObjectCodeVal);
            LaborLedgerObject foundObjectCode = (LaborLedgerObject)this.businessObjectService.findByPrimaryKey(LaborObject.class, objectCodeFieldValues);
            if (foundObjectCode == null) {
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.labor.invalidLaborObjectCodeError", new String[]{"2"});
                return new CollectionIncomplete(new ArrayList(), Long.valueOf(0L));
            }
        }
        Collection<AccountStatusCurrentFunds> searchResultsCollection = this.buildCurrentFundsCollection(IteratorUtils.toList((Iterator)this.laborDao.getCurrentFunds(fieldValues, isConsolidated)), isConsolidated, pendingEntryOption);
        this.laborInquiryOptionsService.updateCurrentFundsByPendingLedgerEntry(searchResultsCollection, fieldValues, pendingEntryOption, isConsolidated);
        Collection july1PositionFundings = this.laborDao.getJuly1(fieldValues);
        CurrentFundsLookupableHelperServiceImpl.updateJuly1BalanceAmount(searchResultsCollection, july1PositionFundings, isConsolidated);
        for (AccountStatusCurrentFunds cf : searchResultsCollection) {
            cf.setOutstandingEncum(this.getOutstandingEncum(cf, pendingEntryOption));
        }
        List<AccountStatusCurrentFunds> searchResults = CurrentFundsLookupableHelperServiceImpl.removeDupes((List)searchResultsCollection);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (!defaultSortColumns.isEmpty()) {
            searchResults.sort((Comparator<AccountStatusCurrentFunds>)new BeanPropertyComparator(defaultSortColumns, true));
        }
        long totalResults = searchResults.size();
        return new CollectionIncomplete(searchResults, Long.valueOf(totalResults));
    }

    private static void updateJuly1BalanceAmount(Collection<AccountStatusCurrentFunds> searchResultsCollection, Collection<? extends July1PositionFunding> july1PositionFundings, boolean isConsolidated) {
        for (July1PositionFunding july1PositionFunding : july1PositionFundings) {
            boolean flag = true;
            for (AccountStatusCurrentFunds accountStatus : searchResultsCollection) {
                boolean found = ObjectUtil.equals((Object)((Object)accountStatus), (Object)((Object)july1PositionFunding), accountStatus.getKeyFieldList(isConsolidated));
                if (!found) continue;
                flag = false;
                accountStatus.setJuly1BudgetAmount((KualiDecimal)accountStatus.getJuly1BudgetAmount().add((AbstractKualiDecimal)july1PositionFunding.getJuly1BudgetAmount()));
            }
            if (!flag) continue;
            AccountStatusCurrentFunds accountStatus = new AccountStatusCurrentFunds();
            ObjectUtil.buildObject((Object)((Object)accountStatus), (Object)((Object)july1PositionFunding), accountStatus.getKeyFieldList(isConsolidated));
            accountStatus.setJuly1BudgetAmount(july1PositionFunding.getJuly1BudgetAmount());
            accountStatus.setVariance(july1PositionFunding.getJuly1BudgetAmount());
            if (isConsolidated) {
                accountStatus.setSubAccountNumber("*ALL*");
                accountStatus.setFinancialSubObjectCode("*ALL*");
            } else {
                accountStatus.setSubAccountNumber(july1PositionFunding.getSubAccountNumber());
                accountStatus.setSubObjectCode(july1PositionFunding.getSubObjectCode());
            }
            searchResultsCollection.add(accountStatus);
        }
    }

    private Collection<AccountStatusCurrentFunds> buildCurrentFundsCollection(Collection<AccountStatusCurrentFunds> collection, boolean isConsolidated, String pendingEntryOption) {
        Collection<AccountStatusCurrentFunds> retval = isConsolidated ? this.buildConsolidatedCurrentFundsCollection(collection, pendingEntryOption) : CurrentFundsLookupableHelperServiceImpl.buildDetailedCurrentFundsCollection(collection, pendingEntryOption);
        for (AccountStatusCurrentFunds returnItem : retval) {
            if (returnItem.getBalanceTypeCode().equalsIgnoreCase("AC")) continue;
            returnItem.setAccountLineAnnualBalanceAmount(new KualiDecimal(0));
        }
        return retval;
    }

    private Collection<AccountStatusCurrentFunds> buildConsolidatedCurrentFundsCollection(Collection<AccountStatusCurrentFunds> collection, String pendingEntryOption) {
        ArrayList<AccountStatusCurrentFunds> retval = new ArrayList<AccountStatusCurrentFunds>();
        for (AccountStatusCurrentFunds collectionEntry : collection) {
            if (!((Object)((Object)collectionEntry)).getClass().isArray()) continue;
            int i = 0;
            Object[] collectionEntryAsArray = (Object[])collectionEntry;
            AccountStatusCurrentFunds cf = new AccountStatusCurrentFunds();
            LOG.debug("element length {}", (Object)collectionEntryAsArray.length);
            for (Object collectionEntryElement : collectionEntryAsArray) {
                LOG.debug("I found this element {}", collectionEntryElement);
            }
            if (AccountStatusCurrentFunds.class.isAssignableFrom(this.getBusinessObjectClass())) {
                try {
                    cf = (AccountStatusCurrentFunds)((Object)this.getBusinessObjectClass().newInstance());
                }
                catch (Exception e) {
                    LOG.warn(COULD_NOT_INSTANTIATE_CLASS, AccountStatusCurrentFunds.class, (Object)this.getBusinessObjectClass());
                }
            } else {
                LOG.warn(COULD_NOT_INSTANTIATE_CLASS, AccountStatusCurrentFunds.class, (Object)this.getBusinessObjectClass());
            }
            cf.setUniversityFiscalYear(Integer.valueOf(collectionEntryAsArray[i++].toString()));
            cf.setChartOfAccountsCode(collectionEntryAsArray[i++].toString());
            cf.setAccountNumber(collectionEntryAsArray[i++].toString());
            String subAccountNumber = "*ALL*";
            cf.setSubAccountNumber("*ALL*");
            cf.setBalanceTypeCode(collectionEntryAsArray[i++].toString());
            cf.setFinancialObjectCode(collectionEntryAsArray[i++].toString());
            cf.setEmplid(collectionEntryAsArray[i++].toString());
            cf.setPositionNumber(collectionEntryAsArray[i++].toString());
            cf.setFinancialSubObjectCode("*ALL*");
            cf.setObjectTypeCode("*ALL*");
            if (cf.getBalanceTypeCode().equalsIgnoreCase("AC")) {
                cf.setAccountLineAnnualBalanceAmount(new KualiDecimal(collectionEntryAsArray[i++].toString()));
                cf.setBeginningBalanceLineAmount(new KualiDecimal(collectionEntryAsArray[i++].toString()));
                cf.setContractsGrantsBeginningBalanceAmount(new KualiDecimal(collectionEntryAsArray[i++].toString()));
                cf.setMonth1Amount(new KualiDecimal(collectionEntryAsArray[i++].toString()));
            }
            cf.setDummyBusinessObject(new TransientBalanceInquiryAttributes());
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setConsolidationOption("Consolidation");
            retval.add(cf);
        }
        return retval;
    }

    private static Collection<AccountStatusCurrentFunds> buildDetailedCurrentFundsCollection(Collection<? extends LedgerBalance> collection, String pendingEntryOption) {
        ArrayList<AccountStatusCurrentFunds> retval = new ArrayList<AccountStatusCurrentFunds>();
        for (LedgerBalance ledgerBalance : collection) {
            AccountStatusCurrentFunds cf = new AccountStatusCurrentFunds();
            ObjectUtil.buildObject((Object)((Object)cf), (Object)((Object)ledgerBalance));
            cf.setDummyBusinessObject(new TransientBalanceInquiryAttributes());
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setConsolidationOption("Detail");
            retval.add(cf);
        }
        return retval;
    }

    private static boolean existsInCollection(AccountStatusCurrentFunds sourceItem, AccountStatusCurrentFunds destinationItem) {
        if (ObjectUtils.isNull((Object)destinationItem.getLedgerPerson()) || ObjectUtils.isNull((Object)sourceItem.getLedgerPerson())) {
            return false;
        }
        if (!destinationItem.getPositionNumber().equalsIgnoreCase(sourceItem.getPositionNumber())) {
            return false;
        }
        if (!destinationItem.getFinancialObjectCode().equalsIgnoreCase(sourceItem.getFinancialObjectCode())) {
            return false;
        }
        return destinationItem.getLedgerPerson().getEntityId().equalsIgnoreCase(sourceItem.getLedgerPerson().getEntityId());
    }

    private KualiDecimal getOutstandingEncum(AccountStatusCurrentFunds bo, String pendingEntryOption) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("universityFiscalYear", bo.getUniversityFiscalYear().toString());
        fieldValues.put("chartOfAccountsCode", bo.getChartOfAccountsCode());
        fieldValues.put("accountNumber", bo.getAccountNumber());
        if (!bo.getSubAccountNumber().equals("*ALL*")) {
            fieldValues.put("subAccountNumber", bo.getSubAccountNumber());
        }
        fieldValues.put("financialObjectCode", bo.getFinancialObjectCode());
        if (!bo.getFinancialSubObjectCode().equals("*ALL*")) {
            fieldValues.put("financialSubObjectCode", bo.getFinancialSubObjectCode());
        }
        fieldValues.put("financialBalanceTypeCode", "IE");
        fieldValues.put("emplid", bo.getEmplid());
        fieldValues.put("positionNumber", bo.getPositionNumber());
        LOG.debug(USING_TEMPLATE, fieldValues.values());
        LOG.debug(USING_TEMPLATE, fieldValues.keySet());
        KualiDecimal finalizedEncumbrances = (KualiDecimal)this.laborDao.getEncumbranceTotal(fieldValues);
        KualiDecimal pendingEncumbrances = (KualiDecimal)this.laborDao.getPendingEncumbranceTotal(fieldValues, pendingEntryOption);
        return (KualiDecimal)finalizedEncumbrances.add((AbstractKualiDecimal)pendingEncumbrances);
    }

    private static AccountStatusCurrentFunds getExistingCurrentFundsRecord(Collection<? extends AccountStatusCurrentFunds> col, AccountStatusCurrentFunds currentFunds) {
        return col.stream().filter(item -> CurrentFundsLookupableHelperServiceImpl.existsInCollection(item, currentFunds)).findFirst().orElse(null);
    }

    private static List<AccountStatusCurrentFunds> removeDupes(List<? extends AccountStatusCurrentFunds> al) {
        ArrayList<AccountStatusCurrentFunds> noDupes = new ArrayList<AccountStatusCurrentFunds>();
        for (AccountStatusCurrentFunds accountStatusCurrentFunds : al) {
            if (noDupes.size() < 1) {
                noDupes.add(accountStatusCurrentFunds);
                continue;
            }
            AccountStatusCurrentFunds existingFunds = CurrentFundsLookupableHelperServiceImpl.getExistingCurrentFundsRecord(noDupes, accountStatusCurrentFunds);
            if (existingFunds != null) {
                existingFunds.setAccountLineAnnualBalanceAmount((KualiDecimal)existingFunds.getAccountLineAnnualBalanceAmount().add((AbstractKualiDecimal)accountStatusCurrentFunds.getAccountLineAnnualBalanceAmount()));
                continue;
            }
            noDupes.add(accountStatusCurrentFunds);
        }
        return noDupes;
    }

    public void setLaborDao(LaborDao laborDao) {
        this.laborDao = laborDao;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

