/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.gl.document.GeneralLedgerCorrectionProcessDocument;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.kns.bo.Step;
import org.kuali.kfs.module.ld.batch.LaborCorrectionProcessScrubberStep;
import org.kuali.kfs.module.ld.document.service.LaborCorrectionDocumentService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryGroupService;
import org.kuali.kfs.sys.batch.BatchSpringContext;
import org.kuali.kfs.sys.context.ProxyUtils;
import org.kuali.kfs.sys.context.SpringContext;

public class LedgerCorrectionDocument
extends GeneralLedgerCorrectionProcessDocument {
    private static final Logger LOG = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        if (this.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            this.getDocumentHeader().setFinancialDocumentStatusCode("X");
        } else if (this.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            this.getDocumentHeader().setFinancialDocumentStatusCode("R");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            this.getDocumentHeader().setFinancialDocumentStatusCode("D");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.getDocumentHeader().setFinancialDocumentStatusCode("A");
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((DocumentRouteStatusChange)statusChangeEvent).getDocumentId();
        supplierArray[1] = () -> this.getDocumentHeader().getFinancialDocumentStatusCode();
        LOG.info("Document: {} -- Status is: {}", supplierArray);
        if (!this.getDocumentHeader().getWorkflowDocument().isProcessed()) return;
        String docId = this.getDocumentNumber();
        LOG.info("Document {} moving to Processed Status - starting final processing", (Object)docId);
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        OriginEntryGroupService originEntryGroupService = (OriginEntryGroupService)SpringContext.getBean(LaborOriginEntryGroupService.class);
        LedgerCorrectionDocument doc = laborCorrectionDocumentService.findByCorrectionDocumentHeaderId(docId);
        String correctionType = doc.getCorrectionTypeCode();
        if ("R".equals(correctionType)) {
            String dataFileName = doc.getCorrectionInputFileName();
            String doneFileName = dataFileName.replace(".data", ".done");
            originEntryGroupService.deleteFile(doneFileName);
            LOG.info("Document {} : deleted done file to remove from processing: {}", (Object)docId, (Object)doneFileName);
        } else {
            if ("M".equals(correctionType) || "C".equals(correctionType)) {
                Class<LaborCorrectionDocumentService> clazz = LaborCorrectionDocumentService.class;
                synchronized (LaborCorrectionDocumentService.class) {
                    if (!this.checkForExistingOutputDocument(docId)) {
                        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
                        String outputFileName = "";
                        if (!doc.getCorrectionFileDelete()) {
                            outputFileName = laborCorrectionDocumentService.createOutputFileForProcessing(docId, today);
                        } else {
                            LOG.info("Document {} : set to delete output file - no file will be created", (Object)docId);
                        }
                        doc.setCorrectionOutputFileName(outputFileName);
                        LOG.info("Document {} : about to run scrubber -- output file: {}", (Object)docId, (Object)outputFileName);
                        Step step = BatchSpringContext.getStep((String)"laborCorrectionProcessScrubberStep");
                        LaborCorrectionProcessScrubberStep correctionStep = (LaborCorrectionProcessScrubberStep)((Object)ProxyUtils.getTargetIfProxied((Object)step));
                        correctionStep.setDocumentId(docId);
                        try {
                            step.execute(((Object)((Object)this)).getClass().getName(), today);
                        }
                        catch (Exception e) {
                            LOG.error("LLCP scrubber encountered error:", (Throwable)e);
                            throw new RuntimeException("LLCP scrubber encountered error:", e);
                        }
                        correctionStep.setDocumentId(null);
                        LOG.info("Document {} : completed scrubber run -- generating reports", (Object)docId);
                        laborCorrectionDocumentService.generateCorrectionReport(this);
                        laborCorrectionDocumentService.aggregateCorrectionDocumentReports(this);
                    } else {
                        LOG.warn("Attempt to re-process final LLCP operations for document: {}  File with that document number already exists.", (Object)docId);
                    }
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                }
            }
            LOG.error("LLCP doc {} has an unknown correction type code: {}", (Object)docId, (Object)correctionType);
        }
        {
            LOG.info("Document {} moving to Processed Status - completed final processing", (Object)docId);
            return;
        }
    }
}

