/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.authorization;

import java.util.Set;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;

public class LaborExpensesDocumentPresentationController
extends FinancialSystemTransactionalDocumentPresentationControllerBase {
    public static final String LEDGER_BALANCE_IMPORTING = "ledgerBalanceImporting";
    public static final String ACCOUNTS_CAN_CROSS_CHART = "AccountsCanCrossChart";

    public boolean canCopy(Document document) {
        return false;
    }

    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        return false;
    }

    public Set<String> getEditModes(Document document) {
        AccountService accountService;
        Set editModes = super.getEditModes(document);
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved() || workflowDocument.isCompletionRequested()) {
            editModes.add(LEDGER_BALANCE_IMPORTING);
        }
        if ((accountService = (AccountService)SpringContext.getBean(AccountService.class)).accountsCanCrossCharts()) {
            editModes.add(ACCOUNTS_CAN_CROSS_CHART);
        }
        return editModes;
    }
}

