/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.web.format.CurrencyFormatter;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.web.struts.ExpenseTransferDocumentFormBase;

public class SalaryExpenseTransferForm
extends ExpenseTransferDocumentFormBase {
    protected String balanceTypeCode;

    public SalaryExpenseTransferForm() {
        this.setFinancialBalanceTypeCode("AC");
        this.setLookupResultsBOClassName(LedgerBalance.class.getName());
        this.setFormatterType("document.approvalObjectCodeBalances", CurrencyFormatter.class);
    }

    protected String getDefaultDocumentTypeName() {
        return "ST";
    }

    public String getFinancialBalanceTypeCode() {
        return this.balanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String balanceTypeCode) {
        this.balanceTypeCode = balanceTypeCode;
    }

    public SalaryExpenseTransferDocument getSalaryExpenseTransferDocument() {
        return (SalaryExpenseTransferDocument)this.getDocument();
    }

    public boolean getShowLateAdjustmentTab() {
        return this.getSalaryExpenseTransferDocument().isAnyLateAdjustmentFieldPopulated();
    }

    @Override
    public Map getForcedReadOnlyTargetFields() {
        Map map = this.getForcedReadOnlySourceFields();
        map.remove("chartOfAccountsCode");
        map.remove("accountNumber");
        map.remove("subAccountNumber");
        map.remove("financialSubObjectCode");
        map.remove("projectCode");
        map.remove("organizationReferenceId");
        map.remove("amount");
        return map;
    }

    @Override
    public void populateSearchFields() {
        List sourceAccountingLines = this.getSalaryExpenseTransferDocument().getSourceAccountingLines();
        if (sourceAccountingLines != null && !sourceAccountingLines.isEmpty()) {
            ExpenseTransferAccountingLine sourceAccountingLine = (ExpenseTransferAccountingLine)sourceAccountingLines.get(0);
            this.setUniversityFiscalYear(sourceAccountingLine.getPostingYear());
        }
    }
}

