/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.dataaccess;

import org.kuali.kfs.module.ld.businessobject.July1PositionFunding;
import org.kuali.kfs.krad.bo.BusinessObject;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 * This class is an interface to data access objects for general labor related inquiries. It will be deprecated after
 * the data access methods here are put down to business object level.
 */
public interface LaborDao {

    /**
     * @param fieldValues
     * @return an encumbrance total for a given selection criteria
     */
    Object getEncumbranceTotal(Map fieldValues);

    /**
     * @param fieldValues A Map&lt;String, String&gt; containing field values to be used in selection criteria.
     * @param pendingEntryOption Indicates the pending entry option selected
     * @return a pending encumbrance total for a given selection criteria
     */
    Object getPendingEncumbranceTotal(Map fieldValues, String pendingEntryOption);

    /**
     * @param fieldValues
     * @param isConsolidated
     * @return current funds data
     */
    Iterator getCurrentFunds(Map fieldValues, boolean isConsolidated);

    /**
     * @param fieldValues
     * @return current July1 Position Funding data
     */
    Collection<July1PositionFunding> getJuly1PositionFunding(Map<String, String> fieldValues);

    Collection getJuly1(Map fieldValues);

    /**
     * Stores a business object without doing a update query.
     *
     * @param businessObject Business Object to Store.
     */
    void insert(BusinessObject businessObject);
}
