/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.core.api.util.type.KualiDecimal;

/**
 * Labor business object for Account Status (Base Funds).
 */
public class AccountStatusBaseFunds extends LedgerBalance {

    private KualiDecimal csfAmount;
    private KualiDecimal baseBudgetAmount;
    private KualiDecimal baseCSFVarianceAmount;

    public AccountStatusBaseFunds() {
        super();
        setBaseCSFVarianceAmount(KualiDecimal.ZERO);
        setCsfAmount(KualiDecimal.ZERO);
        setBaseBudgetAmount(KualiDecimal.ZERO);
    }

    public KualiDecimal getBaseBudgetAmount() {
        return getAccountLineAnnualBalanceAmount().add(getFinancialBeginningBalanceLineAmount())
                .add(getContractsGrantsBeginningBalanceAmount());
    }

    public void setBaseBudgetAmount(final KualiDecimal baseBudgetAmount) {
        this.baseBudgetAmount = baseBudgetAmount;
    }

    public KualiDecimal getBaseCSFVarianceAmount() {
        return getBaseBudgetAmount().subtract(getCsfAmount());
    }

    public void setBaseCSFVarianceAmount(final KualiDecimal baseCSFVarianceAmount) {
        this.baseCSFVarianceAmount = baseCSFVarianceAmount;
    }

    public KualiDecimal getCsfAmount() {
        return csfAmount;
    }

    public void setCsfAmount(final KualiDecimal csfAmount) {
        this.csfAmount = csfAmount;
    }

    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (getAccountNumber() == null ? 0 : getAccountNumber().hashCode());
        result = PRIME * result + (getChartOfAccountsCode() == null ? 0 : getChartOfAccountsCode().hashCode());
        result = PRIME * result + (getFinancialObjectCode() == null ? 0 : getFinancialObjectCode().hashCode());
        result = PRIME * result + (getFinancialSubObjectCode() == null ? 0 : getFinancialSubObjectCode().hashCode());
        result = PRIME * result + (getSubAccountNumber() == null ? 0 : getSubAccountNumber().hashCode());
        result = PRIME * result + (getUniversityFiscalYear() == null ? 0 : getUniversityFiscalYear().hashCode());

        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }

        final AccountStatusBaseFunds other = (AccountStatusBaseFunds) obj;
        if (getAccountNumber() == null) {
            if (other.getAccountNumber() != null) {
                return false;
            }
        } else if (!getAccountNumber().equals(other.getAccountNumber())) {
            return false;
        }

        if (getChartOfAccountsCode() == null) {
            if (other.getChartOfAccountsCode() != null) {
                return false;
            }
        } else if (!getChartOfAccountsCode().equals(other.getChartOfAccountsCode())) {
            return false;
        }

        if (getFinancialObjectCode() == null) {
            if (other.getFinancialObjectCode() != null) {
                return false;
            }
        } else if (!getFinancialObjectCode().equals(other.getFinancialObjectCode())) {
            return false;
        }

        if (getFinancialSubObjectCode() == null) {
            if (other.getFinancialSubObjectCode() != null) {
                return false;
            }
        } else if (!getFinancialSubObjectCode().equals(other.getFinancialSubObjectCode())) {
            return false;
        }

        if (getSubAccountNumber() == null) {
            if (other.getSubAccountNumber() != null) {
                return false;
            }
        } else if (!getSubAccountNumber().equals(other.getSubAccountNumber())) {
            return false;
        }

        if (getUniversityFiscalYear() == null) {
            return other.getUniversityFiscalYear() == null;
        } else {
            return getUniversityFiscalYear().equals(other.getUniversityFiscalYear());
        }

    }
}
