/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * Labor business object for LaborCalculatedSalaryFoundationTracker.
 */
public class LaborCalculatedSalaryFoundationTracker extends PersistableBusinessObjectBase {

    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String positionNumber;
    private String emplid;
    private Timestamp csfCreateTimestamp;
    private String csfDeleteCode;
    private KualiDecimal csfAmount;
    private BigDecimal csfFullTimeEmploymentQuantity;
    private BigDecimal csfTimePercent;
    private String csfFundingStatusCode;
    private Integer employeeRecord;
    private String earnCode;
    private Integer additionalSequence;
    private Date effectiveDate;
    private Integer effectiveSequence;

    private ObjectCode financialObject;
    private Chart chartOfAccounts;
    private Account account;
    private SubAccount subAccount;
    private SubObjectCode financialSubObject;
    private transient SystemOptions universityFiscal;
    private final int PERCENTAGE_SCALE = 2;

    private KualiDecimal july1BudgetAmount;
    private BigDecimal july1BudgetFteQuantity;
    private BigDecimal july1BudgetTimePercent;

    public LaborCalculatedSalaryFoundationTracker() {
        super();
        setJuly1BudgetAmount(KualiDecimal.ZERO);
        setJuly1BudgetFteQuantity(BigDecimal.ZERO);
        setJuly1BudgetTimePercent(BigDecimal.ZERO);
    }

    public KualiDecimal getJuly1BudgetAmount() {
        return july1BudgetAmount;
    }

    public void setJuly1BudgetAmount(final KualiDecimal july1BudgetAmount) {
        this.july1BudgetAmount = july1BudgetAmount;
    }

    public BigDecimal getJuly1BudgetFteQuantity() {
        return july1BudgetFteQuantity;
    }

    public void setJuly1BudgetFteQuantity(final BigDecimal july1BudgetFteQuantity) {
        this.july1BudgetFteQuantity = july1BudgetFteQuantity;
    }

    public BigDecimal getJuly1BudgetTimePercent() {
        return july1BudgetTimePercent;
    }

    public void setJuly1BudgetTimePercent(final BigDecimal july1BudgetTimePercent) {
        this.july1BudgetTimePercent = july1BudgetTimePercent;
    }

    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    public void setUniversityFiscalYear(final Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(final String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(final String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(final String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getPositionNumber() {
        return positionNumber;
    }

    public void setPositionNumber(final String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEmplid() {
        return emplid;
    }

    public void setEmplid(final String emplid) {
        this.emplid = emplid;
    }

    public String getName() {
        /*
         * KFSCNTRB-1337
         * Replace the old logic that got the name from the person retrieved using the PersonService with the
         * following logic that uses IdentityService, since the former is a lot slower.
         */
        final String name = SpringContext.getBean(FinancialSystemUserService.class).getPersonNameByEmployeeId(getEmplid());
        if (StringUtils.isNotEmpty(name)) {
            return name;
        }
        return LaborConstants.BalanceInquiries.UnknownPersonName;
    }

    public Timestamp getCsfCreateTimestamp() {
        return csfCreateTimestamp;
    }

    public void setCsfCreateTimestamp(final Timestamp csfCreateTimestamp) {
        this.csfCreateTimestamp = csfCreateTimestamp;
    }

    public String getCsfDeleteCode() {
        return csfDeleteCode;
    }

    public void setCsfDeleteCode(final String csfDeleteCode) {
        this.csfDeleteCode = csfDeleteCode;
    }

    public KualiDecimal getCsfAmount() {
        return csfAmount;
    }

    public void setCsfAmount(final KualiDecimal csfAmount) {
        this.csfAmount = csfAmount;
    }

    public BigDecimal getCsfFullTimeEmploymentQuantity() {
        return csfFullTimeEmploymentQuantity;
    }

    public void setCsfFullTimeEmploymentQuantity(final BigDecimal csfFullTimeEmploymentQuantity) {
        this.csfFullTimeEmploymentQuantity = csfFullTimeEmploymentQuantity;
    }

    public BigDecimal getCsfTimePercent() {
        return csfTimePercent;
    }

    public void setCsfTimePercent(final BigDecimal csfTimePercent) {
        this.csfTimePercent = csfTimePercent;
    }

    public String getCsfFundingStatusCode() {
        return csfFundingStatusCode;
    }

    public void setCsfFundingStatusCode(final String csfFundingStatusCode) {
        this.csfFundingStatusCode = csfFundingStatusCode;
    }

    public Integer getEmployeeRecord() {
        return employeeRecord;
    }

    public void setEmployeeRecord(final Integer employeeRecord) {
        this.employeeRecord = employeeRecord;
    }

    public String getEarnCode() {
        return earnCode;
    }

    public void setEarnCode(final String earnCode) {
        this.earnCode = earnCode;
    }

    public Integer getAdditionalSequence() {
        return additionalSequence;
    }

    public void setAdditionalSequence(final Integer additionalSequence) {
        this.additionalSequence = additionalSequence;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(final Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getEffectiveSequence() {
        return effectiveSequence;
    }

    public void setEffectiveSequence(final Integer effectiveSequence) {
        this.effectiveSequence = effectiveSequence;
    }

    public ObjectCode getFinancialObject() {
        return financialObject;
    }

    public void setFinancialObject(final ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(final Account account) {
        this.account = account;
    }

    public SubAccount getSubAccount() {
        return subAccount;
    }

    public void setSubAccount(final SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public SubObjectCode getFinancialSubObject() {
        return financialSubObject;
    }

    public void setFinancialSubObject(final SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public SystemOptions getUniversityFiscal() {
        return universityFiscal;
    }

    public void setUniversityFiscal(final SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    public int getPERCENTAGE_SCALE() {
        return PERCENTAGE_SCALE;
    }

    /**
     * @return the key list of the business object
     */
    public List<String> getKeyFieldList() {
        final List<String> keyFieldList = new ArrayList<>();
        keyFieldList.add(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR);
        keyFieldList.add(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE);
        keyFieldList.add(KFSPropertyConstants.ACCOUNT_NUMBER);
        keyFieldList.add(KFSPropertyConstants.SUB_ACCOUNT_NUMBER);
        keyFieldList.add(KFSPropertyConstants.FINANCIAL_OBJECT_CODE);
        keyFieldList.add(KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE);
        keyFieldList.add(KFSPropertyConstants.POSITION_NUMBER);
        keyFieldList.add(KFSPropertyConstants.EMPLID);
        return keyFieldList;
    }

}

