/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.gl.businessobject.LedgerEntryHistory;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

/**
 * Labor business object for LedgerEntryHistory
 */
public class LaborEntryHistory extends LedgerEntry implements LedgerEntryHistory {

    private Integer rowCount;

    public LaborEntryHistory() {
        super();
        setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        setRowCount(0);
    }

    /**
     * @param laborOriginEntry
     */
    public LaborEntryHistory(final LaborOriginEntry laborOriginEntry) {
        this();
        setUniversityFiscalYear(laborOriginEntry.getUniversityFiscalYear());
        setChartOfAccountsCode(laborOriginEntry.getChartOfAccountsCode());
        setFinancialObjectCode(laborOriginEntry.getFinancialObjectCode());
        setFinancialBalanceTypeCode(laborOriginEntry.getFinancialBalanceTypeCode());
        setUniversityFiscalPeriodCode(laborOriginEntry.getUniversityFiscalPeriodCode());
        setTransactionDebitCreditCode(laborOriginEntry.getTransactionDebitCreditCode());
    }

    /**
     * Adds a transactionLedgerEntryAmount and increments the rowCount.
     *
     * @param transactionLedgerEntryAmount
     */
    public void addAmount(final KualiDecimal transactionLedgerEntryAmount) {
        setTransactionLedgerEntryAmount(getTransactionLedgerEntryAmount().add(transactionLedgerEntryAmount));
        rowCount++;
    }

    @Override
    public Integer getRowCount() {
        return rowCount;
    }

    public void setRowCount(final Integer rowCount) {
        this.rowCount = rowCount;
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getAccountNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setAccountNumber(final String accountNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getSubAccountNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setSubAccountNumber(final String subAccountNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getFinancialSubObjectCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setFinancialSubObjectCode(final String financialSubObjectCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getFinancialObjectTypeCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setFinancialObjectTypeCode(final String financialObjectTypeCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getFinancialDocumentTypeCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getFinancialSystemOriginationCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setFinancialSystemOriginationCode(final String financialSystemOriginationCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setFinancialDocumentTypeCode(final String financialDocumentTypeCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getDocumentNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setDocumentNumber(final String documentNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Integer getTransactionLedgerEntrySequenceNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionLedgerEntrySequenceNumber(final Integer transactionLedgerEntrySequenceNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getPositionNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setPositionNumber(final String positionNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getProjectCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setProjectCode(final String projectCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getTransactionLedgerEntryDescription() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionLedgerEntryDescription(final String transactionLedgerEntryDescription) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Date getTransactionDate() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionDate(final Date transactionDate) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getOrganizationDocumentNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setOrganizationDocumentNumber(final String organizationDocumentNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getOrganizationReferenceId() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setOrganizationReferenceId(final String organizationReferenceId) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getReferenceFinancialDocumentTypeCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setReferenceFinancialDocumentTypeCode(final String referenceFinancialDocumentTypeCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getReferenceFinancialSystemOriginationCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setReferenceFinancialSystemOriginationCode(final String referenceFinancialSystemOriginationCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getReferenceFinancialDocumentNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setReferenceFinancialDocumentNumber(final String referenceFinancialDocumentNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Date getFinancialDocumentReversalDate() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setFinancialDocumentReversalDate(final Date financialDocumentReversalDate) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getTransactionEncumbranceUpdateCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionEncumbranceUpdateCode(final String transactionEncumbranceUpdateCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Date getTransactionPostingDate() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionPostingDate(final Date transactionPostingDate) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Date getPayPeriodEndDate() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setPayPeriodEndDate(final Date payPeriodEndDate) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public BigDecimal getTransactionTotalHours() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionTotalHours(final BigDecimal transactionTotalHours) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Integer getPayrollEndDateFiscalYear() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setPayrollEndDateFiscalYear(final Integer payrollEndDateFiscalYear) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getPayrollEndDateFiscalPeriodCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setPayrollEndDateFiscalPeriodCode(final String payrollEndDateFiscalPeriodCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getEmplid() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setEmplid(final String emplid) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Integer getEmployeeRecord() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setEmployeeRecord(final Integer employeeRecord) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getEarnCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setEarnCode(final String earnCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getPayGroup() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setPayGroup(final String payGroup) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getSalaryAdministrationPlan() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setSalaryAdministrationPlan(final String salaryAdministrationPlan) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getGrade() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setGrade(final String grade) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getRunIdentifier() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setRunIdentifier(final String runIdentifier) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getLaborLedgerOriginalChartOfAccountsCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setLaborLedgerOriginalChartOfAccountsCode(final String laborLedgerOriginalChartOfAccountsCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getLaborLedgerOriginalAccountNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setLaborLedgerOriginalAccountNumber(final String laborLedgerOriginalAccountNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getLaborLedgerOriginalSubAccountNumber() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setLaborLedgerOriginalSubAccountNumber(final String laborLedgerOriginalSubAccountNumber) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getLaborLedgerOriginalFinancialObjectCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setLaborLedgerOriginalFinancialObjectCode(final String laborLedgerOriginalFinancialObjectCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getLaborLedgerOriginalFinancialSubObjectCode() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setLaborLedgerOriginalFinancialSubObjectCode(final String laborLedgerOriginalFinancialSubObjectCode) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getHrmsCompany() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setHrmsCompany(final String hrmsCompany) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public String getSetid() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setSetid(final String setid) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Timestamp getTransactionDateTimeStamp() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionDateTimeStamp(final Timestamp transactionDateTimeStamp) {
        throw new UnsupportedOperationException();
    }
}
