/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.gl.businessobject.TransientBalanceInquiryAttributes;
import org.kuali.kfs.integration.ld.LaborLedgerEntry;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

/**
 * Labor business object for LedgerEntry
 */
public class LedgerEntry extends Entry implements LaborLedgerEntry {

    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private String universityFiscalPeriodCode;
    private String financialDocumentTypeCode;
    private String financialSystemOriginationCode;
    private String documentNumber;
    private Integer transactionLedgerEntrySequenceNumber;
    private String positionNumber;
    private String projectCode;
    private String transactionLedgerEntryDescription;
    private KualiDecimal transactionLedgerEntryAmount;
    private String transactionDebitCreditCode;
    private Date transactionDate;
    private String organizationDocumentNumber;
    private String organizationReferenceId;
    private String referenceFinancialDocumentTypeCode;
    private String referenceFinancialSystemOriginationCode;
    private String referenceFinancialDocumentNumber;
    private Date financialDocumentReversalDate;
    private String transactionEncumbranceUpdateCode;
    private Date transactionPostingDate;
    private Date payPeriodEndDate;
    private BigDecimal transactionTotalHours;
    private Integer payrollEndDateFiscalYear;
    private String payrollEndDateFiscalPeriodCode;
    private String emplid;
    private Integer employeeRecord;
    private String earnCode;
    private String payGroup;
    private String salaryAdministrationPlan;
    private String grade;
    private String runIdentifier;
    private String laborLedgerOriginalChartOfAccountsCode;
    private String laborLedgerOriginalAccountNumber;
    private String laborLedgerOriginalSubAccountNumber;
    private String laborLedgerOriginalFinancialObjectCode;
    private String laborLedgerOriginalFinancialSubObjectCode;
    private String hrmsCompany;
    private String setid;
    private Timestamp transactionDateTimeStamp;

    private ObjectCode financialObject;
    private Chart chartOfAccounts;
    private Account account;
    private SubAccount subAccount;
    private SubObjectCode financialSubObject;
    private ObjectType financialObjectType;
    private BalanceType balanceType;
    private AccountingPeriod universityFiscalPeriod;
    private AccountingPeriod payrollEndDateFiscalPeriod;
    private DocumentType financialSystemDocumentType;
    private DocumentType referenceFinancialSystemDocumentType;
    private SystemOptions option;
    private OriginationCode referenceOriginationCode;
    private ProjectCode project;
    private OriginationCode financialSystemOrigination;
    private LaborObject laborObject;
    private Person employee;

    public LedgerEntry() {
        super();
        setDummyBusinessObject(new TransientBalanceInquiryAttributes());
    }

    /**
     * @param transaction the given transaction
     */
    public LedgerEntry(final LaborTransaction transaction) {
        super(transaction);
        setEarnCode(transaction.getEarnCode());
        setEmplid(transaction.getEmplid());
        setEmployeeRecord(transaction.getEmployeeRecord());
        setGrade(transaction.getGrade());
        setHrmsCompany(transaction.getHrmsCompany());
        setLaborLedgerOriginalAccountNumber(transaction.getLaborLedgerOriginalAccountNumber());
        setLaborLedgerOriginalChartOfAccountsCode(transaction.getLaborLedgerOriginalChartOfAccountsCode());
        setLaborLedgerOriginalFinancialObjectCode(transaction.getLaborLedgerOriginalFinancialObjectCode());
        setLaborLedgerOriginalFinancialSubObjectCode(transaction.getLaborLedgerOriginalFinancialSubObjectCode());
        setLaborLedgerOriginalSubAccountNumber(transaction.getLaborLedgerOriginalSubAccountNumber());
        setPayGroup(transaction.getPayGroup());
        setPayPeriodEndDate(transaction.getPayPeriodEndDate());
        setPayrollEndDateFiscalPeriodCode(transaction.getPayrollEndDateFiscalPeriodCode());
        setPayrollEndDateFiscalYear(transaction.getPayrollEndDateFiscalYear());
        setPositionNumber(transaction.getPositionNumber());
        setRunIdentifier(transaction.getRunIdentifier());
        setProjectCode(transaction.getProjectCode());
        setSetid(transaction.getSetid());
        setSalaryAdministrationPlan(transaction.getSalaryAdministrationPlan());
        setTransactionTotalHours(transaction.getTransactionTotalHours());
    }

    @Override
    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    @Override
    public void setUniversityFiscalYear(final Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    @Override
    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    @Override
    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    @Override
    public String getAccountNumber() {
        return accountNumber;
    }

    @Override
    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Override
    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    @Override
    public void setSubAccountNumber(final String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    @Override
    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    @Override
    public void setFinancialObjectCode(final String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    @Override
    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    @Override
    public void setFinancialSubObjectCode(final String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    @Override
    public String getFinancialBalanceTypeCode() {
        return financialBalanceTypeCode;
    }

    @Override
    public void setFinancialBalanceTypeCode(final String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    @Override
    public String getFinancialObjectTypeCode() {
        return financialObjectTypeCode;
    }

    @Override
    public void setFinancialObjectTypeCode(final String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    @Override
    public String getUniversityFiscalPeriodCode() {
        return universityFiscalPeriodCode;
    }

    @Override
    public void setUniversityFiscalPeriodCode(final String universityFiscalPeriodCode) {
        this.universityFiscalPeriodCode = universityFiscalPeriodCode;
    }

    @Override
    public String getFinancialDocumentTypeCode() {
        return financialDocumentTypeCode;
    }

    @Override
    public String getFinancialSystemOriginationCode() {
        return financialSystemOriginationCode;
    }

    @Override
    public void setFinancialSystemOriginationCode(final String financialSystemOriginationCode) {
        this.financialSystemOriginationCode = financialSystemOriginationCode;
    }

    @Override
    public void setFinancialDocumentTypeCode(final String financialDocumentTypeCode) {
        this.financialDocumentTypeCode = financialDocumentTypeCode;
    }

    @Override
    public String getDocumentNumber() {
        return documentNumber;
    }

    @Override
    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public Integer getTransactionLedgerEntrySequenceNumber() {
        return transactionLedgerEntrySequenceNumber;
    }

    @Override
    public void setTransactionLedgerEntrySequenceNumber(final Integer transactionLedgerEntrySequenceNumber) {
        this.transactionLedgerEntrySequenceNumber = transactionLedgerEntrySequenceNumber;
    }

    @Override
    public String getPositionNumber() {
        return positionNumber;
    }

    @Override
    public void setPositionNumber(final String positionNumber) {
        this.positionNumber = positionNumber;
    }

    @Override
    public String getProjectCode() {
        return projectCode;
    }

    @Override
    public void setProjectCode(final String projectCode) {
        this.projectCode = projectCode;
    }

    @Override
    public String getTransactionLedgerEntryDescription() {
        return transactionLedgerEntryDescription;
    }

    @Override
    public void setTransactionLedgerEntryDescription(final String transactionLedgerEntryDescription) {
        this.transactionLedgerEntryDescription = transactionLedgerEntryDescription;
    }

    @Override
    public KualiDecimal getTransactionLedgerEntryAmount() {
        return transactionLedgerEntryAmount;
    }

    @Override
    public void setTransactionLedgerEntryAmount(final KualiDecimal transactionLedgerEntryAmount) {
        this.transactionLedgerEntryAmount = transactionLedgerEntryAmount;
    }

    @Override
    public String getTransactionDebitCreditCode() {
        return transactionDebitCreditCode;
    }

    @Override
    public void setTransactionDebitCreditCode(final String transactionDebitCreditCode) {
        this.transactionDebitCreditCode = transactionDebitCreditCode;
    }

    @Override
    public Date getTransactionDate() {
        return transactionDate;
    }

    @Override
    public void setTransactionDate(final Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    @Override
    public String getOrganizationDocumentNumber() {
        return organizationDocumentNumber;
    }

    @Override
    public void setOrganizationDocumentNumber(final String organizationDocumentNumber) {
        this.organizationDocumentNumber = organizationDocumentNumber;
    }

    @Override
    public String getOrganizationReferenceId() {
        return organizationReferenceId;
    }

    @Override
    public void setOrganizationReferenceId(final String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    @Override
    public String getReferenceFinancialDocumentTypeCode() {
        return referenceFinancialDocumentTypeCode;
    }

    @Override
    public void setReferenceFinancialDocumentTypeCode(final String referenceFinancialDocumentTypeCode) {
        this.referenceFinancialDocumentTypeCode = referenceFinancialDocumentTypeCode;
    }

    @Override
    public String getReferenceFinancialSystemOriginationCode() {
        return referenceFinancialSystemOriginationCode;
    }

    @Override
    public void setReferenceFinancialSystemOriginationCode(final String referenceFinancialSystemOriginationCode) {
        this.referenceFinancialSystemOriginationCode = referenceFinancialSystemOriginationCode;
    }

    @Override
    public String getReferenceFinancialDocumentNumber() {
        return referenceFinancialDocumentNumber;
    }

    @Override
    public void setReferenceFinancialDocumentNumber(final String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    @Override
    public Date getFinancialDocumentReversalDate() {
        return financialDocumentReversalDate;
    }

    @Override
    public void setFinancialDocumentReversalDate(final Date financialDocumentReversalDate) {
        this.financialDocumentReversalDate = financialDocumentReversalDate;
    }

    @Override
    public String getTransactionEncumbranceUpdateCode() {
        return transactionEncumbranceUpdateCode;
    }

    @Override
    public void setTransactionEncumbranceUpdateCode(final String transactionEncumbranceUpdateCode) {
        this.transactionEncumbranceUpdateCode = transactionEncumbranceUpdateCode;
    }

    @Override
    public Date getTransactionPostingDate() {
        return transactionPostingDate;
    }

    @Override
    public void setTransactionPostingDate(final Date transactionPostingDate) {
        this.transactionPostingDate = transactionPostingDate;
    }

    @Override
    public Date getPayPeriodEndDate() {
        return payPeriodEndDate;
    }

    @Override
    public void setPayPeriodEndDate(final Date payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
    }

    @Override
    public BigDecimal getTransactionTotalHours() {
        return transactionTotalHours;
    }

    @Override
    public void setTransactionTotalHours(final BigDecimal transactionTotalHours) {
        this.transactionTotalHours = transactionTotalHours;
    }

    @Override
    public Integer getPayrollEndDateFiscalYear() {
        return payrollEndDateFiscalYear;
    }

    @Override
    public void setPayrollEndDateFiscalYear(final Integer payrollEndDateFiscalYear) {
        this.payrollEndDateFiscalYear = payrollEndDateFiscalYear;
    }

    @Override
    public String getPayrollEndDateFiscalPeriodCode() {
        return payrollEndDateFiscalPeriodCode;
    }

    @Override
    public void setPayrollEndDateFiscalPeriodCode(final String payrollEndDateFiscalPeriodCode) {
        this.payrollEndDateFiscalPeriodCode = payrollEndDateFiscalPeriodCode;
    }

    @Override
    public String getEmplid() {
        return emplid;
    }

    @Override
    public void setEmplid(final String emplid) {
        this.emplid = emplid;
    }

    @Override
    public Integer getEmployeeRecord() {
        return employeeRecord;
    }

    @Override
    public void setEmployeeRecord(final Integer employeeRecord) {
        this.employeeRecord = employeeRecord;
    }

    @Override
    public String getEarnCode() {
        return earnCode;
    }

    @Override
    public void setEarnCode(final String earnCode) {
        this.earnCode = earnCode;
    }

    @Override
    public String getPayGroup() {
        return payGroup;
    }

    @Override
    public void setPayGroup(final String payGroup) {
        this.payGroup = payGroup;
    }

    @Override
    public String getSalaryAdministrationPlan() {
        return salaryAdministrationPlan;
    }

    @Override
    public void setSalaryAdministrationPlan(final String salaryAdministrationPlan) {
        this.salaryAdministrationPlan = salaryAdministrationPlan;
    }

    @Override
    public String getGrade() {
        return grade;
    }

    @Override
    public void setGrade(final String grade) {
        this.grade = grade;
    }

    @Override
    public String getRunIdentifier() {
        return runIdentifier;
    }

    @Override
    public void setRunIdentifier(final String runIdentifier) {
        this.runIdentifier = runIdentifier;
    }

    @Override
    public String getLaborLedgerOriginalChartOfAccountsCode() {
        return laborLedgerOriginalChartOfAccountsCode;
    }

    @Override
    public void setLaborLedgerOriginalChartOfAccountsCode(final String laborLedgerOriginalChartOfAccountsCode) {
        this.laborLedgerOriginalChartOfAccountsCode = laborLedgerOriginalChartOfAccountsCode;
    }

    @Override
    public String getLaborLedgerOriginalAccountNumber() {
        return laborLedgerOriginalAccountNumber;
    }

    @Override
    public void setLaborLedgerOriginalAccountNumber(final String laborLedgerOriginalAccountNumber) {
        this.laborLedgerOriginalAccountNumber = laborLedgerOriginalAccountNumber;
    }

    @Override
    public String getLaborLedgerOriginalSubAccountNumber() {
        return laborLedgerOriginalSubAccountNumber;
    }

    @Override
    public void setLaborLedgerOriginalSubAccountNumber(final String laborLedgerOriginalSubAccountNumber) {
        this.laborLedgerOriginalSubAccountNumber = laborLedgerOriginalSubAccountNumber;
    }

    @Override
    public String getLaborLedgerOriginalFinancialObjectCode() {
        return laborLedgerOriginalFinancialObjectCode;
    }

    @Override
    public void setLaborLedgerOriginalFinancialObjectCode(final String laborLedgerOriginalFinancialObjectCode) {
        this.laborLedgerOriginalFinancialObjectCode = laborLedgerOriginalFinancialObjectCode;
    }

    @Override
    public String getLaborLedgerOriginalFinancialSubObjectCode() {
        return laborLedgerOriginalFinancialSubObjectCode;
    }

    @Override
    public void setLaborLedgerOriginalFinancialSubObjectCode(final String laborLedgerOriginalFinancialSubObjectCode) {
        this.laborLedgerOriginalFinancialSubObjectCode = laborLedgerOriginalFinancialSubObjectCode;
    }

    @Override
    public String getHrmsCompany() {
        return hrmsCompany;
    }

    @Override
    public void setHrmsCompany(final String hrmsCompany) {
        this.hrmsCompany = hrmsCompany;
    }

    @Override
    public String getSetid() {
        return setid;
    }

    @Override
    public void setSetid(final String setid) {
        this.setid = setid;
    }

    @Override
    public Timestamp getTransactionDateTimeStamp() {
        return transactionDateTimeStamp;
    }

    @Override
    public void setTransactionDateTimeStamp(final Timestamp transactionDateTimeStamp) {
        this.transactionDateTimeStamp = transactionDateTimeStamp;
    }

    @Override
    public ObjectCode getFinancialObject() {
        return financialObject;
    }

    @Override
    @Deprecated
    public void setFinancialObject(final ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    @Override
    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Override
    @Deprecated
    public void setChartOfAccounts(final Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    @Override
    public Account getAccount() {
        return account;
    }

    @Override
    @Deprecated
    public void setAccount(final Account account) {
        this.account = account;
    }

    @Override
    public AccountingPeriod getUniversityFiscalPeriod() {
        return universityFiscalPeriod;
    }

    @Override
    @Deprecated
    public void setUniversityFiscalPeriod(final AccountingPeriod universityFiscalPeriod) {
        this.universityFiscalPeriod = universityFiscalPeriod;
    }

    @Override
    public BalanceType getBalanceType() {
        return balanceType;
    }

    @Override
    @Deprecated
    public void setBalanceType(final BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    @Override
    public DocumentType getFinancialSystemDocumentType() {
        financialSystemDocumentType = SpringContext.getBean(DocumentTypeService.class)
                .updateDocumentTypeIfNecessary(financialDocumentTypeCode, financialSystemDocumentType);
        return financialSystemDocumentType;
    }

    @Override
    public DocumentType getReferenceFinancialSystemDocumentType() {
        referenceFinancialSystemDocumentType = SpringContext.getBean(DocumentTypeService.class)
                .updateDocumentTypeIfNecessary(referenceFinancialDocumentTypeCode,
                        referenceFinancialSystemDocumentType);
        return referenceFinancialSystemDocumentType;
    }

    @Override
    public ObjectType getFinancialObjectType() {
        return financialObjectType;
    }

    @Override
    @Deprecated
    public void setFinancialObjectType(final ObjectType financialObjectType) {
        this.financialObjectType = financialObjectType;
    }

    @Override
    public SubObjectCode getFinancialSubObject() {
        return financialSubObject;
    }

    @Override
    @Deprecated
    public void setFinancialSubObject(final SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    @Override
    public SystemOptions getOption() {
        return option;
    }

    @Override
    @Deprecated
    public void setOption(final SystemOptions option) {
        this.option = option;
    }

    @Override
    public AccountingPeriod getPayrollEndDateFiscalPeriod() {
        return payrollEndDateFiscalPeriod;
    }

    @Override
    @Deprecated
    public void setPayrollEndDateFiscalPeriod(final AccountingPeriod payrollEndDateFiscalPeriod) {
        this.payrollEndDateFiscalPeriod = payrollEndDateFiscalPeriod;
    }

    @Override
    public ProjectCode getProject() {
        return project;
    }

    @Override
    @Deprecated
    public void setProject(final ProjectCode project) {
        this.project = project;
    }

    @Override
    public OriginationCode getReferenceOriginationCode() {
        return referenceOriginationCode;
    }

    @Override
    @Deprecated
    public void setReferenceOriginationCode(final OriginationCode referenceOriginationCode) {
        this.referenceOriginationCode = referenceOriginationCode;
    }

    @Override
    public SubAccount getSubAccount() {
        return subAccount;
    }

    @Override
    @Deprecated
    public void setSubAccount(final SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    @Override
    public OriginationCode getFinancialSystemOrigination() {
        return financialSystemOrigination;
    }

    @Override
    @Deprecated
    public void setFinancialSystemOrigination(final OriginationCode financialSystemOrigination) {
        this.financialSystemOrigination = financialSystemOrigination;
    }

    @Override
    public LaborLedgerObject getLaborLedgerObject() {
        return laborObject;
    }

    @Override
    @Deprecated
    public void setLaborLedgerObject(final LaborLedgerObject laborLedgerObject) {
        laborObject = (LaborObject) laborLedgerObject;
    }

    public LaborObject getLaborObject() {
        return laborObject;
    }

    @Deprecated
    public void setLaborObject(final LaborObject laborObject) {
        this.laborObject = laborObject;
    }

    /**
     * @return the employee associated with this record
     */
    public Person getEmployee() {
        if (employee == null || !StringUtils.equals(employee.getEmployeeId(), getEmplid())) {
            employee = SpringContext.getBean(PersonService.class).getPersonByEmployeeId(getEmplid());
            if (employee == null) {
                final Class<? extends Person> employeeClass = SpringContext.getBean(PersonService.class)
                        .getPersonImplementationClass();
                try {
                    employee = employeeClass.newInstance();
                } catch (InstantiationException | IllegalAccessException ie) {
                    throw new RuntimeException("Could not instantiate empty Person object", ie);
                }
            }
        }
        return employee;
    }

    @Deprecated
    public void setEmployee(final Person employee) {
        this.employee = employee;
    }

}
