/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public final class LaborConstants {
    public static final String BASE_FUNDS_LOOKUP_HELPER_SERVICE_NAME = "BaseFundsLookupableHelperService";
    public static final String CURRENT_FUNDS_LOOKUP_HELPER_SERVICE_NAME = "CurrentFundsLookupableHelperService";
    public static final String DASHES_DELETE_CODE = "-";
    public static final String DOCUMENT_EMPLOYEE_ID_ERRORS = "document.emplid";
    public static final String EMPLOYEE_LOOKUP_ERRORS = "document.employeeLookups";
    public static final String LONG_ROW_TABLE_INQUIRY_ACTION = "laborLongRowTableInquiry.do";
    public static final Map<String, String> periodCodeMapping = new HashMap<String, String>();
    public static final String ANNUAL_CLOSING_DOCUMENT_TYPE_CODE = LaborConstants.getAnnualClosingDocumentType();
    public static final String[] ACCOUNT_FIELDS = new String[]{"chartOfAccountsCode", "accountNumber"};
    public static final String LABOR_MODULE_CODE = "KFS-LD";
    public static final String LABOR_ENTERPRISE_FEEDER_FILE_SET_TYPE_IDENTIFIER = "laborEnterpriseFeederFileSetType";
    private static String SPACE_TRANSACTION_DATE = null;
    private static String DASH_POSITION_NUMBER = null;
    private static String DASH_EMPLID = null;

    private LaborConstants() {
    }

    public static List<String> consolidationAttributesOfOriginEntry() {
        ArrayList<String> consolidationAttributes = new ArrayList<String>();
        consolidationAttributes.add("universityFiscalYear");
        consolidationAttributes.add("universityFiscalPeriodCode");
        consolidationAttributes.add("chartOfAccountsCode");
        consolidationAttributes.add("accountNumber");
        consolidationAttributes.add("subAccountNumber");
        consolidationAttributes.add("financialBalanceTypeCode");
        consolidationAttributes.add("financialObjectCode");
        consolidationAttributes.add("financialSubObjectCode");
        consolidationAttributes.add("financialObjectTypeCode");
        consolidationAttributes.add("financialDocumentTypeCode");
        consolidationAttributes.add("documentNumber");
        consolidationAttributes.add("organizationDocumentNumber");
        consolidationAttributes.add("financialSystemOriginationCode");
        consolidationAttributes.add("projectCode");
        consolidationAttributes.add("organizationReferenceId");
        consolidationAttributes.add("transactionLedgerEntryDescription");
        consolidationAttributes.add("referenceFinancialDocumentTypeCode");
        consolidationAttributes.add("referenceFinancialSystemOriginationCode");
        consolidationAttributes.add("referenceFinancialDocumentNumber");
        consolidationAttributes.add("financialDocumentReversalDate");
        consolidationAttributes.add("transactionEncumbranceUpdateCode");
        consolidationAttributes.add("transactionDebitCreditCode");
        consolidationAttributes.add("transactionLedgerEntryAmount");
        return consolidationAttributes;
    }

    public static String getSpaceTransactionDate() {
        if (SPACE_TRANSACTION_DATE == null) {
            SPACE_TRANSACTION_DATE = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeSize(OriginEntryFull.class, "transactionDate"), (char)' ');
        }
        return SPACE_TRANSACTION_DATE;
    }

    private static String getAnnualClosingDocumentType() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE");
    }

    public static String getDashPositionNumber() {
        if (DASH_POSITION_NUMBER == null) {
            DASH_POSITION_NUMBER = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(LaborOriginEntry.class, "positionNumber"), (char)'-');
        }
        return DASH_POSITION_NUMBER;
    }

    public static String getDashEmplId() {
        if (DASH_EMPLID == null) {
            DASH_EMPLID = StringUtils.rightPad((String)"", (int)((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(LaborOriginEntry.class, "emplid"), (char)'-');
        }
        return DASH_EMPLID;
    }

    static {
        periodCodeMapping.put("month1Amount", "01");
        periodCodeMapping.put("month2Amount", "02");
        periodCodeMapping.put("month3Amount", "03");
        periodCodeMapping.put("month4Amount", "04");
        periodCodeMapping.put("month5Amount", "05");
        periodCodeMapping.put("month6Amount", "06");
        periodCodeMapping.put("month7Amount", "07");
        periodCodeMapping.put("month8Amount", "08");
        periodCodeMapping.put("month9Amount", "09");
        periodCodeMapping.put("month10Amount", "10");
        periodCodeMapping.put("month11Amount", "11");
        periodCodeMapping.put("month12Amount", "12");
        periodCodeMapping.put("month13Amount", "13");
    }

    public static class LateAdjustment {
        public static final String GENERATE_LATE_ADJUSTMENT_STMT_ID = "GenerateLateAdjustStmt";
        public static final int NUM_LATE_ADJUST_FIELDS = 4;
        public static final Integer FISCAL_PERIODS_PER_YEAR = 12;
    }

    public static class BenefitCalculation {
        public static final String ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_PARAMETER = "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND";
        public static final String ACCOUNT_CODE_OFFSET_PROPERTY_NAME = "accountCodeOffset";
        public static final String OBJECT_CODE_OFFSET_PROPERTY_NAME = "objectCodeOffset";
    }

    public static class PermissionNames {
        public static final String OVERRIDE_TRANSFER_IMPACTING_EFFORT_CERTIFICATION = "Override Transfer Impacting Open Effort Certification";
    }

    public static class BatchFileSystem {
        public static final String EXTENSION = ".data";
        public static final String DONE_FILE_EXTENSION = ".done";
        public static final String NIGHTLY_OUT_FILE = "ld_labentry_kfs";
        public static final String BACKUP_FILE = "ld_ldbackup";
        public static final String PRE_SCRUBBER_FILE = "ld_prescrub";
        public static final String SCRUBBER_INPUT_FILE = "ld_sortscrb";
        public static final String SCRUBBER_VALID_OUTPUT_FILE = "ld_scrbout1";
        public static final String SCRUBBER_ERROR_OUTPUT_FILE = "ld_scrberr1";
        public static final String SCRUBBER_EXPIRED_OUTPUT_FILE = "ld_expaccts";
        public static final String SCRUBBER_ERROR_SORTED_FILE = "ld_sorterr1";
        public static final String DEMERGER_VALID_OUTPUT_FILE = "ld_scrbout2";
        public static final String DEMERGER_ERROR_OUTPUT_FILE = "ld_scrberr2";
        public static final String POSTER_INPUT_FILE = "ld_sortpost";
        public static final String POSTER_VALID_OUTPUT_FILE = "ld_postout";
        public static final String POSTER_ERROR_OUTPUT_FILE = "ld_posterrs";
        public static final String LABOR_GL_ENTRY_FILE = "gl_glentry_lab";
        public static final String BALANCE_FORWARDS_FILE = "ld_balance_forwards";
        public static final String LABOR_ENTERPRISE_FEED = "ld_ldentry_entp";
    }

    public static class SalaryExpenseTransfer {
        public static final String LABOR_LEDGER_SALARY_CODE = "S";
        public static final String EFFORT_VALIDATION_OVERRIDE_QUESTION = "EffortValidationOverrideQuestion";
    }

    public static class LookupableBeanKeys {
        public static final String CSF_TRACKER = "laborCalculatedSalaryFoundationTrackerLookupable";
    }

    public static enum JournalVoucherOffsetType {
        ACCRUAL("LJVA", "Accrual", "LLJV ACCRUALS OFFSET"),
        CASH("LJVC", "Cash", "LLJV CASH OFFSET"),
        ENCUMBRANCE("LJVE", "Encumbrance", "LLJV ENCUMBRANCE OFFSET"),
        NO_OFFSET("LLJV", "No Offset", "LABOR LEDGER JOUNAL VOUCHER");

        public String description;
        public String longDescription;
        public String typeCode;

        private JournalVoucherOffsetType(String typeCode, String description, String longDescription) {
            this.typeCode = typeCode;
            this.description = description;
            this.longDescription = longDescription;
        }
    }

    public static class DestinationNames {
        public static final String LABOR_GL_ENTRY = "LD_LBR_GL_ENTRY_T";
        public static final String LEDGER_BALANCE = "LD_LDGR_BAL_T";
        public static final String LEDGER_ENTRY = "LD_LDGR_ENTR_T";
        public static final String ORIGIN_ENTRY = "LD_LBR_ORIGIN_ENTRY_T";
    }

    public static class BenefitExpenseTransfer {
        public static final String LABOR_LEDGER_BENEFIT_CODE = "F";
    }

    public static class ColumnNames {
        public static final String UNIVERSITY_FISCAL_YEAR = "UNIV_FISCAL_YR";
        public static final String TRANSACTION_LEDGER_ENTRY_AMOUNT = "TRN_LDGR_ENTR_AMT";
        public static final String POSITION_NUMBER = "POSITION_NBR";
        public static final String EMPLOYEE_IDENTIFIER = "EMPLID";
    }

    public static class BalanceInquiries {
        public static final String ANNUAL_BALANCE = "ACLN_ANNL_BAL_AMT";
        public static final String BALANCE_TYPE_AC_AND_A21 = "AC&A2";
        public static final String CONTRACT_GRANT_BB_AMOUNT = "CONTR_GR_BB_AC_AMT";
        public static final String EMPLOYEE_FUNDING_EXPENSE_OBJECT_TYPE_CODE = "ES";
        public static final String EMPLOYEE_FUNDING_NORMAL_OP_EXPENSE_OBJECT_TYPE_CODE = "EX";
        public static final String LEDGER_ENTRY_LOOKUPABLE_FOR_EXPENSE_TRANSFER = "laborLedgerEntryForExpenseTransferLookupable";
        public static final String UnknownPersonName = "* Unknown Name *";
    }
}

