/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.springframework.util.StopWatch;

public class LaborFileRenameStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger();
    private String batchFileDirectoryName;

    public boolean execute(String jobName, Date jobRunDate) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(jobName);
        String filePath = this.batchFileDirectoryName + File.separator;
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add("ld_labentry_kfs");
        fileNameList.add("ld_ldbackup");
        fileNameList.add("ld_prescrub");
        fileNameList.add("ld_sortscrb");
        fileNameList.add("ld_scrbout1");
        fileNameList.add("ld_scrberr1");
        fileNameList.add("ld_expaccts");
        fileNameList.add("ld_sorterr1");
        fileNameList.add("ld_scrbout2");
        fileNameList.add("ld_scrberr2");
        fileNameList.add("ld_sortpost");
        fileNameList.add("ld_postout");
        fileNameList.add("ld_posterrs");
        for (String fileName : fileNameList) {
            File file = new File(filePath + fileName + ".data");
            if (!file.exists()) continue;
            String changedFileName = filePath + fileName + "." + this.getDateTimeService().toDateTimeStringForFilename(jobRunDate);
            file.renameTo(new File(changedFileName + ".data"));
        }
        stopWatch.stop();
        LOG.debug("LaborFileRenameStep of {} took {} minutes to complete", new Supplier[]{() -> jobName, () -> stopWatch.getTotalTimeSeconds() / 60.0});
        return true;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

