/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.gl.exception.LoadException;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;

public class LaborOriginEntryFileIterator
implements Iterator<LaborOriginEntry> {
    private static final Logger LOG = LogManager.getLogger();
    protected LaborOriginEntry nextEntry;
    protected BufferedReader reader;
    protected int lineNumber;
    protected boolean autoCloseReader;

    public LaborOriginEntryFileIterator(BufferedReader reader) {
        this(reader, true);
    }

    public LaborOriginEntryFileIterator(BufferedReader reader, boolean autoCloseReader) {
        if (reader == null) {
            LOG.error("reader is null in the LaborOriginEntryFileIterator!");
            throw new IllegalArgumentException("reader is null!");
        }
        this.reader = reader;
        this.nextEntry = null;
        this.lineNumber = 0;
        this.autoCloseReader = autoCloseReader;
    }

    public LaborOriginEntryFileIterator(File file) {
        if (file == null) {
            LOG.error("reader is null in the LaborOriginEntryFileIterator!");
            throw new IllegalArgumentException("reader is null!");
        }
        try {
            this.reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            this.autoCloseReader = true;
            this.nextEntry = null;
            this.lineNumber = 0;
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = file::getAbsolutePath;
            supplierArray[1] = () -> e;
            LOG.error("File not found for LaborOriginEntryFileIterator! {}", supplierArray);
            throw new RuntimeException("File not found for LaborOriginEntryFileIterator! " + file.getAbsolutePath());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.fetchNextEntry();
            return this.nextEntry != null;
        }
        return true;
    }

    @Override
    public LaborOriginEntry next() {
        if (this.nextEntry != null) {
            LaborOriginEntry temp = this.nextEntry;
            this.nextEntry = null;
            return temp;
        }
        this.fetchNextEntry();
        if (this.nextEntry == null) {
            throw new NoSuchElementException();
        }
        LaborOriginEntry temp = this.nextEntry;
        this.nextEntry = null;
        return temp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove entry from collection");
    }

    protected void fetchNextEntry() {
        block6: {
            try {
                ++this.lineNumber;
                String line = this.reader.readLine();
                if (line == null) {
                    this.nextEntry = null;
                    if (this.autoCloseReader) {
                        this.reader.close();
                    }
                    break block6;
                }
                this.nextEntry = new LaborOriginEntry();
                try {
                    this.nextEntry.setFromTextFileForBatch(line, this.lineNumber - 1);
                }
                catch (LoadException e) {
                    this.nextEntry = null;
                    throw e;
                }
            }
            catch (IOException e) {
                LOG.error("error in the CorrectionDocumentServiceImpl iterator", (Throwable)e);
                this.nextEntry = null;
                throw new RuntimeException("error retrieving origin entries");
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.autoCloseReader && this.reader != null) {
            this.reader.close();
        }
    }
}

