/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ec.EffortCertificationModuleService;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.impl.SalaryTransferPeriodValidationServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class SalaryTransferPeriodValidationServiceImplTest {
    private static final int FISCAL_YEAR = 2009;
    private static final String ACCOUNT_NUMBER = "1031400";
    private static final String CHART = "BL";
    private static final String EMPL_ID = "12345";
    private static final String PERIOD_CODE = "02";
    private static final String REPORT_NUMBER = "1";
    private SalaryTransferPeriodValidationServiceImpl cut;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private EffortCertificationModuleService effortCertificationSvcMock;

    SalaryTransferPeriodValidationServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        this.cut = new SalaryTransferPeriodValidationServiceImpl();
        this.cut.setEffortCertificationService(this.effortCertificationSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
    }

    @Test
    void validateTransfers_NoAccountingLines_VALID(@Mock(stubOnly=true) SalaryExpenseTransferDocument document) {
        Assertions.assertTrue((boolean)this.cut.validateTransfers(document));
    }

    @Test
    void validateTransfers_HasAccountingLines_WithoutNecessaryData_VALID(@Mock(stubOnly=true) SalaryExpenseTransferDocument document) {
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList((ExpenseTransferAccountingLine)Mockito.mock(ExpenseTransferSourceAccountingLine.class)));
        Mockito.when((Object)document.getTargetAccountingLines()).thenReturn(Collections.singletonList((ExpenseTransferAccountingLine)Mockito.mock(ExpenseTransferTargetAccountingLine.class)));
        Assertions.assertTrue((boolean)this.cut.validateTransfers(document));
    }

    @Test
    void validateTransfers_ClosedEffortCertReport_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"C");
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertFalse((boolean)this.cut.validateTransfers(document));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.labor.effortReportPeriodClosed", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)3, (int)messageParameters.length);
        Assertions.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assertions.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assertions.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    void validateTransfers_OpenEffortCertReport_VALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertTrue((boolean)this.cut.validateTransfers(document));
    }

    @Test
    void validateTransfers_EmployeeHasReport_NonCostShareSubAccount_VALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getChartOfAccountsCode()).thenReturn((Object)CHART);
        Mockito.when((Object)transferLineMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn((Object)((EffortCertificationReport)Mockito.mock(EffortCertificationReport.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertTrue((boolean)this.cut.validateTransfers(document));
    }

    @Test
    void validateTransfers_EmployeeHasReport_CostShareSubAccount_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) EffortCertificationReport anotherEffortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)this.effortCertificationSvcMock.getCostShareSubAccountTypeCodes()).thenReturn(Collections.singletonList("CS"));
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)anotherEffortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)anotherEffortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn((Object)anotherEffortCertificationReportMock);
        A21SubAccount a21SubAccountMock = (A21SubAccount)Mockito.mock(A21SubAccount.class);
        Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
        SubAccount subAccountMock = (SubAccount)Mockito.mock(SubAccount.class);
        Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
        Mockito.when((Object)transferLineMock.getSubAccount()).thenReturn((Object)subAccountMock);
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertFalse((boolean)this.cut.validateTransfers(document));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.labor.effortOpenPeriodCostShare", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)3, (int)messageParameters.length);
        Assertions.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assertions.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assertions.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    void validateTransfers_NoEmployeeReport_NonFederalCgAccount_FederalOnlyBalancesTrue_VALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)this.effortCertificationSvcMock.isFederalOnlyBalanceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertTrue((boolean)this.cut.validateTransfers(document));
    }

    @Test
    void validateTransfers_NoEmployeeReport_NonFederalCgAccount_FederalOnlyBalancesFalse_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
        Mockito.when((Object)accountMock.isForContractsAndGrants()).thenReturn((Object)true);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertFalse((boolean)this.cut.validateTransfers(document));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.labor.effortOpenPeriodCGAccount", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)3, (int)messageParameters.length);
        Assertions.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assertions.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assertions.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    void validateTransfers_NoEmployeeReport_FederaCgAccount_FederalOnlyBalancesTrue_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
        Mockito.when((Object)this.effortCertificationSvcMock.isFederalOnlyBalanceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)accountMock.isAwardedByFederalAgency(ArgumentMatchers.anyCollection())).thenReturn((Object)true);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertFalse((boolean)this.cut.validateTransfers(document));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.labor.effortOpenPeriodCGAccount", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)3, (int)messageParameters.length);
        Assertions.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assertions.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assertions.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    void validateTransfers_EmployeeHasReport_NonCostShareSubAccount_OutOfBalance_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) SalaryExpenseTransferDocument document, @Mock(stubOnly=true) EffortCertificationReport effortCertificationReportMock, @Mock(stubOnly=true) EffortCertificationReport anotherEffortCertificationReportMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)document.getEmplid()).thenReturn((Object)EMPL_ID);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getChartOfAccountsCode()).thenReturn((Object)CHART);
        Mockito.when((Object)transferLineMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)anotherEffortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)anotherEffortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn((Object)anotherEffortCertificationReportMock);
        Mockito.when((Object)document.getSourceAccountingLines()).thenReturn(Collections.singletonList(transferLineMock));
        Assertions.assertFalse((boolean)this.cut.validateTransfers(document));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("sourceAccountingLines");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.labor.effortOpenPeriodAccountNonBalanced", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)3, (int)messageParameters.length);
        Assertions.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assertions.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assertions.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    void containsNecessaryData_ContainsAllData_VALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        Assertions.assertTrue((boolean)this.cut.containsNecessaryData(transferLineMock));
    }

    @Test
    void containsNecessaryData_NoAccount_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.containsNecessaryData(transferLineMock));
    }

    @Test
    void containsNecessaryData_NoLaborObject_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.containsNecessaryData(transferLineMock));
    }

    @Test
    void containsNecessaryData_NoAmount_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.containsNecessaryData(transferLineMock));
    }

    @Test
    void containsNecessaryData_NoPayrollEndDateFiscalYear_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.containsNecessaryData(transferLineMock));
    }

    @Test
    void containsNecessaryData_NoPayrollEndDateFiscalPeriodCode_INVALID(@Mock(stubOnly=true) Account accountMock, @Mock(stubOnly=true) ExpenseTransferAccountingLine transferLineMock) {
        Mockito.when((Object)transferLineMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)transferLineMock.getLaborObject()).thenReturn((Object)((LaborObject)Mockito.mock(LaborObject.class)));
        Mockito.when((Object)transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
        Mockito.when((Object)transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.containsNecessaryData(transferLineMock));
    }
}

