/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.businessobject.EmployeeFunding;
import org.kuali.kfs.module.ld.businessobject.LaborCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.ld.dataaccess.LaborCalculatedSalaryFoundationTrackerDao;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class LaborCalculatedSalaryFoundationTrackerDaoOjb
extends PlatformAwareDaoBaseOjb
implements LaborCalculatedSalaryFoundationTrackerDao {
    private static final Logger LOG = LogManager.getLogger(LaborCalculatedSalaryFoundationTrackerDaoOjb.class);

    @Override
    public List<LaborCalculatedSalaryFoundationTracker> findCSFTrackers(Map fieldValues, boolean isConsolidated) {
        LOG.debug("Start findCSFTrackers()");
        ArrayList<LaborCalculatedSalaryFoundationTracker> csfTrackerCollection = new ArrayList<LaborCalculatedSalaryFoundationTracker>();
        if (isConsolidated) {
            List<String> groupByList = this.getGroupByList(isConsolidated);
            List<String> attributeList = this.getAttributeListForCSFTracker(isConsolidated, false);
            Iterator<Object[]> queryResults = this.findConsolidatedCSFTrackerRawData(fieldValues, groupByList, attributeList);
            while (queryResults != null && queryResults.hasNext()) {
                csfTrackerCollection.add(this.marshalCSFTracker(queryResults.next()));
            }
        } else {
            csfTrackerCollection.addAll(this.findDetailedCSFTrackerRawData(fieldValues));
        }
        return csfTrackerCollection;
    }

    @Override
    public List<AccountStatusBaseFunds> findCSFTrackersAsAccountStatusBaseFunds(Map fieldValues, boolean isConsolidated) {
        LOG.debug("Start findCSFTrackersAsAccountStatusBaseFunds()");
        List<String> groupByList = this.getGroupByList(isConsolidated);
        List<String> attributeList = this.getAttributeListForCSFTracker(isConsolidated, false);
        Iterator<Object[]> queryResults = this.findConsolidatedCSFTrackerRawData(fieldValues, groupByList, attributeList);
        ArrayList<AccountStatusBaseFunds> baseFundsCollection = new ArrayList<AccountStatusBaseFunds>();
        while (queryResults != null && queryResults.hasNext()) {
            baseFundsCollection.add(this.marshalCSFTrackerAsAccountStatusBaseFunds(queryResults.next()));
        }
        return baseFundsCollection;
    }

    @Override
    public List<EmployeeFunding> findCSFTrackersAsEmployeeFunding(Map fieldValues, boolean isConsolidated) {
        LOG.debug("Start findCSFTrackersAsEmployeeFunding()");
        List<LaborCalculatedSalaryFoundationTracker> csfTrackerCollection = this.findCSFTrackers(fieldValues, isConsolidated);
        ArrayList<EmployeeFunding> employeeFundingCollection = new ArrayList<EmployeeFunding>();
        for (LaborCalculatedSalaryFoundationTracker csfTracker : csfTrackerCollection) {
            EmployeeFunding employeeFunding = new EmployeeFunding();
            ObjectUtil.buildObject((Object)((Object)employeeFunding), (Object)((Object)csfTracker));
            employeeFundingCollection.add(employeeFunding);
        }
        return employeeFundingCollection;
    }

    protected Iterator<Object[]> findConsolidatedCSFTrackerRawData(Map fieldValues, List<String> groupByList, List<String> attributeList) {
        Criteria tempCriteria1 = new Criteria();
        tempCriteria1.addEqualTo("csfDeleteCode", (Object)"-");
        Criteria tempCriteria2 = new Criteria();
        tempCriteria2.addIsNull("csfDeleteCode");
        tempCriteria2.addOrCriteria(tempCriteria1);
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new LaborCalculatedSalaryFoundationTracker()));
        criteria.addAndCriteria(tempCriteria2);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LaborCalculatedSalaryFoundationTracker.class, (Criteria)criteria);
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        String[] attributes = attributeList.toArray(new String[attributeList.size()]);
        query.setAttributes(attributes);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected Collection<LaborCalculatedSalaryFoundationTracker> findDetailedCSFTrackerRawData(Map fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new LaborCalculatedSalaryFoundationTracker()));
        QueryByCriteria query = QueryFactory.newQuery(LaborCalculatedSalaryFoundationTracker.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    protected LaborCalculatedSalaryFoundationTracker marshalCSFTracker(Object[] queryResult) {
        LaborCalculatedSalaryFoundationTracker CSFTracker = new LaborCalculatedSalaryFoundationTracker();
        List<String> keyFields = this.getAttributeListForCSFTracker(false, true);
        ObjectUtil.buildObject((Object)((Object)CSFTracker), (Object[])queryResult, keyFields);
        return CSFTracker;
    }

    protected AccountStatusBaseFunds marshalCSFTrackerAsAccountStatusBaseFunds(Object[] queryResult) {
        AccountStatusBaseFunds baseFunds = new AccountStatusBaseFunds();
        List<String> keyFields = this.getAttributeListForCSFTracker(false, true);
        ObjectUtil.buildObject((Object)((Object)baseFunds), (Object[])queryResult, keyFields);
        return baseFunds;
    }

    protected EmployeeFunding marshalCSFTrackerAsEmployeeFunding(Object[] queryResult) {
        EmployeeFunding employeeFunding = new EmployeeFunding();
        List<String> keyFields = this.getAttributeListForCSFTracker(false, true);
        ObjectUtil.buildObject((Object)((Object)employeeFunding), (Object[])queryResult, keyFields);
        return employeeFunding;
    }

    protected List<String> getGroupByList(boolean isConsolidated) {
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("universityFiscalYear");
        groupByList.add("chartOfAccountsCode");
        groupByList.add("accountNumber");
        groupByList.add("financialObjectCode");
        if (!isConsolidated) {
            groupByList.add("subAccountNumber");
            groupByList.add("financialSubObjectCode");
        }
        return groupByList;
    }

    protected List<String> getAttributeList(boolean isConsolidated) {
        List<String> attributeList = this.getGroupByList(isConsolidated);
        if (isConsolidated) {
            attributeList.add("'*ALL*'");
            attributeList.add("'*ALL*'");
        }
        return attributeList;
    }

    protected List<String> getAttributeListForCSFTracker(boolean isConsolidated, boolean isAttributeNameNeeded) {
        List<String> attributeList = this.getAttributeList(isConsolidated);
        if (!isAttributeNameNeeded) {
            attributeList.add(ConsolidationUtil.sum("csfFullTimeEmploymentQuantity"));
            attributeList.add(ConsolidationUtil.sum("csfAmount"));
        } else {
            attributeList.add("csfFullTimeEmploymentQuantity");
            attributeList.add("csfAmount");
        }
        return attributeList;
    }
}

