/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborJournalVoucherDetail;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.kim.api.identity.PersonService;

public class LaborJournalVoucherEmployeeIDExistenceCheckValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;
    private DataDictionaryService dataDictionaryService;
    private PersonService personService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        LaborJournalVoucherDetail laborJournalVoucherDetail = (LaborJournalVoucherDetail)this.getAccountingLineForValidation();
        String emplid = laborJournalVoucherDetail.getEmplid();
        if (StringUtils.isBlank((CharSequence)emplid) || LaborConstants.getDashEmplId().equals(emplid)) {
            return true;
        }
        if (!this.employeeIDExistenceCheck(emplid)) {
            result = false;
        }
        return result;
    }

    protected boolean employeeIDExistenceCheck(String employeeId) {
        boolean employeeIDExists = true;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("employeeId", employeeId);
        List emplidMatches = this.personService.findPeople(criteria);
        if (emplidMatches == null || emplidMatches.isEmpty()) {
            String label = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(LaborJournalVoucherDetail.class.getName()).getAttributeDefinition("emplid").getLabel();
            GlobalVariables.getMessageMap().putError("emplid", "error.existence", new String[]{label});
            employeeIDExists = false;
        }
        return employeeIDExists;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

