/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class TransactionFieldValidator {
    private static LaborAccountingCycleCachingService accountingCycleCachingService;
    private static ConfigurationService kualiConfigurationService;

    private TransactionFieldValidator() {
    }

    public static Message checkUniversityFiscalYear(LaborTransaction transaction) {
        Integer fiscalYear = transaction.getUniversityFiscalYear();
        if (fiscalYear == null) {
            return MessageBuilder.buildMessage((String)"error.gl.UniversityFiscalYearNotFound", (int)1);
        }
        SystemOptions option = TransactionFieldValidator.getAccountingCycleCachingService().getSystemOptions(transaction.getUniversityFiscalYear());
        if (ObjectUtils.isNull((Object)option)) {
            return MessageBuilder.buildMessage((String)"error.gl.UniversityFiscalYearNotFound", (String)fiscalYear.toString(), (int)1);
        }
        return null;
    }

    public static Message checkChartOfAccountsCode(LaborTransaction transaction) {
        String chartOfAccountsCode = transaction.getChartOfAccountsCode();
        Chart chart = TransactionFieldValidator.getAccountingCycleCachingService().getChart(transaction.getChartOfAccountsCode());
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode) || ObjectUtils.isNull((Object)chart)) {
            return MessageBuilder.buildMessage((String)"error.gl.ChartNotFound", (String)chartOfAccountsCode, (int)1);
        }
        if (!chart.isActive()) {
            return MessageBuilder.buildMessage((String)"error.gl.ChartNotActive", (String)chartOfAccountsCode, (int)1);
        }
        return null;
    }

    public static Message checkAccountNumber(LaborTransaction transaction) {
        String accountNumber = transaction.getAccountNumber();
        Account account = TransactionFieldValidator.getAccountingCycleCachingService().getAccount(transaction.getChartOfAccountsCode(), transaction.getAccountNumber());
        if (StringUtils.isBlank((CharSequence)accountNumber) || ObjectUtils.isNull((Object)account)) {
            String chartOfAccountsCode = transaction.getChartOfAccountsCode();
            String accountKey = chartOfAccountsCode + "-" + accountNumber;
            return MessageBuilder.buildMessage((String)"error.gl.AccountNotFound", (String)accountKey, (int)1);
        }
        return null;
    }

    public static Message checkSubAccountNumber(LaborTransaction transaction) {
        return TransactionFieldValidator.checkSubAccountNumber(transaction, null);
    }

    public static Message checkSubAccountNumber(LaborTransaction transaction, String exclusiveDocumentTypeCode) {
        String subAccountNumber = transaction.getSubAccountNumber();
        String chartOfAccountsCode = transaction.getChartOfAccountsCode();
        String accountNumber = transaction.getAccountNumber();
        String documentTypeCode = transaction.getFinancialDocumentTypeCode();
        String subAccountKey = chartOfAccountsCode + "-" + accountNumber + "-" + subAccountNumber;
        SubAccount subAccount = TransactionFieldValidator.getAccountingCycleCachingService().getSubAccount(transaction.getChartOfAccountsCode(), transaction.getAccountNumber(), transaction.getSubAccountNumber());
        if (StringUtils.isBlank((CharSequence)subAccountNumber)) {
            return MessageBuilder.buildMessage((String)"error.gl.SubAccountNotFound", (String)subAccountKey, (int)1);
        }
        if (!KFSConstants.getDashSubAccountNumber().equals(subAccountNumber)) {
            if (ObjectUtils.isNull((Object)subAccount)) {
                return MessageBuilder.buildMessage((String)"error.gl.SubAccountNotFound", (String)subAccountKey, (int)1);
            }
            if (!StringUtils.equals((CharSequence)documentTypeCode, (CharSequence)exclusiveDocumentTypeCode) && !subAccount.isActive()) {
                return MessageBuilder.buildMessage((String)"error.gl.SubAccountNotActive", (String)subAccountKey, (int)1);
            }
        }
        return null;
    }

    public static Message checkFinancialObjectCode(LaborTransaction transaction) {
        String objectCode = transaction.getFinancialObjectCode();
        if (StringUtils.isBlank((CharSequence)objectCode)) {
            return MessageBuilder.buildMessage((String)"error.gl.ObjectCodeEmpty", (int)1);
        }
        Integer fiscalYear = transaction.getUniversityFiscalYear();
        String chartOfAccountsCode = transaction.getChartOfAccountsCode();
        String objectCodeKey = fiscalYear + "-" + chartOfAccountsCode + "-" + objectCode;
        ObjectCode financialObject = TransactionFieldValidator.getAccountingCycleCachingService().getObjectCode(transaction.getUniversityFiscalYear(), transaction.getChartOfAccountsCode(), transaction.getFinancialObjectCode());
        transaction.refreshNonUpdateableReferences();
        if (ObjectUtils.isNull((Object)financialObject)) {
            return MessageBuilder.buildMessage((String)"error.gl.ObjectCodeNotFound", (String)objectCodeKey, (int)1);
        }
        return null;
    }

    public static Message checkFinancialSubObjectCode(LaborTransaction transaction) {
        Integer fiscalYear = transaction.getUniversityFiscalYear();
        String chartOfAccountsCode = transaction.getChartOfAccountsCode();
        String objectCode = transaction.getFinancialObjectCode();
        String subObjectCode = transaction.getFinancialSubObjectCode();
        String subObjectCodeKey = fiscalYear + "-" + chartOfAccountsCode + "-" + objectCode + "-" + subObjectCode;
        if (StringUtils.isBlank((CharSequence)subObjectCode)) {
            return MessageBuilder.buildMessage((String)"error.gl.NullSubObjectCode", (String)subObjectCodeKey, (int)1);
        }
        SubObjectCode financialSubObject = TransactionFieldValidator.getAccountingCycleCachingService().getSubObjectCode(transaction.getUniversityFiscalYear(), transaction.getChartOfAccountsCode(), transaction.getAccountNumber(), transaction.getFinancialObjectCode(), transaction.getFinancialSubObjectCode());
        if (!KFSConstants.getDashFinancialSubObjectCode().equals(subObjectCode) && ObjectUtils.isNull((Object)financialSubObject)) {
            return MessageBuilder.buildMessage((String)"error.gl.NullSubObjectCode", (String)subObjectCodeKey, (int)1);
        }
        return null;
    }

    public static Message checkFinancialBalanceTypeCode(LaborTransaction transaction) {
        String balanceTypeCode = transaction.getFinancialBalanceTypeCode();
        BalanceType balanceType = TransactionFieldValidator.getAccountingCycleCachingService().getBalanceType(transaction.getFinancialBalanceTypeCode());
        if (StringUtils.isBlank((CharSequence)balanceTypeCode) || ObjectUtils.isNull((Object)balanceType)) {
            return MessageBuilder.buildMessage((String)"error.gl.BalanceTypeNotFound", (String)balanceTypeCode, (int)1);
        }
        return null;
    }

    public static Message checkFinancialObjectTypeCode(LaborTransaction transaction) {
        String objectTypeCode = transaction.getFinancialObjectTypeCode();
        ObjectType objectType = TransactionFieldValidator.getAccountingCycleCachingService().getObjectType(transaction.getFinancialObjectTypeCode());
        if (StringUtils.isBlank((CharSequence)objectTypeCode) || ObjectUtils.isNull((Object)objectType)) {
            return MessageBuilder.buildMessage((String)"error.gl.ObjectTypeNotFound", (String)objectTypeCode, (int)1);
        }
        return null;
    }

    public static Message checkUniversityFiscalPeriodCode(LaborTransaction transaction) {
        String fiscalPeriodCode = transaction.getUniversityFiscalPeriodCode();
        if (StringUtils.isBlank((CharSequence)fiscalPeriodCode)) {
            return MessageBuilder.buildMessage((String)"error.gl.AccountingPeriodNotFound", (String)fiscalPeriodCode, (int)1);
        }
        return null;
    }

    public static Message checkFinancialDocumentTypeCode(LaborTransaction transaction) {
        if (StringUtils.isBlank((CharSequence)transaction.getFinancialDocumentTypeCode()) || !TransactionFieldValidator.getAccountingCycleCachingService().isCurrentActiveAccountingDocumentType(transaction.getFinancialDocumentTypeCode())) {
            return MessageBuilder.buildMessage((String)"error.gl.DocumentTypeNotFound", (String)transaction.getFinancialDocumentTypeCode(), (int)1);
        }
        return null;
    }

    public static Message checkFinancialDocumentNumber(LaborTransaction transaction) {
        String documentNumber = transaction.getDocumentNumber();
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            return MessageBuilder.buildMessage((String)"error.gl.DocumentNumberRequired", (int)1);
        }
        return null;
    }

    public static Message checkTransactionDebitCreditCode(LaborTransaction transaction) {
        Object[] validDebitCreditCode = new String[]{" ", "C", "D"};
        String debitCreditCode = transaction.getTransactionDebitCreditCode();
        if (debitCreditCode == null || !ArrayUtils.contains((Object[])validDebitCreditCode, (Object)debitCreditCode)) {
            return MessageBuilder.buildMessage((String)"error.gl.NullDebitCreditIndicator", (int)1);
        }
        if (transaction.getBalanceType().isFinancialOffsetGenerationIndicator() && !"D".equals(transaction.getTransactionDebitCreditCode()) && !"C".equals(transaction.getTransactionDebitCreditCode())) {
            return new Message(TransactionFieldValidator.getConfigurationService().getPropertyValueAsString("message.gl.DebitCreditCodeMustBe") + " '" + "D" + " or " + "C" + TransactionFieldValidator.getConfigurationService().getPropertyValueAsString("message.gl.ForBalanceType"), 1);
        }
        return null;
    }

    public static Message checkFinancialSystemOriginationCode(LaborTransaction transaction) {
        String originationCode = transaction.getFinancialSystemOriginationCode();
        if (StringUtils.isBlank((CharSequence)originationCode)) {
            return MessageBuilder.buildMessage((String)"error.gl.OriginCodeNotFound", (int)1);
        }
        return null;
    }

    public static Message checkPostablePeridCode(LaborTransaction transaction, Collection<String> unpostableperidCodes) {
        String periodCode = transaction.getUniversityFiscalPeriodCode();
        if (unpostableperidCodes.contains(periodCode)) {
            return MessageBuilder.buildMessage((String)"error.labor.unpostablePerioCodes", (String)periodCode, (int)1);
        }
        return null;
    }

    public static Message checkPostableBalanceTypeCode(LaborTransaction transaction, Collection<String> unpostableBalanceTypeCodes) {
        String balanceTypeCode = transaction.getFinancialBalanceTypeCode();
        if (unpostableBalanceTypeCodes.contains(balanceTypeCode)) {
            return MessageBuilder.buildMessage((String)"error.labor.unpostableBalanceTypeCode", (String)balanceTypeCode, (int)1);
        }
        return null;
    }

    public static Message checkZeroTotalAmount(LaborTransaction transaction) {
        KualiDecimal amount = transaction.getTransactionLedgerEntryAmount();
        if (amount == null || amount.isZero()) {
            return MessageBuilder.buildMessage((String)"error.labor.zeroTotalAmount", (int)1);
        }
        return null;
    }

    public static Message checkEmplid(LaborTransaction transaction) {
        String emplid = transaction.getEmplid();
        if (StringUtils.isBlank((CharSequence)emplid)) {
            return MessageBuilder.buildMessage((String)"error.labor.missingEmployeeIdError", (int)1);
        }
        return null;
    }

    public static Message checkEncumbranceUpdateCode(LaborTransaction transaction) {
        if (!(!StringUtils.isNotBlank((CharSequence)transaction.getTransactionEncumbranceUpdateCode()) || " ".equals(transaction.getTransactionEncumbranceUpdateCode()) || "N".equals(transaction.getTransactionEncumbranceUpdateCode()) || "R".equals(transaction.getTransactionEncumbranceUpdateCode()) || "D".equals(transaction.getTransactionEncumbranceUpdateCode()))) {
            return new Message("Invalid Encumbrance Update Code (" + transaction.getTransactionEncumbranceUpdateCode() + ")", 1);
        }
        return null;
    }

    static LaborAccountingCycleCachingService getAccountingCycleCachingService() {
        if (accountingCycleCachingService == null) {
            accountingCycleCachingService = (LaborAccountingCycleCachingService)SpringContext.getBean(LaborAccountingCycleCachingService.class);
        }
        return accountingCycleCachingService;
    }

    static ConfigurationService getConfigurationService() {
        if (kualiConfigurationService == null) {
            kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return kualiConfigurationService;
    }
}

