/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.ld.batch.service.impl.LaborPosterServiceImpl;
import org.kuali.kfs.module.ld.service.LaborTransactionDescriptionService;

public class LaborTransactionDescriptionServiceImpl
implements LaborTransactionDescriptionService {
    private static final Logger LOG = LogManager.getLogger(LaborPosterServiceImpl.class);
    private Map<String, String> transactionDescriptionMap;
    private DataDictionaryService dataDictionaryService;

    @Override
    public String getTransactionDescription(Transaction transaction) {
        String documentTypeCode = transaction.getFinancialDocumentTypeCode();
        String description = this.getTransactionDescription(documentTypeCode);
        description = StringUtils.isNotEmpty((CharSequence)description) ? description : transaction.getTransactionLedgerEntryDescription();
        int transactionDescriptionMaxLength = this.dataDictionaryService.getAttributeMaxLength(transaction.getClass(), "transactionLedgerEntryDescription");
        if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > transactionDescriptionMaxLength) {
            description = StringUtils.left((String)description, (int)transactionDescriptionMaxLength);
        }
        return description;
    }

    @Override
    public String getTransactionDescription(String descriptionKey) {
        if (this.transactionDescriptionMap.containsKey(descriptionKey)) {
            return this.transactionDescriptionMap.get(descriptionKey);
        }
        LOG.warn("Cannot find a description for the given key: " + descriptionKey);
        return "";
    }

    public void setTransactionDescriptionMap(Map<String, String> transactionDescriptionMap) {
        this.transactionDescriptionMap = transactionDescriptionMap;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

