/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.fp.businessobject.VoucherSourceAccountingLine;
import org.kuali.kfs.sys.businessobject.SystemOptions;

import java.math.BigDecimal;
import java.sql.Date;

/**
 * Labor Journal Voucher Detail Business Object.
 */
public class LaborJournalVoucherDetail extends VoucherSourceAccountingLine {

    private String positionNumber;
    private Date payPeriodEndDate;
    private BigDecimal transactionTotalHours;
    private Integer payrollEndDateFiscalYear;
    private String payrollEndDateFiscalPeriodCode;
    private String emplid;
    private Integer employeeRecord;
    private String earnCode;
    private String payGroup;
    private String salaryAdministrationPlan;
    private String grade;
    private String runIdentifier;
    private String laborLedgerOriginalChartOfAccountsCode;
    private String laborLedgerOriginalAccountNumber;
    private String laborLedgerOriginalSubAccountNumber;
    private String laborLedgerOriginalFinancialObjectCode;
    private String laborLedgerOriginalFinancialSubObjectCode;
    private String hrmsCompany;
    private String setid;
    private SystemOptions payrollEndDateOptions;
    private AccountingPeriod payrollEndDateFiscalPeriod;
    private SystemOptions options;

    public LaborJournalVoucherDetail() {
        super();
    }

    public String getEarnCode() {
        return earnCode;
    }

    public String getEmplid() {
        return emplid;
    }

    public Integer getEmployeeRecord() {
        return employeeRecord;
    }

    public String getGrade() {
        return grade;
    }

    public String getHrmsCompany() {
        return hrmsCompany;
    }

    public String getLaborLedgerOriginalAccountNumber() {
        return laborLedgerOriginalAccountNumber;
    }

    public String getLaborLedgerOriginalChartOfAccountsCode() {
        return laborLedgerOriginalChartOfAccountsCode;
    }

    public String getLaborLedgerOriginalFinancialObjectCode() {
        return laborLedgerOriginalFinancialObjectCode;
    }

    public String getLaborLedgerOriginalFinancialSubObjectCode() {
        return laborLedgerOriginalFinancialSubObjectCode;
    }

    public String getLaborLedgerOriginalSubAccountNumber() {
        return laborLedgerOriginalSubAccountNumber;
    }

    public SystemOptions getOptions() {
        return options;
    }

    public String getPayGroup() {
        return payGroup;
    }

    public Date getPayPeriodEndDate() {
        return payPeriodEndDate;
    }

    public AccountingPeriod getPayrollEndDateFiscalPeriod() {
        return payrollEndDateFiscalPeriod;
    }

    public SystemOptions getPayrollEndDateOptions() {
        return payrollEndDateOptions;
    }

    public String getPositionNumber() {
        return positionNumber;
    }

    public String getRunIdentifier() {
        return runIdentifier;
    }

    public String getSalaryAdministrationPlan() {
        return salaryAdministrationPlan;
    }

    public String getSetid() {
        return setid;
    }

    public BigDecimal getTransactionTotalHours() {
        return transactionTotalHours;
    }

    public void setEarnCode(String earnCode) {
        this.earnCode = earnCode;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public void setEmployeeRecord(Integer employeeRecord) {
        this.employeeRecord = employeeRecord;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setHrmsCompany(String hrmsCompany) {
        this.hrmsCompany = hrmsCompany;
    }

    public void setLaborLedgerOriginalAccountNumber(String laborLedgerOriginalAccountNumber) {
        this.laborLedgerOriginalAccountNumber = laborLedgerOriginalAccountNumber;
    }

    public void setLaborLedgerOriginalChartOfAccountsCode(String laborLedgerOriginalChartOfAccountsCode) {
        this.laborLedgerOriginalChartOfAccountsCode = laborLedgerOriginalChartOfAccountsCode;
    }

    public void setLaborLedgerOriginalFinancialObjectCode(String laborLedgerOriginalFinancialObjectCode) {
        this.laborLedgerOriginalFinancialObjectCode = laborLedgerOriginalFinancialObjectCode;
    }

    public void setLaborLedgerOriginalFinancialSubObjectCode(String laborLedgerOriginalFinancialSubObjectCode) {
        this.laborLedgerOriginalFinancialSubObjectCode = laborLedgerOriginalFinancialSubObjectCode;
    }

    public void setLaborLedgerOriginalSubAccountNumber(String laborLedgerOriginalSubAccountNumber) {
        this.laborLedgerOriginalSubAccountNumber = laborLedgerOriginalSubAccountNumber;
    }

    public void setOptions(SystemOptions options) {
        this.options = options;
    }

    public void setPayGroup(String payGroup) {
        this.payGroup = payGroup;
    }

    public void setPayPeriodEndDate(Date payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
    }

    public void setPayrollEndDateFiscalPeriod(AccountingPeriod payrollEndDateFiscalPeriod) {
        this.payrollEndDateFiscalPeriod = payrollEndDateFiscalPeriod;
    }

    public void setPayrollEndDateOptions(SystemOptions payrollEndDateOptions) {
        this.payrollEndDateOptions = payrollEndDateOptions;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public void setRunIdentifier(String runIdentifier) {
        this.runIdentifier = runIdentifier;
    }

    public void setSalaryAdministrationPlan(String salaryAdministrationPlan) {
        this.salaryAdministrationPlan = salaryAdministrationPlan;
    }

    public void setSetid(String setid) {
        this.setid = setid;
    }

    public void setTransactionTotalHours(BigDecimal transactionTotalHours) {
        this.transactionTotalHours = transactionTotalHours;
    }

    public String getPayrollEndDateFiscalPeriodCode() {
        return payrollEndDateFiscalPeriodCode;
    }

    public void setPayrollEndDateFiscalPeriodCode(String payrollEndDateFiscalPeriodCode) {
        try {
            Integer i = Integer.valueOf(payrollEndDateFiscalPeriodCode);
            if (i < 10 && payrollEndDateFiscalPeriodCode.length() == 1) {
                payrollEndDateFiscalPeriodCode = "0" + payrollEndDateFiscalPeriodCode;
            }
        } catch (NumberFormatException e) {
            // ignore
        }
        this.payrollEndDateFiscalPeriodCode = payrollEndDateFiscalPeriodCode;
    }

    public Integer getPayrollEndDateFiscalYear() {
        return payrollEndDateFiscalYear;
    }

    public void setPayrollEndDateFiscalYear(Integer payrollEndDateFiscalYear) {
        this.payrollEndDateFiscalYear = payrollEndDateFiscalYear;
    }

}
