/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class PurchaseOrderRetransmitDocument
extends PurchaseOrderDocument {
    protected static Logger LOG = Logger.getLogger(PurchaseOrderRetransmitDocument.class);
    protected boolean shouldDisplayRetransmitTab;

    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
    }

    public KualiDecimal getTotalDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal totalAmount = item.getTotalAmount();
            KualiDecimal itemTotal = totalAmount != null ? totalAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    public KualiDecimal getTotalPreTaxDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal extendedPrice = item.getExtendedPrice();
            KualiDecimal itemTotal = extendedPrice != null ? extendedPrice : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    public KualiDecimal getTotalTaxDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal taxAmount = item.getItemTaxAmount();
            KualiDecimal itemTotal = taxAmount != null ? taxAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        try {
            if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForApprovedPODocuments(this);
                this.setPurchaseOrderLastTransmitTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
                this.updateAndSaveAppDocStatus("Open");
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedChangePODocuments(this);
                try {
                    String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                    String reqStatus = PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
                    this.updateAndSaveAppDocStatus(PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(reqStatus));
                }
                catch (WorkflowException e) {
                    this.logAndThrowRuntimeException("Error saving routing data while saving App Doc Status " + this.getDocumentNumber(), (Exception)((Object)e));
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledChangePODocuments(this);
                this.updateAndSaveAppDocStatus("Cancelled");
            }
        }
        catch (WorkflowException e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
        }
    }

    public boolean isShouldDisplayRetransmitTab() {
        return this.shouldDisplayRetransmitTab;
    }

    public void setShouldDisplayRetransmitTab(boolean shouldDisplayRetransmitTab) {
        this.shouldDisplayRetransmitTab = shouldDisplayRetransmitTab;
    }

    @Override
    protected boolean shouldAdhocFyi() {
        return false;
    }
}

