/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class VendorCreditMemoItemExtendedPriceValidation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;
    private CreditMemoItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)event.getDocument();
        String errorKeyPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "].";
        String errorKey = errorKeyPrefix + "extendedPrice";
        if (this.itemForValidation.getExtendedPrice() != null) {
            if (this.itemForValidation.getExtendedPrice().isNegative()) {
                String label = this.dataDictionaryService.getAttributeErrorLabel(CreditMemoItem.class, "extendedPrice");
                GlobalVariables.getMessageMap().putError(errorKey, "errors.creditMemo.itemAmount.aboveZero", new String[]{label});
                valid = false;
            }
            if (!cmDocument.isSourceVendor()) {
                KualiDecimal invoicedAmount = null;
                invoicedAmount = cmDocument.isSourceDocumentPurchaseOrder() ? this.itemForValidation.getPoTotalAmount() : this.itemForValidation.getPreqTotalAmount();
                if (invoicedAmount == null) {
                    invoicedAmount = KualiDecimal.ZERO;
                }
                if (this.itemForValidation.getTotalAmount().isGreaterThan((AbstractKualiDecimal)invoicedAmount)) {
                    GlobalVariables.getMessageMap().putError(errorKey, "errors.creditMemo.item.extendedPrice.tooMuch", new String[0]);
                    valid = false;
                }
            }
        }
        return valid;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public CreditMemoItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(CreditMemoItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

