/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.kns.service.TransactionalDocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentTestUtils;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.purap.fixture.CreditMemoItemFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;

@ConfigureContext(session=UserNameFixture.appleton)
public class CreditMemoDocumentTest
extends KualiTestBase {
    public static final Class<VendorCreditMemoDocument> DOCUMENT_CLASS = VendorCreditMemoDocument.class;
    private static final String ACCOUNT_REVIEW = "Account Review";
    private RequisitionDocument requisitionDocument = null;
    private VendorCreditMemoDocument creditMemoDocument = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.creditMemoDocument = null;
        super.tearDown();
    }

    private List<CreditMemoItemFixture> getItemParametersFromFixtures() {
        ArrayList<CreditMemoItemFixture> list = new ArrayList<CreditMemoItemFixture>();
        list.add(CreditMemoItemFixture.CM_ITEM_NO_APO);
        return list;
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    public final void testAddItem() throws Exception {
        ArrayList<AccountsPayableItem> items = new ArrayList<AccountsPayableItem>();
        items.add(CreditMemoItemFixture.CM_ITEM_NO_APO.createCreditMemoItem());
        int expectedItemTotal = items.size();
        AccountsPayableDocumentTestUtils.testAddItem((AccountsPayableDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), DOCUMENT_CLASS), items, expectedItemTotal);
    }

    public final void testGetNewDocument() throws Exception {
        AccountingDocumentTestUtils.testGetNewDocument_byDocumentClass(DOCUMENT_CLASS, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testConvertIntoErrorCorrection() throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        AccountingDocumentTestUtils.testConvertIntoErrorCorrection((AccountingDocument)this.creditMemoDocument, (int)this.getExpectedPrePeCount(), (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), (TransactionalDocumentDictionaryService)((TransactionalDocumentDictionaryService)SpringContext.getBean(TransactionalDocumentDictionaryService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testSaveDocument() throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        this.creditMemoDocument.setAccountsPayableProcessorIdentifier("khuntley");
        AccountingDocumentTestUtils.testSaveDocument((FinancialSystemTransactionalDocument)this.creditMemoDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final VendorCreditMemoDocument routeDocument(PaymentRequestDocument preqDocument) throws Exception {
        this.creditMemoDocument = this.buildSimpleDocument();
        this.creditMemoDocument.setPaymentRequestDocument(preqDocument);
        this.creditMemoDocument.setPurchaseOrderIdentifier(preqDocument.getPurchaseOrderIdentifier());
        CreditMemoItem cmItem = (CreditMemoItem)this.creditMemoDocument.getItem(0);
        cmItem.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        cmItem.setItemQuantity(new KualiDecimal(1));
        cmItem.setPreqTotalAmount(new KualiDecimal(1));
        ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).calculateCreditMemo(this.creditMemoDocument);
        this.creditMemoDocument.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        CreditMemoDocumentTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.creditMemoDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)this.creditMemoDocument, (String)"saving copy source docu ament", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)this.creditMemoDocument.getDocumentNumber());
        return this.creditMemoDocument;
    }

    public VendorCreditMemoDocument buildSimpleDocument() throws Exception {
        return CreditMemoDocumentFixture.CM_ONLY_REQUIRED_FIELDS.createCreditMemoDocument();
    }

    private UserNameFixture getInitialUserName() {
        return UserNameFixture.rjweiss;
    }

    protected UserNameFixture getTestUserName() {
        return UserNameFixture.rorenfro;
    }
}

