/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.AccountingDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class PurchasingAccountsPayableTransactionalDocumentAuthorizerBase
extends AccountingDocumentAuthorizerBase {
    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        List<SensitiveData> sensitiveDataList;
        super.addRoleQualification(businessObject, attributes);
        attributes.put("documentSensitive", "false");
        PurchasingAccountsPayableDocument purapDoc = (PurchasingAccountsPayableDocument)businessObject;
        if (purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier() != null && ObjectUtils.isNotNull(sensitiveDataList = ((SensitiveDataService)SpringContext.getBean(SensitiveDataService.class)).getSensitiveDatasAssignedByRelatedDocId(purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier())) && !sensitiveDataList.isEmpty()) {
            StringBuffer sensitiveDataCodes = new StringBuffer();
            for (SensitiveData sensitiveData : sensitiveDataList) {
                if (!ObjectUtils.isNotNull((Object)((Object)sensitiveData))) continue;
                sensitiveDataCodes.append(sensitiveData.getSensitiveDataCode()).append(";");
            }
            if (sensitiveDataCodes.length() > 0) {
                attributes.put("documentSensitive", "true");
                attributes.put("sensitiveDataCode", sensitiveDataCodes.toString().substring(0, sensitiveDataCodes.length() - 1));
                attributes.put("accountsPayablePurchasingDocumentLinkIdentifier", purapDoc.getAccountsPayablePurchasingDocumentLinkIdentifier().toString());
            }
        }
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.isAuthorizedByTemplate((BusinessObject)document, "KR-NS", "Edit Document", user.getPrincipalId());
    }
}

