/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchaseOrderAmendmentAccountValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PurchaseOrderDocument poaDocument = (PurchaseOrderDocument)event.getDocument();
        List items = poaDocument.getItemsActiveOnly();
        PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(poaDocument.getPurapDocumentIdentifier());
        List poItems = po.getItems();
        block0: for (PurApItem item : items) {
            String identifierString = item.getItemIdentifierString();
            if (!item.getItemTypeCode().equals("ITEM") || item.getSourceAccountingLines() == null || item.getSourceAccountingLines().size() <= 0 || !this.isItemChanged(item, poItems)) continue;
            List<PurApAccountingLine> accountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine accountingLine : accountingLines) {
                if (accountingLine.getAccount().isExpired()) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.expired", new String[]{accountingLine.getAccount().getAccountNumber()});
                    continue block0;
                }
                if (accountingLine.getAccount().isActive()) continue;
                valid = false;
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.inactive", new String[]{accountingLine.getAccount().getAccountNumber()});
                continue block0;
            }
        }
        return valid;
    }

    private boolean isItemChanged(PurApItem poaItem, List<PurApItem> poItems) {
        boolean changed = false;
        int poaItemId = poaItem.getItemLineNumber();
        for (PurApItem poItem : poItems) {
            if (!poItem.getItemTypeCode().equals("ITEM") || poaItemId != poItem.getItemLineNumber()) continue;
            if (poaItem.getItemQuantity() == null || poaItem.getItemQuantity().intValue() != poItem.getItemQuantity().intValue()) {
                changed = true;
            }
            if (!poaItem.getItemUnitOfMeasureCode().equals(poItem.getItemUnitOfMeasureCode())) {
                changed = true;
            }
            if (poaItem.getItemUnitPrice() == null || poaItem.getItemUnitPrice().floatValue() != poItem.getItemUnitPrice().floatValue()) {
                changed = true;
            }
            if (poaItem.getTotalAmount().floatValue() != poItem.getTotalAmount().floatValue()) {
                changed = true;
            }
            if (poaItem.getItemAssignedToTradeInIndicator() != poItem.getItemAssignedToTradeInIndicator()) {
                changed = true;
            }
            if (poaItem.getItemCatalogNumber() != null && !poaItem.getItemCatalogNumber().equals(poItem.getItemCatalogNumber()) || poItem.getItemCatalogNumber() != null && !poItem.getItemCatalogNumber().equals(poaItem.getItemCatalogNumber())) {
                changed = true;
            }
            if (poaItem.getItemDescription() != null && !poaItem.getItemDescription().equals(poItem.getItemDescription()) || poItem.getItemDescription() != null && !poItem.getItemDescription().equals(poaItem.getItemDescription())) {
                changed = true;
            }
            if (poaItem.getExtendedPrice() != null && poItem.getExtendedPrice() != null && poaItem.getExtendedPrice().floatValue() != poItem.getExtendedPrice().floatValue() || poaItem.getExtendedPrice() != null && poaItem.getExtendedPrice().floatValue() != 0.0f && poItem.getExtendedPrice() == null || poaItem.getExtendedPrice() == null && poItem.getExtendedPrice() != null && poItem.getExtendedPrice().floatValue() != 0.0f) {
                changed = true;
            }
            if (!(poaItem.getItemTaxAmount() != null && poItem.getItemTaxAmount() != null && poaItem.getItemTaxAmount().floatValue() != poItem.getItemTaxAmount().floatValue() || poaItem.getItemTaxAmount() != null && poaItem.getItemTaxAmount().floatValue() != 0.0f && poItem.getItemTaxAmount() != null) && (poaItem.getItemTaxAmount() != null || poItem.getItemTaxAmount() == null || poItem.getItemTaxAmount().floatValue() == 0.0f)) break;
            changed = true;
            break;
        }
        return changed;
    }
}

