/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingItemUnitPriceValidation
extends GenericValidation {
    private PurApItem itemForValidation;
    private DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        if (this.itemForValidation.getItemType().isLineItemIndicator() && ObjectUtils.isNull((Object)this.itemForValidation.getItemUnitPrice())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(this.itemForValidation.getClass().getName()).getAttributeDefinition("itemUnitPrice").getLabel();
            String errorPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]." + "itemUnitPrice";
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.required", new String[]{attributeLabel + " in " + this.itemForValidation.getItemIdentifierString()});
        }
        if (ObjectUtils.isNotNull((Object)this.itemForValidation.getItemUnitPrice())) {
            if (BigDecimal.ZERO.compareTo(this.itemForValidation.getItemUnitPrice()) > 0 && !this.itemForValidation.getItemTypeCode().equals("ORDS") && !this.itemForValidation.getItemTypeCode().equals("TRDI")) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.belowZero", new String[]{"Unit Cost", this.itemForValidation.getItemIdentifierString()});
                valid = false;
            } else if (BigDecimal.ZERO.compareTo(this.itemForValidation.getItemUnitPrice()) < 0 && (this.itemForValidation.getItemTypeCode().equals("ORDS") || this.itemForValidation.getItemTypeCode().equals("TRDI"))) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.notBelowZero", new String[]{"Unit Cost", this.itemForValidation.getItemIdentifierString()});
                valid = false;
            }
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

