/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.List;
import java.util.Set;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchaseOrderDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

public class PurchaseOrderAmendmentDocumentPresentationController
extends PurchaseOrderDocumentPresentationController {
    @Override
    public boolean canEdit(Document document) {
        WorkflowDocument workflowDocument;
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if ("Change in Process".equals(poDocument.getApplicationDocumentStatus()) && !(workflowDocument = poDocument.getFinancialSystemDocumentHeader().getWorkflowDocument()).isInitiated() && !workflowDocument.isSaved() && !workflowDocument.isCompletionRequested()) {
            return false;
        }
        return super.canEdit(document);
    }

    @Override
    public Set<String> getEditModes(Document document) {
        WorkflowDocument workflowDocument;
        Set<String> editModes = super.getEditModes(document);
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        if ("Change in Process".equals(poDocument.getApplicationDocumentStatus()) && ((workflowDocument = poDocument.getFinancialSystemDocumentHeader().getWorkflowDocument()).isInitiated() || workflowDocument.isSaved() || workflowDocument.isCompletionRequested())) {
            editModes.add("amendmentEntry");
        }
        if ("Awaiting New Unordered Item Review".equals(poDocument.getApplicationDocumentStatus())) {
            editModes.add("amendmentEntry");
        }
        if (((PurapService)SpringContext.getBean(PurapService.class)).isDocumentStoppedInRouteNode((PurchasingAccountsPayableDocument)document, "New Unordered Items")) {
            editModes.add("unorderedItemAccountEntry");
        }
        boolean showDisableRemoveAccounts = true;
        PurchaseOrderAmendmentDocument purchaseOrderAmendmentDocument = (PurchaseOrderAmendmentDocument)document;
        List<PurApItem> aboveTheLinePOItems = PurApItemUtils.getAboveTheLineOnly(purchaseOrderAmendmentDocument.getItems());
        PurchaseOrderDocument po = (PurchaseOrderDocument)document;
        boolean containsUnpaidPaymentRequestsOrCreditMemos = po.getContainsUnpaidPaymentRequestsOrCreditMemos();
        block0: for (PurApItem poItem : aboveTheLinePOItems) {
            boolean acctLinesEditable = this.allowAccountingLinesAreEditable((PurchaseOrderItem)poItem, containsUnpaidPaymentRequestsOrCreditMemos);
            for (PurApAccountingLine poAccoutingLine : poItem.getSourceAccountingLines()) {
                if (acctLinesEditable) continue;
                showDisableRemoveAccounts = false;
                break block0;
            }
        }
        if (!showDisableRemoveAccounts) {
            editModes.add("disableRemoveAccounts");
        }
        return editModes;
    }

    protected boolean allowAccountingLinesAreEditable(PurchaseOrderItem poItem, boolean containsUnpaidPaymentRequestsOrCreditMemos) {
        if (poItem != null && !poItem.getItemType().isAdditionalChargeIndicator()) {
            if (!poItem.isItemActiveIndicator()) {
                return false;
            }
            if (poItem.getItemInvoicedTotalAmount() != null && poItem.getItemInvoicedTotalAmount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                return false;
            }
            if (containsUnpaidPaymentRequestsOrCreditMemos && !poItem.isNewItemForAmendment()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canReload(Document document) {
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)document;
        WorkflowDocument workflowDocument = poDocument.getFinancialSystemDocumentHeader().getWorkflowDocument();
        return workflowDocument.isSaved() || workflowDocument.isEnroute();
    }
}

