/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.fp.businessobject.NonResidentAlienTaxPercent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentRequestTaxAreaValidation
extends GenericValidation {
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        PaymentRequestDocument preq = (PaymentRequestDocument)event.getDocument();
        if (!StringUtils.equals((String)preq.getApplicationDocumentStatus(), (String)"Awaiting Tax Approval")) {
            return true;
        }
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        errorMap.addToErrorPath("document.tax*");
        boolean valid = true;
        valid &= this.validateTaxIncomeClass(preq);
        valid &= this.validateTaxRates(preq);
        errorMap.clearErrorPath();
        return valid &= this.validateTaxIndicators(preq);
    }

    protected boolean validateTaxIncomeClass(PaymentRequestDocument preq) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isEmpty((String)preq.getTaxClassificationCode())) {
            valid = false;
            errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.required", new String[]{"taxClassificationCode"});
        } else if (StringUtils.equalsIgnoreCase((String)preq.getTaxClassificationCode(), (String)"N")) {
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxStatePercent"});
            }
            if (!StringUtils.isEmpty((String)preq.getTaxCountryCode())) {
                valid = false;
                errorMap.putError("taxCountryCode", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxCountryCode"});
            }
            if (!StringUtils.isEmpty((String)preq.getTaxNQIId())) {
                valid = false;
                errorMap.putError("taxNQIId", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxNQIId"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxSpecialW4Amount"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxForeignSourceIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxUSAIDPerDiemIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxUSAIDPerDiemIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxOtherExemptIndicator"});
            }
        } else {
            if (preq.getTaxFederalPercent() == null) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() == null) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxStatePercent"});
            }
            if (StringUtils.isEmpty((String)preq.getTaxCountryCode())) {
                valid = false;
                errorMap.putError("taxCountryCode", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxCountryCode"});
            }
        }
        return valid;
    }

    protected boolean validateTaxRates(PaymentRequestDocument preq) {
        boolean hasstrate;
        ArrayList<BigDecimal> strates;
        boolean valid = true;
        String code = preq.getTaxClassificationCode();
        BigDecimal fedrate = preq.getTaxFederalPercent();
        BigDecimal strate = preq.getTaxStatePercent();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isEmpty((String)code) || StringUtils.equalsIgnoreCase((String)code, (String)"N") || fedrate == null || strate == null) {
            return true;
        }
        ArrayList<BigDecimal> fedrates = this.retrieveTaxRates(code, "F");
        if (!this.listContainsValue(fedrates, fedrate)) {
            valid = false;
            errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
        }
        if (!this.listContainsValue(strates = this.retrieveTaxRates(code, "S"), strate)) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxClassificationCode", "taxStatePercent"});
        }
        if (fedrate.compareTo(new BigDecimal(0)) == 0 && strate.compareTo(new BigDecimal(0)) != 0) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxFederalPercent", "taxStatePercent"});
        }
        boolean bl = hasstrate = code.equalsIgnoreCase("F") || code.equalsIgnoreCase("A") || code.equalsIgnoreCase("O");
        if (fedrate.compareTo(new BigDecimal(0)) > 0 && strate.compareTo(new BigDecimal(0)) <= 0 && hasstrate) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.not.zero.if", new String[]{"taxFederalPercent", "taxStatePercent"});
        }
        return valid;
    }

    protected boolean validateTaxIndicators(PaymentRequestDocument preq) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxForeignSourceIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxUSAIDPerDiemIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxExemptTreatyIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxExemptTreatyIndicator", "taxStatePercent"});
            }
        }
        if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxForeignSourceIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxUSAIDPerDiemIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() == null || preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) == 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.not.zero.if", new String[]{"taxGrossUpIndicator", "taxFederalPercent"});
            }
        }
        if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxUSAIDPerDiemIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxForeignSourceIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxForeignSourceIndicator", "taxStatePercent"});
            }
        }
        if (ObjectUtils.equals((Object)preq.getTaxUSAIDPerDiemIndicator(), (Object)true)) {
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxForeignSourceIndicator"});
            }
            if (!ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.required.if", new String[]{"taxUSAIDPerDiemIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxSpecialW4Amount"});
            }
            if (StringUtils.isEmpty((String)preq.getTaxClassificationCode()) || !StringUtils.equalsIgnoreCase((String)preq.getTaxClassificationCode(), (String)"F")) {
                valid = false;
                errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxUSAIDPerDiemIndicator", "taxClassificationCode"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxUSAIDPerDiemIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxUSAIDPerDiemIndicator", "taxStatePercent"});
            }
        }
        if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)true)) {
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxForeignSourceIndicator"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxOtherExemptIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxOtherExemptIndicator", "taxStatePercent"});
            }
        }
        if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
            if (ObjectUtils.equals((Object)preq.getTaxExemptTreatyIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxExemptTreatyIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxGrossUpIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxGrossUpIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxForeignSourceIndicator(), (Object)true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxForeignSourceIndicator"});
            }
            if (ObjectUtils.equals((Object)preq.getTaxOtherExemptIndicator(), (Object)false)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.exempt.under.other.code.must.be.checked", new String[]{"taxSpecialW4Amount", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) < 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.value.must.not.negative", new String[]{"taxSpecialW4Amount"});
            }
            if (StringUtils.isEmpty((String)preq.getTaxClassificationCode()) || !StringUtils.equalsIgnoreCase((String)preq.getTaxClassificationCode(), (String)"F")) {
                valid = false;
                errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxSpecialW4Amount", "taxClassificationCode"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxSpecialW4Amount", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxSpecialW4Amount", "taxStatePercent"});
            }
        }
        return valid;
    }

    public ArrayList<BigDecimal> retrieveTaxRates(String incomeClassCode, String incomeTaxTypeCode) {
        ArrayList<BigDecimal> rates = new ArrayList<BigDecimal>();
        HashMap<String, String> criterion = new HashMap<String, String>();
        criterion.put("incomeClassCode", incomeClassCode);
        criterion.put("incomeTaxTypeCode", incomeTaxTypeCode);
        criterion.put("active", "Y");
        List percents = (List)this.businessObjectService.findMatching(NonResidentAlienTaxPercent.class, criterion);
        for (NonResidentAlienTaxPercent percent : percents) {
            rates.add(percent.getIncomeTaxPercent().bigDecimalValue());
        }
        return rates;
    }

    protected boolean listContainsValue(ArrayList<BigDecimal> list, BigDecimal value) {
        if (list == null || value == null) {
            return false;
        }
        for (BigDecimal val : list) {
            if (val.compareTo(value) != 0) continue;
            return true;
        }
        return false;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

