/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;

public class PurchaseOrderAddQuoteToVendorValidation
extends GenericValidation {
    private PurchaseOrderDocument accountingDocumentForValidation;
    private PurchaseOrderVendorQuote vendorQuote;
    private VendorService vendorService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        valid &= this.isVendorQuoteActiveNotDebarredVendor(this.vendorQuote.getVendorHeaderGeneratedIdentifier(), this.vendorQuote.getVendorDetailAssignedIdentifier());
        return valid &= this.vendorQuoteHasRequiredFields(this.vendorQuote);
    }

    protected boolean isVendorQuoteActiveNotDebarredVendor(Integer vendorHeaderGeneratedIdentifier, Integer vendorDetailAssignedIdentifer) {
        VendorDetail vendorDetail = this.vendorService.getVendorDetail(vendorHeaderGeneratedIdentifier, vendorDetailAssignedIdentifer);
        if (vendorDetail != null) {
            if (!vendorDetail.isActiveIndicator()) {
                GlobalVariables.getMessageMap().putError("newPurchaseOrderVendorQuote.vendorName", "error.purchaseOrder.quote.inactive.vendor", new String[0]);
                return false;
            }
            if (vendorDetail.isVendorDebarred()) {
                GlobalVariables.getMessageMap().putError("newPurchaseOrderVendorQuote.vendorName", "error.purchaseOrder.quote.debarred.vendor", new String[0]);
                return false;
            }
        }
        return true;
    }

    protected boolean vendorQuoteHasRequiredFields(PurchaseOrderVendorQuote vendorQuote) {
        boolean valid = true;
        if (StringUtils.isBlank((String)vendorQuote.getVendorName())) {
            GlobalVariables.getMessageMap().putError("newPurchaseOrderVendorQuote.vendorName", "error.required", new String[]{"Vendor Name"});
            valid = false;
        }
        if (StringUtils.isBlank((String)vendorQuote.getVendorLine1Address())) {
            GlobalVariables.getMessageMap().putError("newPurchaseOrderVendorQuote.vendorLine1Address", "error.required", new String[]{"Vendor Line 1 Address"});
            valid = false;
        }
        if (StringUtils.isBlank((String)vendorQuote.getVendorCityName())) {
            GlobalVariables.getMessageMap().putError("newPurchaseOrderVendorQuote.vendorCityName", "error.required", new String[]{"Vendor City Name"});
            valid = false;
        }
        return valid;
    }

    public PurchaseOrderDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(PurchaseOrderDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public PurchaseOrderVendorQuote getVendorQuote() {
        return this.vendorQuote;
    }

    public void setVendorQuote(PurchaseOrderVendorQuote vendorQuote) {
        this.vendorQuote = vendorQuote;
    }

    public VendorService getVendorService() {
        return this.vendorService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }
}

