/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurApItemFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderItemFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.document.DocumentStatus;

public class PurchaseOrderChangeDocumentTest
extends KualiTestBase {
    protected static DocumentService docService = null;
    protected static PurchaseOrderService poService = null;
    protected static PurchaseOrderDocument poTest = null;
    protected static PurchaseOrderDocument poChange = null;

    protected void setUp() throws Exception {
        super.setUp();
        docService = (DocumentService)SpringContext.getBean(DocumentService.class);
        poService = (PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class);
        poTest = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        poTest.setApplicationDocumentStatus("Open");
        poTest.refreshNonUpdateableReferences();
        poTest.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)poTest, (DocumentService)docService);
    }

    protected void tearDown() throws Exception {
        docService = null;
        poService = null;
        poTest = null;
        poChange = null;
        super.tearDown();
    }

    private void refreshPO() {
        poTest = poService.getPurchaseOrderByDocumentNumber(poTest.getDocumentNumber());
    }

    private void createAndSavePOChangeDocument(String documentType, String documentStatus) throws Exception {
        try {
            poChange = poService.createAndSavePotentialChangeDocument(poTest.getDocumentNumber(), documentType, documentStatus);
            poChange = (PurchaseOrderDocument)docService.getByDocumentHeaderId(poChange.getDocumentNumber());
            poTest = poService.getPurchaseOrderByDocumentNumber(poTest.getDocumentNumber());
        }
        catch (ValidationException ve) {
            throw new ValidationException(GlobalVariables.getMessageMap().toString() + (Object)((Object)ve));
        }
    }

    private void createAndRoutePOChangeDocument(String documentType, String documentStatus) throws Exception {
        try {
            poChange = poService.createAndRoutePotentialChangeDocument(poTest.getDocumentNumber(), documentType, "unit test", new ArrayList(), documentStatus);
            poTest = poService.getPurchaseOrderByDocumentNumber(poTest.getDocumentNumber());
        }
        catch (ValidationException ve) {
            throw new ValidationException(GlobalVariables.getMessageMap().toString() + (Object)((Object)ve));
        }
    }

    private void createAndSavePOSplitDocument(List<PurchaseOrderItem> newPOItems, boolean copyNotes, String splitNoteText) throws Exception {
        try {
            poTest.setApplicationDocumentStatus("In Process");
            poChange = poService.createAndSavePurchaseOrderSplitDocument(newPOItems, poTest, copyNotes, splitNoteText);
            poTest = poService.getPurchaseOrderByDocumentNumber(poTest.getDocumentNumber());
        }
        catch (ValidationException ve) {
            throw new ValidationException(GlobalVariables.getMessageMap().toString() + (Object)((Object)ve));
        }
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public final void testPurchaseOrderClose() throws Exception {
        this.changeCurrentUser(UserNameFixture.appleton);
        PaymentRequestDocument preq = PaymentRequestDocumentFixture.PREQ_FOR_PO_CLOSE_DOC.createPaymentRequestDocument();
        preq.setPurchaseOrderIdentifier(poTest.getPurapDocumentIdentifier());
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)preq, (DocumentService)docService);
        this.createAndRoutePOChangeDocument("POC", "Pending Close");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Retired Version"));
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Closed"));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testSplitPurchaseOrder() throws Exception {
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        items.add((PurchaseOrderItem)PurchaseOrderItemFixture.PO_QTY_UNRESTRICTED_ITEM_2.createPurchaseOrderItem(PurApItemFixture.BASIC_QTY_ITEM_2));
        this.createAndSavePOSplitDocument(items, true, "Reason for splitting.");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertTrue((poTest.getPurapDocumentIdentifier().compareTo(poChange.getPurapDocumentIdentifier()) < 0 ? 1 : 0) != 0);
        PurchaseOrderChangeDocumentTest.assertFalse((poChange.getItems().size() == 1 ? 1 : 0) != 0);
        PurchaseOrderChangeDocumentTest.assertFalse((poTest.getItems().size() == 1 ? 1 : 0) != 0);
        List splitPOItems = poChange.getItems();
        int i = 0;
        for (PurchaseOrderItem splitPOItem : splitPOItems) {
            if (!splitPOItem.getItemType().isLineItemIndicator()) continue;
            PurchaseOrderChangeDocumentTest.assertTrue((splitPOItem.getItemLineNumber() == ++i ? 1 : 0) != 0);
        }
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testAmendPurchaseOrder() throws Exception {
        this.createAndSavePOChangeDocument("POA", "Pending Amendment");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        if (!poChange.getDocumentHeader().getWorkflowDocument().getStatus().equals((Object)DocumentStatus.FINAL)) {
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.isPurchaseOrderCurrentIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.isPendingActionIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Pending Amendment"));
            PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPurchaseOrderCurrentIndicator());
            PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Change in Process"));
        }
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public final void testCancelAmendPurchaseOrder() throws Exception {
        this.createAndSavePOChangeDocument("POA", "Pending Amendment");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        if (!poChange.getDocumentHeader().getWorkflowDocument().getStatus().equals((Object)DocumentStatus.FINAL)) {
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.isPurchaseOrderCurrentIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.isPendingActionIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Pending Amendment"));
            PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPurchaseOrderCurrentIndicator());
            PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
            PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Change in Process"));
        }
        ((DocumentService)SpringContext.getBean(DocumentService.class)).cancelDocument((Document)poChange, "");
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("X"));
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public final void testPurchaseOrderPaymentHold() throws Exception {
        this.createAndRoutePOChangeDocument("POPH", "Pending Payment Hold");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Retired Version"));
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Payment Hold"));
    }

    @ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=true)
    public final void testPurchaseOrderRemoveHold() throws Exception {
        poTest.setApplicationDocumentStatus("Payment Hold");
        poTest.refreshNonUpdateableReferences();
        this.createAndRoutePOChangeDocument("PORH", "Pending Remove Hold");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Retired Version"));
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Open"));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testPurchaseOrderReopen() throws Exception {
        poTest.setApplicationDocumentStatus("Closed");
        poTest.refreshNonUpdateableReferences();
        this.createAndRoutePOChangeDocument("POR", "Pending Reopen");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Retired Version"));
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Open"));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testPurchaseOrderVoid() throws Exception {
        this.createAndRoutePOChangeDocument("POV", "Pending Void");
        PurchaseOrderChangeDocumentTest.assertMatchChangePO(poTest, poChange);
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poTest.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poTest.getApplicationDocumentStatus().equals("Retired Version"));
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.isPurchaseOrderCurrentIndicator());
        PurchaseOrderChangeDocumentTest.assertFalse((boolean)poChange.isPendingActionIndicator());
        PurchaseOrderChangeDocumentTest.assertTrue((boolean)poChange.getApplicationDocumentStatus().equals("Void"));
    }

    public static void assertMatchChangePO(PurchaseOrderDocument doc1, PurchaseOrderDocument doc2) {
        if (StringUtils.isNotBlank((String)doc1.getPostingPeriodCode()) && StringUtils.isNotBlank((String)doc2.getPostingPeriodCode())) {
            Assert.assertEquals((String)doc1.getPostingPeriodCode(), (String)doc2.getPostingPeriodCode());
        }
        Assert.assertEquals((Object)doc1.getPostingYear(), (Object)doc2.getPostingYear());
        Assert.assertEquals((Object)doc1.getVendorHeaderGeneratedIdentifier(), (Object)doc2.getVendorHeaderGeneratedIdentifier());
        Assert.assertEquals((Object)doc1.getVendorDetailAssignedIdentifier(), (Object)doc2.getVendorDetailAssignedIdentifier());
        Assert.assertEquals((String)doc1.getVendorName(), (String)doc2.getVendorName());
        Assert.assertEquals((String)doc1.getVendorNumber(), (String)doc2.getVendorNumber());
        Assert.assertEquals((String)doc1.getChartOfAccountsCode(), (String)doc2.getChartOfAccountsCode());
        Assert.assertEquals((String)doc1.getOrganizationCode(), (String)doc2.getOrganizationCode());
        Assert.assertEquals((String)doc1.getDeliveryCampusCode(), (String)doc2.getDeliveryCampusCode());
        Assert.assertEquals((Object)doc1.getDeliveryRequiredDate(), (Object)doc2.getDeliveryRequiredDate());
        Assert.assertEquals((String)doc1.getRequestorPersonName(), (String)doc2.getRequestorPersonName());
        Assert.assertEquals((Object)doc1.getContractManagerCode(), (Object)doc2.getContractManagerCode());
        Assert.assertEquals((String)doc1.getVendorContractName(), (String)doc2.getVendorContractName());
        Assert.assertEquals((boolean)doc1.getPurchaseOrderAutomaticIndicator(), (boolean)doc2.getPurchaseOrderAutomaticIndicator());
        Assert.assertEquals((String)doc1.getPurchaseOrderTransmissionMethodCode(), (String)doc2.getPurchaseOrderTransmissionMethodCode());
        Assert.assertEquals((Object)doc1.getRequisitionIdentifier(), (Object)doc2.getRequisitionIdentifier());
        Assert.assertEquals((Object)doc1.getPurchaseOrderPreviousIdentifier(), (Object)doc2.getPurchaseOrderPreviousIdentifier());
        Assert.assertEquals((Object)doc1.getPurchaseOrderCreateTimestamp(), (Object)doc2.getPurchaseOrderCreateTimestamp());
        Assert.assertEquals((Object)doc1.getPurchaseOrderLastTransmitTimestamp(), (Object)doc2.getPurchaseOrderLastTransmitTimestamp());
    }
}

