/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.document.dataaccess.ThresholdDao;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ThresholdDaoOjb
extends PlatformAwareDaoBaseOjb
implements ThresholdDao {
    private static Logger LOG = Logger.getLogger(ThresholdDaoOjb.class);

    @Override
    public Collection<ReceivingThreshold> findByChart(String chartCode) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(1);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndFund(String chartCode, String fund) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.ACCOUNT_TYPE_CODE, fund);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndSubFund(String chartCode, String subFund) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.SUBFUND_GROUP_CODE, subFund);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndCommodity(String chartCode, String commodityCode) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.COMMODITY_CODE, commodityCode);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndObjectCode(String chartCode, String objectCode) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.FINANCIAL_OBJECT_CODE, objectCode);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndOrg(String chartCode, String org) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(2);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.ORGANIZATION_CODE, org);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    @Override
    public Collection<ReceivingThreshold> findByChartAndVendor(String chartCode, String vendorHeaderGeneratedIdentifier, String vendorDetailAssignedIdentifier) {
        HashMap<ThresholdField, Object> criteriaFields = new HashMap<ThresholdField, Object>(3);
        criteriaFields.put(ThresholdField.CHART_OF_ACCOUNTS_CODE, chartCode);
        criteriaFields.put(ThresholdField.VENDOR_HEADER_GENERATED_ID, vendorHeaderGeneratedIdentifier);
        criteriaFields.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID, vendorDetailAssignedIdentifier);
        criteriaFields.put(ThresholdField.ACTIVE, Boolean.TRUE);
        return this.getThresholdEnum(criteriaFields);
    }

    protected Collection<ReceivingThreshold> getThresholdEnum(Map criteriaFields) {
        if (criteriaFields == null || criteriaFields.size() == 0) {
            return null;
        }
        Criteria criteria = new Criteria();
        List allFields = ThresholdField.getEnumList();
        for (int i = 0; i < allFields.size(); ++i) {
            if (!((ThresholdField)((Object)allFields.get(i))).isPersistedField()) continue;
            Object criteriaValue = criteriaFields.get(allFields.get(i));
            if (criteriaValue != null) {
                criteria.addEqualTo(((ThresholdField)((Object)allFields.get(i))).getName(), criteriaValue);
                continue;
            }
            criteria.addIsNull(((ThresholdField)((Object)allFields.get(i))).getName());
        }
        QueryByCriteria query = new QueryByCriteria(ReceivingThreshold.class, criteria);
        Collection c = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return c;
    }

    protected ReceivingThreshold returnAMockObject() {
        ReceivingThreshold newOne = new ReceivingThreshold();
        newOne.setThresholdAmount(new KualiDecimal(10.0));
        return newOne;
    }
}

