/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashSet;
import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableCheckNegativeAccountsValidation
extends GenericValidation {
    private PurapAccountingService purapAccountingService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)event.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        this.purapAccountingService.updateAccountAmounts(document);
        HashSet<String> excludedItemTypeCodes = new HashSet<String>();
        excludedItemTypeCodes.add("TRDI");
        List<SourceAccountingLine> sourceLines = this.purapAccountingService.generateSummaryExcludeItemTypes(document.getItems(), excludedItemTypeCodes);
        for (SourceAccountingLine sourceAccountingLine : sourceLines) {
            boolean isTaxAccount = this.purapAccountingService.isTaxAccount(document, sourceAccountingLine);
            if (isTaxAccount || !sourceAccountingLine.getAmount().isNegative()) continue;
            String subAccountNumber = sourceAccountingLine.getSubAccountNumber() == null ? "" : sourceAccountingLine.getSubAccountNumber();
            String subObjectCode = sourceAccountingLine.getFinancialSubObjectCode() == null ? "" : sourceAccountingLine.getFinancialSubObjectCode();
            String projCode = sourceAccountingLine.getProjectCode() == null ? "" : sourceAccountingLine.getProjectCode();
            String orgRefId = sourceAccountingLine.getOrganizationReferenceId() == null ? "" : sourceAccountingLine.getOrganizationReferenceId();
            String accountString = sourceAccountingLine.getChartOfAccountsCode() + " - " + sourceAccountingLine.getAccountNumber() + " - " + subAccountNumber + " - " + sourceAccountingLine.getFinancialObjectCode() + " - " + subObjectCode + " - " + projCode + " - " + orgRefId;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.accountString.totalAmount.negative", new String[]{accountString, sourceAccountingLine.getAmount() + ""});
            valid &= false;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    public PurapAccountingService getPurapAccountingService() {
        return this.purapAccountingService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }
}

