/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class PurchasingCommodityCodesForDistributionValidation
extends GenericValidation {
    private String purchasingCommodityCode;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("purchasingCommodityCode", this.purchasingCommodityCode);
        Collection result = this.businessObjectService.findMatching(CommodityCode.class, fieldValues);
        if (result != null && result.size() > 0) {
            CommodityCode commodityCode = (CommodityCode)result.iterator().next();
            if (!commodityCode.isActive()) {
                valid = false;
                GlobalVariables.getMessageMap().putError("accountDistributionnewSourceLine", "error.commodity.code.inactive", new String[]{" in distribute commodity code"});
            }
        } else {
            valid = false;
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*");
            GlobalVariables.getMessageMap().putError("accountDistributionnewSourceLine", "error.commodity.code.invalid", new String[]{" in distribute commodity code"});
        }
        return valid;
    }

    public String getPurchasingCommodityCode() {
        return this.purchasingCommodityCode;
    }

    public void setPurchasingCommodityCode(String purchasingCommodityCode) {
        this.purchasingCommodityCode = purchasingCommodityCode;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

