/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurapAccountRevisionGroup {
    protected String chartOfAccountsCode;
    protected String accountNumber;
    protected String subAccountNumber;
    protected String financialObjectCode;
    protected String financialSubObjectCode;
    protected Integer postingYear;
    protected String postingPeriodCode;
    protected KualiDecimal amount;
    protected Integer itemIdentifier;
    private List<PurApAccountingLineBase> sourceEntries = new ArrayList<PurApAccountingLineBase>();
    private KualiDecimal changeAmount;
    private String projectCode;
    private String organizationReferenceId;
    private BigDecimal accountLinePercent;

    public PurapAccountRevisionGroup(PurApAccountingLineBase entry) {
        this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        this.setAccountNumber(entry.getAccountNumber());
        this.setSubAccountNumber(entry.getSubAccountNumber());
        this.setFinancialObjectCode(entry.getFinancialObjectCode());
        this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
        this.setItemIdentifier(entry.getItemIdentifier());
        this.setPostingYear(entry.getPostingYear());
        this.setPostingPeriodCode(entry.getPostingPeriodCode());
        this.setProjectCode(entry.getProjectCode());
        this.setOrganizationReferenceId(entry.getOrganizationReferenceId());
        this.setAccountLinePercent(entry.getAccountLinePercent());
        this.sourceEntries.add(entry);
        this.setAmount(entry.getAmount());
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public Integer getPostingYear() {
        return this.postingYear;
    }

    public void setPostingYear(Integer postingYear) {
        this.postingYear = postingYear;
    }

    public String getPostingPeriodCode() {
        return this.postingPeriodCode;
    }

    public void setPostingPeriodCode(String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !PurapAccountRevisionGroup.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        PurapAccountRevisionGroup test = (PurapAccountRevisionGroup)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.postingYear, (Object)test.getPostingYear());
        equalsBuilder.append((Object)this.itemIdentifier, (Object)test.getItemIdentifier());
        equalsBuilder.append((Object)this.replaceFiller(this.chartOfAccountsCode), (Object)this.replaceFiller(test.getChartOfAccountsCode()));
        equalsBuilder.append((Object)this.replaceFiller(this.accountNumber), (Object)this.replaceFiller(test.getAccountNumber()));
        equalsBuilder.append((Object)this.replaceFiller(this.subAccountNumber), (Object)this.replaceFiller(test.getSubAccountNumber()));
        equalsBuilder.append((Object)this.replaceFiller(this.financialObjectCode), (Object)this.replaceFiller(test.getFinancialObjectCode()));
        equalsBuilder.append((Object)this.replaceFiller(this.financialSubObjectCode), (Object)this.replaceFiller(test.getFinancialSubObjectCode()));
        equalsBuilder.append((Object)this.replaceFiller(this.postingPeriodCode), (Object)this.replaceFiller(test.getPostingPeriodCode()));
        equalsBuilder.append((Object)this.replaceFiller(this.projectCode), (Object)this.replaceFiller(test.getProjectCode()));
        equalsBuilder.append((Object)this.replaceFiller(this.organizationReferenceId), (Object)this.replaceFiller(test.getOrganizationReferenceId()));
        return equalsBuilder.isEquals();
    }

    protected String replaceFiller(String val) {
        char[] charArray;
        if (val == null) {
            return "";
        }
        for (char c : charArray = val.trim().toCharArray()) {
            if (c == '-') continue;
            return val;
        }
        return "";
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(37, 41);
        hashCodeBuilder.append((Object)this.postingYear);
        hashCodeBuilder.append((Object)this.itemIdentifier);
        hashCodeBuilder.append((Object)this.replaceFiller(this.chartOfAccountsCode));
        hashCodeBuilder.append((Object)this.replaceFiller(this.accountNumber));
        hashCodeBuilder.append((Object)this.replaceFiller(this.subAccountNumber));
        hashCodeBuilder.append((Object)this.replaceFiller(this.financialObjectCode));
        hashCodeBuilder.append((Object)this.replaceFiller(this.financialSubObjectCode));
        hashCodeBuilder.append((Object)this.replaceFiller(this.postingPeriodCode));
        hashCodeBuilder.append((Object)this.replaceFiller(this.projectCode));
        hashCodeBuilder.append((Object)this.replaceFiller(this.organizationReferenceId));
        return hashCodeBuilder.toHashCode();
    }

    public KualiDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(KualiDecimal absAmount) {
        this.amount = absAmount;
    }

    public String toString() {
        return "" + this.postingYear + "-" + this.chartOfAccountsCode + "-" + this.accountNumber + "-" + this.replaceFiller(this.subAccountNumber) + "-" + this.financialObjectCode + "-" + this.replaceFiller(this.financialSubObjectCode) + "-" + this.postingPeriodCode + "-" + this.itemIdentifier;
    }

    public Integer getItemIdentifier() {
        return this.itemIdentifier;
    }

    public void setItemIdentifier(Integer itemIdentifier) {
        this.itemIdentifier = itemIdentifier;
    }

    public void combineEntry(PurApAccountingLineBase newEntry) {
        this.sourceEntries.add(newEntry);
        this.amount = (KualiDecimal)this.amount.add((AbstractKualiDecimal)newEntry.getAmount());
    }

    public KualiDecimal getChangeAmount() {
        return this.changeAmount;
    }

    public void setChangeAmount(KualiDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrganizationReferenceId() {
        return this.organizationReferenceId;
    }

    public void setOrganizationReferenceId(String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    public BigDecimal getAccountLinePercent() {
        return this.accountLinePercent;
    }

    public void setAccountLinePercent(BigDecimal accountLinePercent) {
        this.accountLinePercent = accountLinePercent;
    }

    public PurApAccountingLineBase buildRevisionRecord(Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase histRecord = null;
        try {
            histRecord = clazz.newInstance();
            histRecord.setItemIdentifier(this.getItemIdentifier());
            histRecord.setChartOfAccountsCode(this.getChartOfAccountsCode());
            histRecord.setAccountNumber(this.getAccountNumber());
            histRecord.setSubAccountNumber(this.getSubAccountNumber());
            histRecord.setFinancialObjectCode(this.getFinancialObjectCode());
            histRecord.setFinancialSubObjectCode(this.getFinancialSubObjectCode());
            histRecord.setProjectCode(this.getProjectCode());
            histRecord.setOrganizationReferenceId(this.getOrganizationReferenceId());
            histRecord.setAmount(this.getChangeAmount());
            histRecord.setPostingYear(this.getPostingYear());
            histRecord.setPostingPeriodCode(this.getPostingPeriodCode());
            histRecord.setAccountLinePercent(this.getAccountLinePercent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return histRecord;
    }
}

