/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class ContractManagerAssignmentDocument
extends FinancialSystemTransactionalDocumentBase {
    protected static Logger LOG = Logger.getLogger(ContractManagerAssignmentDocument.class);
    protected List<ContractManagerAssignmentDetail> contractManagerAssignmentDetails = new ArrayList<ContractManagerAssignmentDetail>();
    protected String requisitionNumber;
    protected String deliveryCampusCode;
    protected String vendorName;
    protected String generalDescription;
    protected String requisitionTotalAmount;
    protected String requisitionCreateDate;
    protected String firstItemDescription;
    protected String firstItemCommodityCode;
    protected String firstObjectCode;
    protected String universityFiscalYear;

    public ContractManagerAssignmentDetail getContractManagerAssignmentDetail(int index) {
        while (this.contractManagerAssignmentDetails.size() <= index) {
            this.contractManagerAssignmentDetails.add(new ContractManagerAssignmentDetail());
        }
        return this.contractManagerAssignmentDetails.get(index);
    }

    public void populateDocumentWithRequisitions() {
        LOG.debug((Object)"populateDocumentWithRequisitions() Entering method.");
        ArrayList<RequisitionDocument> unassignedRequisitions = new ArrayList<RequisitionDocument>(((RequisitionService)SpringContext.getBean(RequisitionService.class)).getRequisitionsAwaitingContractManagerAssignment());
        ArrayList<String> documentHeaderIds = new ArrayList<String>();
        for (RequisitionDocument req : unassignedRequisitions) {
            documentHeaderIds.add(req.getDocumentNumber());
        }
        List requisitionDocumentsFromDocService = new ArrayList();
        try {
            if (documentHeaderIds.size() > 0) {
                requisitionDocumentsFromDocService = ((DocumentService)SpringContext.getBean(DocumentService.class)).getDocumentsByListOfDocumentHeaderIds(RequisitionDocument.class, documentHeaderIds);
            }
        }
        catch (WorkflowException we) {
            String errorMsg = "Workflow Exception caught: " + we.getLocalizedMessage();
            LOG.error((Object)errorMsg, (Throwable)we);
            throw new RuntimeException(errorMsg, we);
        }
        for (Document req : requisitionDocumentsFromDocService) {
            this.contractManagerAssignmentDetails.add(new ContractManagerAssignmentDetail(this, (RequisitionDocument)req));
        }
        String[] fieldNames = new String[]{"deliveryCampusCode", "vendorName", "requisitionIdentifier"};
        DynamicCollectionComparator.sort(this.contractManagerAssignmentDetails, (String[])fieldNames);
        LOG.debug((Object)"populateDocumentWithRequisitions() Leaving method.");
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug((Object)"doRouteStatusChange() Entering method.");
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
            boolean isSuccess = true;
            StringBuffer failedReqs = new StringBuffer();
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).processACMReq(this);
            if (!isSuccess) {
                failedReqs.deleteCharAt(failedReqs.lastIndexOf(","));
                WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
                String currentNodeName = null;
                try {
                    currentNodeName = "AdHoc";
                    if (!"I".equals(workflowDoc.getStatus().getCode()) && this.getCurrentRouteNodeName(workflowDoc) != null) {
                        currentNodeName = this.getCurrentRouteNodeName(workflowDoc);
                    }
                    workflowDoc.adHocToPrincipal(ActionRequestType.FYI, currentNodeName, "Unable to save the contract manager for the following Requisitions: " + failedReqs, workflowDoc.getInitiatorPrincipalId(), "Initiator", true);
                }
                catch (WorkflowException workflowException) {
                    // empty catch block
                }
            }
        }
        LOG.debug((Object)"doRouteStatusChange() Leaving method.");
    }

    protected String getCurrentRouteNodeName(WorkflowDocument wd) throws WorkflowException {
        Set nodeNames = wd.getCurrentNodeNames();
        if (nodeNames == null || nodeNames.isEmpty()) {
            return null;
        }
        return (String)nodeNames.iterator().next();
    }

    public String getDocumentTitle() {
        String title = "";
        title = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(ContractManagerAssignmentDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND") != false ? "Contract Manager Assignment" : super.getDocumentTitle();
        return title;
    }

    public List getContractManagerAssignmentDetails() {
        return this.contractManagerAssignmentDetails;
    }

    public void setContractManagerAssignmentDetailss(List contractManagerAssignmentDetails) {
        this.contractManagerAssignmentDetails = contractManagerAssignmentDetails;
    }

    public String getFirstObjectCode() {
        return this.firstObjectCode;
    }

    public String getDeliveryCampusCode() {
        return this.deliveryCampusCode;
    }

    public String getFirstItemDescription() {
        return this.firstItemDescription;
    }

    public String getFirstItemCommodityCode() {
        return this.firstItemCommodityCode;
    }

    public String getGeneralDescription() {
        return this.generalDescription;
    }

    public String getRequisitionCreateDate() {
        return this.requisitionCreateDate;
    }

    public String getRequisitionNumber() {
        return this.requisitionNumber;
    }

    public String getRequisitionTotalAmount() {
        return this.requisitionTotalAmount;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }
}

