/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.krad.bo.BusinessObject;

public class VendorCreditMemoInitTabRequiredFieldsValidation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;
    private PaymentRequestService paymentRequestService;

    public boolean validate(AttributedDocumentEvent event) {
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)event.getDocument();
        boolean valid = true;
        valid = this.validateRequiredField((BusinessObject)cmDocument, "creditMemoNumber");
        valid = valid && this.validateRequiredField((BusinessObject)cmDocument, "creditMemoAmount");
        boolean creditMemoDateExist = this.validateRequiredField((BusinessObject)cmDocument, "creditMemoDate");
        if (creditMemoDateExist && this.paymentRequestService.isInvoiceDateAfterToday(cmDocument.getCreditMemoDate())) {
            String label = this.dataDictionaryService.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoDate");
            GlobalVariables.getMessageMap().putError("creditMemoDate", "errors.invalid.invoice.date", new String[]{label});
            valid = false;
        }
        return valid;
    }

    protected boolean validateRequiredField(BusinessObject businessObject, String fieldName) {
        boolean valid = true;
        Object fieldValue = ObjectUtils.getPropertyValue((Object)businessObject, (String)fieldName);
        if (fieldValue == null || fieldValue instanceof String && StringUtils.isBlank((String)fieldName)) {
            String label = this.dataDictionaryService.getAttributeErrorLabel(businessObject.getClass(), fieldName);
            GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{label});
            valid = false;
        }
        return valid;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public PaymentRequestService getPaymentRequestService() {
        return this.paymentRequestService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }
}

