/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import java.util.Map;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItemMapping;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceOrderHolder;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ElectronicInvoiceItemHolder {
    private ElectronicInvoiceOrderHolder orderHolder;
    private ElectronicInvoiceRejectItem rejectItem;
    private ElectronicInvoiceItem invoiceItem;
    private PurchaseOrderItem poItem;
    private Map<String, ElectronicInvoiceItemMapping> itemTypeMappings;
    private boolean isRejectItemHolder;
    private boolean validateHeader;

    public ElectronicInvoiceItemHolder(ElectronicInvoiceRejectItem rejectItem, Map itemTypeMappings, PurchaseOrderItem poItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (rejectItem == null) {
            throw new NullPointerException("ElectronicInvoiceRejectItem should not be null");
        }
        this.rejectItem = rejectItem;
        this.poItem = poItem;
        this.orderHolder = orderHolder;
        this.isRejectItemHolder = true;
    }

    public ElectronicInvoiceItemHolder(ElectronicInvoiceItem invoiceItem, Map itemTypeMappings, PurchaseOrderItem poItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (invoiceItem == null) {
            throw new NullPointerException("ElectronicInvoiceItem should not be null");
        }
        this.invoiceItem = invoiceItem;
        this.poItem = poItem;
        this.orderHolder = orderHolder;
        this.isRejectItemHolder = false;
    }

    public Integer getInvoiceItemLineNumber() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceReferenceItemLineNumber();
        }
        return this.invoiceItem.getReferenceLineNumberInteger();
    }

    public String getInvoiceItemDescription() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceReferenceItemDescription();
        }
        return this.invoiceItem.getReferenceDescription();
    }

    public PurchaseOrderItem getPurchaseOrderItem() {
        return this.poItem;
    }

    public String getCatalogNumberStripped() {
        if (this.isRejectItemHolder()) {
            return ElectronicInvoiceUtils.stripSplChars(this.rejectItem.getInvoiceItemCatalogNumber());
        }
        return ElectronicInvoiceUtils.stripSplChars(this.invoiceItem.getCatalogNumber());
    }

    public BigDecimal getUnitPrice() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemUnitPrice();
        }
        return this.invoiceItem.getInvoiceLineUnitCostBigDecimal();
    }

    public String getUnitPriceCurrency() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemUnitPriceCurrencyCode();
        }
        return this.invoiceItem.getUnitPriceCurrency();
    }

    public BigDecimal getQuantity() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemQuantity();
        }
        return this.invoiceItem.getInvoiceLineQuantityBigDecimal();
    }

    public KualiDecimal getSubTotalAmount() {
        if (this.isRejectItemHolder()) {
            return new KualiDecimal(this.rejectItem.getInvoiceItemSubTotalAmount().setScale(2, 4));
        }
        return new KualiDecimal(this.invoiceItem.getInvoiceLineSubTotalAmountBigDecimal());
    }

    public boolean isRejectItemHolder() {
        return this.isRejectItemHolder;
    }

    public ElectronicInvoiceItemMapping getItemMapping(String invoiceItemTypeCode) {
        if (this.itemTypeMappings == null) {
            return null;
        }
        return this.itemTypeMappings.get(invoiceItemTypeCode);
    }

    public String getItemTypeCode(String invoiceItemTypeCode) {
        ElectronicInvoiceItemMapping itemMapping = this.getItemMapping(invoiceItemTypeCode);
        if (itemMapping != null) {
            return itemMapping.getItemTypeCode();
        }
        return null;
    }

    public String getInvoiceItemCatalogNumber() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemCatalogNumber();
        }
        return this.invoiceItem.getReferenceItemIDSupplierPartID();
    }

    public String getInvoiceItemUnitOfMeasureCode() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemUnitOfMeasureCode();
        }
        return this.invoiceItem.getUnitOfMeasure();
    }

    public boolean isUnitOfMeasureAcceptIndicatorEnabled() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.isUnitOfMeasureAcceptIndicator();
        }
        return false;
    }

    public boolean isCatalogNumberAcceptIndicatorEnabled() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.isCatalogNumberAcceptIndicator();
        }
        return false;
    }

    public BigDecimal getInvoiceItemUnitPrice() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemUnitPrice();
        }
        return this.invoiceItem.getInvoiceLineUnitCostBigDecimal();
    }

    public BigDecimal getInvoiceItemQuantity() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemQuantity();
        }
        return this.invoiceItem.getInvoiceLineQuantityBigDecimal();
    }

    public BigDecimal getInvoiceItemSubTotalAmount() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemSubTotalAmount();
        }
        return this.invoiceItem.getInvoiceLineSubTotalAmountBigDecimal();
    }

    public BigDecimal getTaxAmount() {
        if (this.isRejectItemHolder()) {
            return this.rejectItem.getInvoiceItemTaxAmount();
        }
        return this.invoiceItem.getInvoiceLineTaxAmountBigDecimal();
    }

    public ElectronicInvoiceOrderHolder getInvoiceOrderHolder() {
        return this.orderHolder;
    }
}

