/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchaseOrderSplitValidation
extends GenericValidation {
    private PurchaseOrderService purchaseOrderService;
    private PurchaseOrderDocument accountingDocumentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PurchaseOrderDocument po = (PurchaseOrderDocument)event.getDocument();
        HashMap<String, List<PurchaseOrderItem>> categorizedItems = this.purchaseOrderService.categorizeItemsForSplit(po.getItems());
        List<PurchaseOrderItem> movingPOItems = categorizedItems.get("movingPOItems");
        List<PurchaseOrderItem> remainingPOLineItems = categorizedItems.get("remainingPOLineItems");
        if (movingPOItems.isEmpty()) {
            GlobalVariables.getMessageMap().putError("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustMove", new String[0]);
            valid &= false;
        } else if (remainingPOLineItems.isEmpty()) {
            GlobalVariables.getMessageMap().putError("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustRemain", new String[0]);
            valid &= false;
        }
        return valid;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public PurchaseOrderDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(PurchaseOrderDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }
}

