/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.kuali.kfs.module.purap.util.cxml.B2BPOResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BPunchOutOrderFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponse;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.PurchaseOrderResponse;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class B2BParserHelper {
    private static Logger log = Logger.getLogger(B2BParserHelper.class);
    private DocumentBuilder builder;
    private static B2BParserHelper _this;

    private B2BParserHelper() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        builderFactory.setIgnoringElementContentWhitespace(true);
        try {
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static B2BParserHelper getInstance() {
        if (_this == null) {
            _this = new B2BParserHelper();
        }
        return _this;
    }

    public synchronized B2BShoppingCart parseShoppingCartXML(String xmlChunk) {
        Document xmlDoc = null;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPunchOutOrder");
        B2BPunchOutOrderFileType fileType = (B2BPunchOutOrderFileType)((Object)SpringContext.getBean(B2BPunchOutOrderFileType.class));
        B2BShoppingCart cart = (B2BShoppingCart)((BatchInputFileService)SpringContext.getBean(BatchInputFileService.class)).parse((BatchInputFileType)fileType, xmlDocAsBytes);
        return cart;
    }

    public synchronized PunchOutSetupResponse parsePunchOutSetupResponse(String xmlChunk) {
        Document xmlDoc = null;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPunchOutResponse");
        PunchOutSetupResponseFileType fileType = (PunchOutSetupResponseFileType)((Object)SpringContext.getBean(PunchOutSetupResponseFileType.class));
        PunchOutSetupResponse response = (PunchOutSetupResponse)((BatchInputFileService)SpringContext.getBean(BatchInputFileService.class)).parse((BatchInputFileType)fileType, xmlDocAsBytes);
        return response;
    }

    public synchronized PurchaseOrderResponse parsePurchaseOrderResponse(String xmlChunk) {
        Document xmlDoc = null;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPOResponse");
        B2BPOResponseFileType fileType = (B2BPOResponseFileType)((Object)SpringContext.getBean(B2BPOResponseFileType.class));
        PurchaseOrderResponse response = (PurchaseOrderResponse)((BatchInputFileService)SpringContext.getBean(BatchInputFileService.class)).parse((BatchInputFileType)fileType, xmlDocAsBytes);
        return response;
    }

    private byte[] addXMLNameSpace(Document xmlDoc, String nameSpace) {
        Element node;
        Element element = node = xmlDoc.getDocumentElement();
        element.setAttribute("xmlns", nameSpace);
        OutputFormat outputFormat = new OutputFormat(xmlDoc);
        outputFormat.setOmitDocumentType(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, outputFormat);
        try {
            serializer.asDOMSerializer();
            serializer.serialize(xmlDoc.getDocumentElement());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

