/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import org.kuali.kfs.sys.businessobject.TaxRegion;
import org.kuali.kfs.sys.businessobject.TaxRegionPostalCode;
import org.kuali.kfs.sys.businessobject.TaxRegionRate;
import org.kuali.kfs.sys.businessobject.TaxRegionState;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class TaxFixture {

    public static enum TaxRegionStateFixture {
        IN("IN", "US", true);

        public String stateCode;
        public String countryCode;
        public boolean active;

        private TaxRegionStateFixture(String stateCode, String countryCode, boolean active) {
            this.stateCode = stateCode;
            this.countryCode = countryCode;
            this.active = active;
        }

        public TaxRegionState createTaxRegionState() {
            TaxRegionState taxRegionState = new TaxRegionState();
            taxRegionState.setStateCode(this.stateCode);
            taxRegionState.setPostalCountryCode(this.countryCode);
            taxRegionState.setActive(this.active);
            return taxRegionState;
        }

        public void addTo(TaxRegion taxRegion) {
            TaxRegionState taxRegionState = this.createTaxRegionState();
            taxRegionState.setTaxRegionCode(taxRegion.getTaxRegionCode());
            taxRegion.getTaxRegionStates().add(taxRegionState);
        }
    }

    public static enum TaxRegionPostalCodeFixture {
        PO_46202("46202-5260", "US", true),
        PO_46202_SHORT("46202", "US", true);

        public String postalCode;
        public String countryCode;
        public boolean active;

        private TaxRegionPostalCodeFixture(String postalCode, String countryCode, boolean active) {
            this.postalCode = postalCode;
            this.countryCode = countryCode;
            this.active = active;
        }

        public TaxRegionPostalCode createTaxRegionPostalCode() {
            TaxRegionPostalCode taxRegionPostalCode = new TaxRegionPostalCode();
            taxRegionPostalCode.setPostalCode(this.postalCode);
            taxRegionPostalCode.setPostalCountryCode(this.countryCode);
            taxRegionPostalCode.setActive(this.active);
            return taxRegionPostalCode;
        }

        public void addTo(TaxRegion taxRegion) {
            TaxRegionPostalCode taxRegionPostalCode = this.createTaxRegionPostalCode();
            taxRegionPostalCode.setTaxRegionCode(taxRegion.getTaxRegionCode());
            taxRegion.getTaxRegionPostalCodes().add(taxRegionPostalCode);
        }
    }

    public static enum TaxRegionRateFixture {
        TAX_REGION_RATE_05("01/01/2008", new BigDecimal(0.05)),
        TAX_REGION_RATE_07("01/01/2008", new BigDecimal(0.07));

        public String effectiveDate;
        public BigDecimal taxRate;

        private TaxRegionRateFixture(String effectiveDate, BigDecimal taxRate) {
            this.effectiveDate = effectiveDate;
            this.taxRate = taxRate;
        }

        public TaxRegionRate createTaxRegionRate() {
            TaxRegionRate taxRegionRate = new TaxRegionRate();
            taxRegionRate.setTaxRate(this.taxRate);
            try {
                taxRegionRate.setEffectiveDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).convertToSqlDate(this.effectiveDate));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return taxRegionRate;
        }

        public void addTo(TaxRegion taxRegion) {
            TaxRegionRate taxRegionRate = this.createTaxRegionRate();
            taxRegionRate.setTaxRegionCode(taxRegion.getTaxRegionCode());
            taxRegion.getTaxRegionRates().add(taxRegionRate);
        }
    }

    public static enum TaxRegionFixture {
        TAX_REGION_NO_USE_TAX("NOUSETAX", "NOUSETAX", "POST", "BA", "6044900", "1500", false, true),
        TAX_REGION_WITH_USE_TAX("USETAX", "USETAX", "ST", "BA", "6044900", "1500", true, true);

        public String taxRegionCode;
        public String taxRegionName;
        public String taxRegionTypeCode;
        public String chartOfAccountsCode;
        public String accountNumber;
        public String financialObjectCode;
        public boolean taxRegionUseTaxIndicator;
        public boolean active;

        private TaxRegionFixture(String taxRegionCode, String taxRegionName, String taxRegionTypeCode, String chartOfAccountsCode, String accountNumber, String financialObjectCode, boolean taxRegionUseTaxIndicator, boolean active) {
            this.taxRegionCode = taxRegionCode;
            this.taxRegionName = taxRegionName;
            this.taxRegionTypeCode = taxRegionTypeCode;
            this.chartOfAccountsCode = chartOfAccountsCode;
            this.accountNumber = accountNumber;
            this.financialObjectCode = financialObjectCode;
            this.taxRegionUseTaxIndicator = taxRegionUseTaxIndicator;
            this.active = active;
        }

        public TaxRegion createTaxRegion(TaxRegionRateFixture[] taxRegionRateFixtures, TaxRegionPostalCodeFixture[] taxRegionPostalCodeFixtures, TaxRegionStateFixture[] taxRegionStateFixtures) {
            TaxRegion taxRegion = new TaxRegion();
            taxRegion.setTaxRegionCode(this.taxRegionCode);
            taxRegion.setTaxRegionName(this.taxRegionName);
            taxRegion.setTaxRegionTypeCode(this.taxRegionTypeCode);
            taxRegion.setChartOfAccountsCode(this.chartOfAccountsCode);
            taxRegion.setAccountNumber(this.accountNumber);
            taxRegion.setFinancialObjectCode(this.financialObjectCode);
            taxRegion.setTaxRegionUseTaxIndicator(this.taxRegionUseTaxIndicator);
            taxRegion.setActive(this.active);
            if (taxRegionRateFixtures != null) {
                for (Enum enum_ : taxRegionRateFixtures) {
                    ((TaxRegionRateFixture)enum_).addTo(taxRegion);
                }
            }
            if (taxRegionPostalCodeFixtures != null) {
                for (Enum enum_ : taxRegionPostalCodeFixtures) {
                    ((TaxRegionPostalCodeFixture)enum_).addTo(taxRegion);
                }
            }
            if (taxRegionStateFixtures != null) {
                for (Enum enum_ : taxRegionStateFixtures) {
                    ((TaxRegionStateFixture)enum_).addTo(taxRegion);
                }
            }
            return taxRegion;
        }
    }

    public static enum TaxTestCaseFixture {
        SalesTaxHappyPathTest(true, true, true, true, true, true, false),
        SalesTaxItemTypeNotTaxableTest(false, true, true, true, true, true, false),
        SalesTaxItemTaxFieldNullTest(true, false, true, true, true, true, false),
        SalesTaxCommodityCodeNullTest(true, true, false, true, true, true, false),
        SalesTaxDeliveryStateExemptTest(true, true, true, true, true, false, false),
        SalesTaxDeliveryStateExemptWithNonTaxableFundTest(true, true, true, false, true, false, false),
        SalesTaxAccountNotTaxableTest(true, true, true, false, true, true, false),
        SalesTaxObjectCodeNotTaxableTest(true, true, true, true, false, true, false),
        SalesTaxParamDisabledTest(true, true, true, true, true, true, false, false),
        UseTaxHappyPathTest(true, true, true, true, true, true, true),
        UseTaxItemTypeNotTaxableTest(false, true, true, true, true, true, true);

        private boolean isSalesTaxEnabled;
        private final boolean isItemTypeTaxable;
        private final boolean isItemTaxAmountNull;
        private final boolean iscommodityCodeNull;
        private final boolean fundGroupCodeTaxable;
        private final boolean objectCodeTaxable;
        private final boolean isDeliveryStateTaxable;
        private final boolean isUseTax;

        private TaxTestCaseFixture(boolean isItemTypeTaxable, boolean isItemTaxAmountNull, boolean iscommodityCodeNull, boolean fundGroupCodeTaxable, boolean objectCodeTaxable, boolean isDeliveryStateTaxable, boolean isUseTax) {
            this.isItemTypeTaxable = isItemTypeTaxable;
            this.isItemTaxAmountNull = isItemTaxAmountNull;
            this.iscommodityCodeNull = iscommodityCodeNull;
            this.fundGroupCodeTaxable = fundGroupCodeTaxable;
            this.objectCodeTaxable = objectCodeTaxable;
            this.isDeliveryStateTaxable = isDeliveryStateTaxable;
            this.isUseTax = isUseTax;
            this.isSalesTaxEnabled = true;
        }

        private TaxTestCaseFixture(boolean isItemTypeTaxable, boolean isItemTaxAmountNull, boolean iscommodityCodeNull, boolean fundGroupCodeTaxable, boolean objectCodeTaxable, boolean isDeliveryStateTaxable, boolean isUseTax, boolean isSalesTaxEnabled) {
            this.isItemTypeTaxable = isItemTypeTaxable;
            this.isItemTaxAmountNull = isItemTaxAmountNull;
            this.iscommodityCodeNull = iscommodityCodeNull;
            this.fundGroupCodeTaxable = fundGroupCodeTaxable;
            this.objectCodeTaxable = objectCodeTaxable;
            this.isDeliveryStateTaxable = isDeliveryStateTaxable;
            this.isUseTax = isUseTax;
            this.isSalesTaxEnabled = isSalesTaxEnabled;
        }

        public boolean isConsolidationObjectCode() {
            return this.objectCodeTaxable;
        }

        public boolean isFundGroupCodeTaxable() {
            return this.fundGroupCodeTaxable;
        }

        public boolean iscommodityCodeNull() {
            return this.iscommodityCodeNull;
        }

        public boolean isItemTypeTaxable() {
            return this.isItemTypeTaxable;
        }

        public boolean isUseTax() {
            return this.isUseTax;
        }

        public boolean isItemTaxAmountNull() {
            return this.isItemTaxAmountNull;
        }

        public boolean isObjectCodeTaxable() {
            return this.objectCodeTaxable;
        }

        public boolean isDeliveryStateTaxable() {
            return this.isDeliveryStateTaxable;
        }

        public boolean isSalesTaxEnabled() {
            return this.isSalesTaxEnabled;
        }
    }
}

