/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentRequestPurchaseOrderIdValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PaymentRequestDocument document = (PaymentRequestDocument)event.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        Integer POID = document.getPurchaseOrderIdentifier();
        PurchaseOrderDocument purchaseOrderDocument = document.getPurchaseOrderDocument();
        if (ObjectUtils.isNull((Object)purchaseOrderDocument)) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.notExist", new String[0]);
            valid &= false;
        } else if (purchaseOrderDocument.isPendingActionIndicator()) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.pending.action", new String[0]);
            valid &= false;
        } else if (!StringUtils.equals((String)purchaseOrderDocument.getApplicationDocumentStatus(), (String)"Open")) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.notOpen", new String[0]);
            valid &= false;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    protected boolean encumberedItemExistsForInvoicing(PurchaseOrderDocument document) {
        boolean zeroDollar = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (PurchaseOrderItem poi : document.getItems()) {
            KualiDecimal encumberedAmount;
            if (poi.getItemType().isLineItemIndicator() && poi.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                KualiDecimal encumberedQuantity = poi.getItemOutstandingEncumberedQuantity() == null ? KualiDecimal.ZERO : poi.getItemOutstandingEncumberedQuantity();
                if (encumberedQuantity.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 1) continue;
                zeroDollar = false;
                break;
            }
            if (!poi.getItemType().isAmountBasedGeneralLedgerIndicator() && !poi.getItemType().isAdditionalChargeIndicator() || (encumberedAmount = poi.getItemOutstandingEncumberedAmount() == null ? KualiDecimal.ZERO : poi.getItemOutstandingEncumberedAmount()).compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 1) continue;
            zeroDollar = false;
            break;
        }
        if (zeroDollar) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.invoice.items.noneLeft", new String[0]);
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return !zeroDollar;
    }
}

