/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.fixture.PurApAccountingLineFixture;
import org.kuali.kfs.sys.fixture.AccountingLineFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum RequisitionAccountingLineFixture {
    BASIC_REQ_ACCOUNT_1(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.PURAP_LINE3),
    BASIC_REQ_ACCOUNT_2(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.PURAP_LINE1),
    PERFORMANCE_ACCOUNT(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.PURAP_PERFORMANCE_LINE),
    APO_REQ_ACCOUNT_1(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.APO_LINE1),
    APO_REQ_ACCOUNT_2(PurApAccountingLineFixture.ACCOUNT_50_PERCENT, AccountingLineFixture.APO_LINE2),
    APO_REQ_ACCOUNT_3(PurApAccountingLineFixture.ACCOUNT_50_PERCENT, AccountingLineFixture.APO_LINE3),
    APO_REQ_ACCOUNT_4(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.APO_LINE4),
    REQ_ACCOUNT_NEGATIVE_AMOUNT(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.PURAP_LINE_NEGATIVE_AMT),
    REQ_ACCOUNT_MULTI_QUANTITY(PurApAccountingLineFixture.REQ_ACCOUNT_MULTI, AccountingLineFixture.REQ_ACCOUNT_MULTI_QUANTITY),
    REQ_ACCOUNT_MULTI_NON_QUANTITY(PurApAccountingLineFixture.REQ_ACCOUNT_MULTI, AccountingLineFixture.REQ_ACCOUNT_MULTI_NON_QUANTITY),
    APO_ACCOUNT_VALID_CAPITAL_ASSET_OBJECT_CODE(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.APO_LINE2, "7001"),
    APO_ACCOUNT_VALID_CAPITAL_ASSET_OBJECT_CODE_50_PERCENT(PurApAccountingLineFixture.ACCOUNT_50_PERCENT, AccountingLineFixture.APO_LINE4, "7001"),
    APO_ACCOUNT_VALID_EXPENSE_OBJECT_CODE_50_PERCENT(PurApAccountingLineFixture.ACCOUNT_50_PERCENT, AccountingLineFixture.APO_LINE4, "5000");

    private PurApAccountingLineFixture purApAccountingLineFixture;
    private AccountingLineFixture accountingLineFixture;
    private String objectCode;

    private RequisitionAccountingLineFixture(PurApAccountingLineFixture purApAccountingLineFixture, AccountingLineFixture accountingLineFixture) {
        this.purApAccountingLineFixture = purApAccountingLineFixture;
        this.accountingLineFixture = accountingLineFixture;
    }

    private RequisitionAccountingLineFixture(PurApAccountingLineFixture purApAccountingLineFixture, AccountingLineFixture accountingLineFixture, String objectCode) {
        this.purApAccountingLineFixture = purApAccountingLineFixture;
        this.accountingLineFixture = accountingLineFixture;
        this.objectCode = objectCode;
    }

    public PurApAccountingLine createPurApAccountingLine(Class clazz, PurApAccountingLineFixture puralFixture, AccountingLineFixture alFixture) {
        PurApAccountingLine line = null;
        line = puralFixture.createPurApAccountingLine(RequisitionAccount.class, alFixture);
        if (StringUtils.isNotBlank((String)this.objectCode)) {
            line.setFinancialObjectCode(this.objectCode);
            line.refreshReferenceObject("objectCode");
        }
        return line;
    }

    public void addTo(RequisitionItem item) {
        PurApAccountingLine purApAccountingLine = this.createPurApAccountingLine(item.getAccountingLineClass(), this.purApAccountingLineFixture, this.accountingLineFixture);
        purApAccountingLine.setPurapItem((PurApItem)item);
        purApAccountingLine.setAmount((KualiDecimal)((KualiDecimal)item.calculateExtendedPrice().multiply((AbstractKualiDecimal)new KualiDecimal(purApAccountingLine.getAccountLinePercent()))).divide((AbstractKualiDecimal)new KualiDecimal(100)));
        item.getSourceAccountingLines().add(purApAccountingLine);
    }

    public void addTo(PurApItem item, PurApAccountingLineFixture purApaccountFixture, AccountingLineFixture alFixture) throws IllegalAccessException, InstantiationException {
    }
}

