/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCapitalAssetItemsFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurchasingServiceTest
extends KualiTestBase {
    public void testSetupCapitalAssetSystem() {
        RequisitionDocument requisition = RequisitionDocumentWithCapitalAssetItemsFixture.REQ_VALID_ONE_NEW_CAPITAL_ASSET_ITEM.createRequisitionDocument();
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetSystem((PurchasingDocument)requisition);
        PurchasingServiceTest.assertTrue((requisition.getPurchasingCapitalAssetSystems().size() == 1 ? 1 : 0) != 0);
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public final void testDefaultUseTaxIndicatorValue() {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_TAX.createRequisitionDocument();
        requisitionDocument.refreshReferenceObject("vendorDetail");
        requisitionDocument.getVendorDetail().setDefaultAddressStateCode(requisitionDocument.getVendorStateCode());
        boolean defaultUseTaxIndicatorValue = ((PurchasingService)SpringContext.getBean(PurchasingService.class)).getDefaultUseTaxIndicatorValue((PurchasingDocument)requisitionDocument);
        PurchasingServiceTest.assertFalse((boolean)defaultUseTaxIndicatorValue);
    }
}

