/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;

public class PurApItemUtils {
    public static boolean checkItemActive(PurApItem item) {
        boolean active = true;
        if (item instanceof PurchaseOrderItem) {
            PurchaseOrderItem poi = (PurchaseOrderItem)item;
            active = poi.isItemActiveIndicator();
        }
        return active;
    }

    public static boolean isNonZeroExtended(PurApItem item) {
        return ObjectUtils.isNotNull((Object)item) && ObjectUtils.isNotNull((Object)item.getExtendedPrice()) && !item.getExtendedPrice().isZero();
    }

    public static List<PurApItem> getAboveTheLineOnly(List<PurApItem> items) {
        ArrayList<PurApItem> returnItems = new ArrayList<PurApItem>();
        for (PurApItem item : items) {
            if (!ObjectUtils.isNotNull((Object)((Object)item.getItemType())) || !item.getItemType().isLineItemIndicator()) continue;
            returnItems.add((PurApItem)((Object)ObjectUtils.deepCopy((Serializable)((Object)item))));
        }
        return returnItems;
    }

    public static int countBelowTheLineItems(List<PurApItem> items) {
        PurApItem item;
        int count = 0;
        for (int i = items.size() - 1; !(i <= 0 || ObjectUtils.isNotNull((Object)((Object)(item = items.get(i)).getItemType())) && item.getItemType().isLineItemIndicator()); --i) {
            ++count;
        }
        return count;
    }
}

