/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurchaseOrderAccount
extends PurApAccountingLineBase {
    private KualiDecimal itemAccountOutstandingEncumbranceAmount;

    public PurchaseOrderAccount() {
    }

    public PurchaseOrderAccount(PurApAccountingLine ra) {
        this.setAccountLinePercent(ra.getAccountLinePercent());
        this.setAccountNumber(ra.getAccountNumber());
        this.setChartOfAccountsCode(ra.getChartOfAccountsCode());
        this.setFinancialObjectCode(ra.getFinancialObjectCode());
        this.setFinancialSubObjectCode(ra.getFinancialSubObjectCode());
        this.setOrganizationReferenceId(ra.getOrganizationReferenceId());
        this.setProjectCode(ra.getProjectCode());
        this.setSubAccountNumber(ra.getSubAccountNumber());
        this.setSequenceNumber(ra.getSequenceNumber());
        this.setAmount(ra.getAmount());
        this.setAccountLinePercent(ra.getAccountLinePercent());
    }

    @Override
    public KualiDecimal getAlternateAmountForGLEntryCreation() {
        if (ObjectUtils.isNull((Object)super.getAlternateAmountForGLEntryCreation())) {
            return this.getItemAccountOutstandingEncumbranceAmount();
        }
        return super.getAlternateAmountForGLEntryCreation();
    }

    public KualiDecimal getItemAccountOutstandingEncumbranceAmount() {
        return this.itemAccountOutstandingEncumbranceAmount;
    }

    public void setItemAccountOutstandingEncumbranceAmount(KualiDecimal itemAccountOutstandingEncumbranceAmount) {
        this.itemAccountOutstandingEncumbranceAmount = itemAccountOutstandingEncumbranceAmount;
    }

    public PurchaseOrderItem getPurchaseOrderItem() {
        return (PurchaseOrderItem)super.getPurapItem();
    }

    @Deprecated
    public void setPurchaseOrderItem(PurchaseOrderItem purchaseOrderItem) {
        super.setPurapItem(purchaseOrderItem);
    }

    @Override
    public void copyFrom(AccountingLine other) {
        super.copyFrom(other);
        if (other instanceof PurchaseOrderAccount) {
            PurchaseOrderAccount poOther = (PurchaseOrderAccount)other;
            this.setItemAccountOutstandingEncumbranceAmount(poOther.getItemAccountOutstandingEncumbranceAmount());
        }
    }

    public boolean isAmountLike(PurchaseOrderAccount poAccount) {
        if (poAccount == null) {
            return false;
        }
        if (this.amount == null && poAccount.getAmount() == null) {
            return true;
        }
        if (this.amount == null && poAccount.getAmount() != null) {
            return false;
        }
        if (this.amount != null && poAccount.getAmount() == null) {
            return false;
        }
        return this.amount.compareTo((AbstractKualiDecimal)poAccount.getAmount()) == 0;
    }
}

