/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.LogicContainer;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedPreCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.web.struts.AccountsPayableFormBase;
import org.kuali.kfs.module.purap.document.web.struts.PaymentRequestForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableFormBase;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.PurQuestionCallback;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class AccountsPayableActionBase
extends PurchasingAccountsPayableActionBase {
    protected static Logger LOG = Logger.getLogger(AccountsPayableActionBase.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase baseForm = (PurchasingAccountsPayableFormBase)form;
        ActionForward fwd = super.execute(mapping, form, request, response);
        AccountsPayableDocumentBase document = (AccountsPayableDocumentBase)baseForm.getDocument();
        boolean foundAccountExpiredWarning = false;
        for (int i = 0; i < KNSGlobalVariables.getMessageList().size(); ++i) {
            if (!StringUtils.equals((String)((ErrorMessage)KNSGlobalVariables.getMessageList().get(i)).getErrorKey(), (String)"message.closed.or.expired.accounts.replaced")) continue;
            foundAccountExpiredWarning = true;
        }
        if (!foundAccountExpiredWarning) {
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).generateExpiredOrClosedAccountWarning(document);
        }
        return fwd;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase baseForm = (PurchasingAccountsPayableFormBase)form;
        AccountsPayableDocumentBase document = (AccountsPayableDocumentBase)baseForm.getDocument();
        if (StringUtils.equals((String)baseForm.getRefreshCaller(), (String)"vendorAddressLookupable") && StringUtils.isNotBlank((String)request.getParameter("document.vendorAddressGeneratedIdentifier"))) {
            Integer vendorAddressGeneratedId = document.getVendorAddressGeneratedIdentifier();
            VendorAddress refreshVendorAddress = new VendorAddress();
            refreshVendorAddress.setVendorAddressGeneratedIdentifier(vendorAddressGeneratedId);
            refreshVendorAddress = (VendorAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)refreshVendorAddress);
            document.templateVendorAddress(refreshVendorAddress);
        }
        return super.refresh(mapping, form, request, response);
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        AccountsPayableDocument document = (AccountsPayableDocument)kualiDocumentFormBase.getDocument();
        ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).generateExpiredOrClosedAccountWarning(document);
        ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).updateItemList(document);
        ((AccountsPayableFormBase)kualiDocumentFormBase).updateItemCounts();
    }

    @Override
    public ActionForward calculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsPayableFormBase apForm = (AccountsPayableFormBase)form;
        AccountsPayableDocument apDoc = (AccountsPayableDocument)apForm.getDocument();
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(apDoc);
        if (((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedPreCalculateAccountsPayableEvent((Document)apDoc))) {
            this.customCalculate(apDoc);
            if (apForm instanceof PaymentRequestForm && apDoc.getApplicationDocumentStatus().equals("Awaiting Tax Approval")) {
                PaymentRequestForm preqForm = (PaymentRequestForm)apForm;
                preqForm.setCalculatedTax(true);
            } else {
                apForm.setCalculated(true);
            }
        }
        return super.calculate(mapping, form, request, response);
    }

    @Override
    public ActionForward clearAllTaxes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsPayableFormBase payableForm = (AccountsPayableFormBase)form;
        AccountsPayableDocument apDoc = (AccountsPayableDocument)payableForm.getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).clearAllTaxes(apDoc);
        return super.clearAllTaxes(mapping, form, request, response);
    }

    protected boolean requiresCaculate(AccountsPayableFormBase apForm) {
        boolean requiresCalculate = true;
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)apForm.getDocument();
        requiresCalculate = !apForm.isCalculated() && !((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(purapDocument);
        return requiresCalculate;
    }

    public String getActionName() {
        return null;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsPayableFormBase apForm = (AccountsPayableFormBase)form;
        AccountsPayableDocumentBase document = (AccountsPayableDocumentBase)apForm.getDocument();
        document.setLastActionPerformedByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (this.requiresCaculate(apForm)) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "errors.save.calculationRequired", new String[0]);
            return mapping.findForward("basic");
        }
        this.customCalculate((AccountsPayableDocument)apForm.getDocument());
        ActionForward forward = super.route(mapping, form, request, response);
        boolean successMessageFound = false;
        MessageList messageList = KNSGlobalVariables.getMessageList();
        for (int i = 0; i < messageList.size(); ++i) {
            if (!StringUtils.equals((String)((ErrorMessage)messageList.get(i)).getErrorKey(), (String)"message.route.successful")) continue;
            successMessageFound = true;
            break;
        }
        if (successMessageFound) {
            String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
            Properties parameters = new Properties();
            parameters.put("methodToCall", "docHandler");
            parameters.put("command", "initiate");
            parameters.put("docTypeName", apForm.getDocTypeName());
            String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "purap" + this.getActionName() + ".do"), (Properties)parameters);
            forward = new ActionForward(lookupUrl, true);
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsPayableFormBase apForm = (AccountsPayableFormBase)form;
        if (!this.requiresCaculate(apForm)) {
            return super.save(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "errors.save.calculationRequired", new String[0]);
        return mapping.findForward("basic");
    }

    protected ActionForward askQuestionWithInput(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType, String notePrefix, String operation, String messageKey, PurQuestionCallback callback) throws Exception {
        TreeMap<String, PurQuestionCallback> questionsAndCallbacks = new TreeMap<String, PurQuestionCallback>();
        questionsAndCallbacks.put(questionType, callback);
        return this.askQuestionWithInput(mapping, form, request, response, questionType, notePrefix, operation, messageKey, questionsAndCallbacks, "", mapping.findForward("basic"));
    }

    protected ActionForward askQuestionWithInput(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType, String notePrefix, String operation, String messageKey, TreeMap<String, PurQuestionCallback> questionsAndCallbacks, String messagePrefix, ActionForward redirect) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        AccountsPayableDocumentBase apDocument = (AccountsPayableDocumentBase)kualiDocumentFormBase.getDocument();
        String question = request.getParameter("questionIndex");
        String reason = request.getParameter("reason");
        String noteText = "";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String firstQuestion = questionsAndCallbacks.firstKey();
        PurQuestionCallback callback = null;
        Iterator<String> questions = questionsAndCallbacks.keySet().iterator();
        String mapQuestion = null;
        String key = null;
        if (question == null) {
            key = this.getQuestionProperty(messageKey, messagePrefix, kualiConfiguration, firstQuestion);
            String message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
            return this.performQuestionWithInput(mapping, form, request, response, firstQuestion, message, "cf.confirmationQuestion", questionType, "");
        }
        while (questions.hasNext()) {
            mapQuestion = questions.next();
            if (!StringUtils.equals((String)mapQuestion, (String)question)) continue;
            callback = questionsAndCallbacks.get(mapQuestion);
            break;
        }
        key = this.getQuestionProperty(messageKey, messagePrefix, kualiConfiguration, mapQuestion);
        String buttonClicked = request.getParameter("buttonClicked");
        if (question.equals(mapQuestion) && buttonClicked.equals("1")) {
            String nextQuestion = null;
            if (questions.hasNext()) {
                nextQuestion = questions.next();
                key = this.getQuestionProperty(messageKey, messagePrefix, kualiConfiguration, nextQuestion);
                return this.performQuestionWithInput(mapping, form, request, response, nextQuestion, key, "cf.confirmationQuestion", questionType, "");
            }
            return mapping.findForward("basic");
        }
        String introNoteMessage = notePrefix + " ";
        noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (reason == null) {
                reason = "";
            }
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, mapQuestion, key, "cf.confirmationQuestion", questionType, "", reason, "error.paymentRequest.reasonRequired", "reason", new Integer(reasonLimit).toString());
        }
        if (ObjectUtils.isNotNull((Object)callback)) {
            AccountsPayableDocument refreshedApDocument = callback.doPostQuestion(apDocument, noteText);
            kualiDocumentFormBase.setDocument((Document)refreshedApDocument);
        }
        String nextQuestion = null;
        if (questions.hasNext()) {
            nextQuestion = questions.next();
            key = this.getQuestionProperty(messageKey, messagePrefix, kualiConfiguration, nextQuestion);
            return this.performQuestionWithInput(mapping, form, request, response, nextQuestion, key, "cf.confirmationQuestion", questionType, "");
        }
        return redirect;
    }

    protected String getQuestionProperty(String messageKey, String messagePrefix, ConfigurationService kualiConfiguration, String question) {
        return kualiConfiguration.getPropertyValueAsString(StringUtils.isEmpty((String)messagePrefix) ? messageKey : messagePrefix + question);
    }

    public ActionForward reopenPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Reopen PO started");
        return this.askQuestionsAndPerformReopenPurchaseOrder(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.askCancelQuestion(mapping, form, request, response);
    }

    protected ActionForward askCancelQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase apForm = (PurchasingAccountsPayableFormBase)form;
        String operation = "Cancel ";
        PurQuestionCallback callback = this.cancelCallbackMethod();
        TreeMap<String, PurQuestionCallback> questionsAndCallbacks = new TreeMap<String, PurQuestionCallback>();
        questionsAndCallbacks.put("cancelAP", callback);
        return this.askQuestionWithInput(mapping, form, request, response, "CancelCM", "Note entered while canceling document: ", operation, "creditMemo.question.cancel.text", questionsAndCallbacks, "ap.question.", mapping.findForward("portal"));
    }

    protected PurQuestionCallback cancelPOActionCallbackMethod() {
        return new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                return document;
            }
        };
    }

    protected PurQuestionCallback cancelCallbackMethod() {
        return new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).cancelAccountsPayableDocumentByCheckingDocumentStatus(document, noteText);
                return document;
            }
        };
    }

    protected ActionForward askQuestionsAndPerformReopenPurchaseOrder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"askQuestionsAndPerformDocumentAction started.");
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        AccountsPayableDocumentBase apDoc = (AccountsPayableDocumentBase)kualiDocumentFormBase.getDocument();
        String question = request.getParameter("questionIndex");
        String questionType = "ReopenPO";
        String confirmType = "ConfirmReopen";
        String messageType = "purchaseOrder.route.message.reopen.text";
        String operation = "Reopen ";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        if (ObjectUtils.isNull((Object)question)) {
            String key = kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.text");
            String message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
            return this.performQuestionWithoutInput(mapping, form, request, response, questionType, message, "cf.confirmationQuestion", questionType, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (question.equals(questionType) && buttonClicked.equals("1")) {
            return mapping.findForward("basic");
        }
        if (question.equals(confirmType) && buttonClicked.equals("0")) {
            return mapping.findForward("basic");
        }
        PurchaseOrderDocument po = apDoc.getPurchaseOrderDocument();
        if (!po.isPendingActionIndicator() && "Closed".equals(po.getApplicationDocumentStatus())) {
            po = this.initiateReopenPurchaseOrder(po, kualiDocumentFormBase.getAnnotation());
            if (!GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new ValidationException("errors occurred during new PO creation");
            }
            if (StringUtils.isNotEmpty((String)messageType)) {
                KNSGlobalVariables.getMessageList().add(messageType, new String[0]);
            }
            return this.performQuestionWithoutInput(mapping, form, request, response, confirmType, kualiConfiguration.getPropertyValueAsString(messageType), "singleConfirmationQuestion", questionType, "");
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, confirmType, "Unable to reopen the PO at this time due to the incorrect PO status or a pending PO change document.", "singleConfirmationQuestion", questionType, "");
    }

    public PurchaseOrderDocument initiateReopenPurchaseOrder(PurchaseOrderDocument po, String annotation) {
        try {
            LogicContainer logicToRun = new LogicContainer(){

                @Override
                public Object runLogic(Object[] objects) throws Exception {
                    PurchaseOrderDocument po = (PurchaseOrderDocument)objects[0];
                    NoteService noteService = (NoteService)SpringContext.getBean(NoteService.class);
                    Note cancelNote = new Note();
                    cancelNote.setNoteTypeCode(po.getNoteType().getCode());
                    cancelNote.setNoteText(((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("ap.reopens.purchase.order.note"));
                    cancelNote.setNotePostedTimestampToCurrent();
                    Note poCancelNote = noteService.createNote(cancelNote, po.getNoteTarget(), GlobalVariables.getUserSession().getPerson().getPrincipalId());
                    po.addNote(poCancelNote);
                    noteService.save(poCancelNote);
                    return ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndRoutePotentialChangeDocument(po.getDocumentNumber(), "POR", (String)objects[1], null, "Pending Reopen");
                }
            };
            return (PurchaseOrderDocument)((PurapService)SpringContext.getBean(PurapService.class)).performLogicWithFakedUserSession("kfs", logicToRun, po, annotation);
        }
        catch (WorkflowException e) {
            String errorMsg = "Workflow Exception caught: " + e.getLocalizedMessage();
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ActionForward recalculateItemAccountsAmounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDecimal itemExtendedPrice;
        AccountsPayableFormBase payableForm = (AccountsPayableFormBase)form;
        AccountsPayableDocument apDoc = (AccountsPayableDocument)payableForm.getDocument();
        PurapAccountingService purapAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        String[] indexes = this.getSelectedItemNumber(request);
        int itemIndex = Integer.parseInt(indexes[0]);
        PurApItem item = apDoc.getItem(itemIndex);
        this.restoreItemAccountsAmounts(apDoc, item);
        item.refreshReferenceObject("itemType");
        KualiDecimal kualiDecimal = itemExtendedPrice = item.getExtendedPrice() == null ? KualiDecimal.ZERO : item.getExtendedPrice();
        if (item.getItemType().isQuantityBasedGeneralLedgerIndicator() && item.getExtendedPrice() == null) {
            KualiDecimal newExtendedPrice = item.calculateExtendedPrice();
            item.setExtendedPrice(newExtendedPrice);
        }
        PaymentRequestDocument preqDoc = (PaymentRequestDocument)apDoc;
        preqDoc.updateExtendedPriceOnItems();
        if (preqDoc.getApplicationDocumentStatus().equals("Awaiting Tax Approval")) {
            ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculateTaxArea(preqDoc);
        }
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePaymentRequest(preqDoc, true);
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedCalculateAccountsPayableEvent((Document)preqDoc));
        PurchasingAccountsPayableDocumentBase document = (PurchasingAccountsPayableDocumentBase)((Object)apDoc);
        String accountDistributionMethod = document.getAccountDistributionMethod();
        if ("S".equalsIgnoreCase(accountDistributionMethod)) {
            purapAccountingService.updatePreqItemAccountAmounts(item);
        } else {
            List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine acctLine : sourceAccountingLines) {
                acctLine.setAmount(KualiDecimal.ZERO);
            }
            purapAccountingService.updatePreqProportionalItemAccountAmounts(item);
        }
        return mapping.findForward("basic");
    }

    public ActionForward restoreItemAccountsAmounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDecimal itemExtendedPrice;
        AccountsPayableFormBase payableForm = (AccountsPayableFormBase)form;
        AccountsPayableDocument apDoc = (AccountsPayableDocument)payableForm.getDocument();
        String[] indexes = this.getSelectedItemNumber(request);
        int itemIndex = Integer.parseInt(indexes[0]);
        PurApItem item = apDoc.getItem(itemIndex);
        this.restoreItemAccountsAmounts(apDoc, item);
        item.setItemQuantity(null);
        item.setItemTaxAmount(null);
        item.refreshReferenceObject("itemType");
        KualiDecimal kualiDecimal = itemExtendedPrice = item.getExtendedPrice() == null ? KualiDecimal.ZERO : item.getExtendedPrice();
        if (item.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
            KualiDecimal newExtendedPrice = item.calculateExtendedPrice();
            item.setExtendedPrice(newExtendedPrice);
        }
        return mapping.findForward("basic");
    }

    protected String[] getSelectedItemNumber(HttpServletRequest request) {
        String itemString = new String();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            itemString = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
        }
        String[] result = StringUtils.split((String)itemString, (String)":");
        return result;
    }

    protected void restoreItemAccountsAmounts(AccountsPayableDocument apDoc, PurApItem preqItem) {
        List pOItems = apDoc.getPurchaseOrderDocument().getItems();
        PurApItem pOItem = this.getPOItem(pOItems, preqItem.getItemLineNumber());
        if (ObjectUtils.isNotNull((Object)pOItem)) {
            List<PurApAccountingLine> preqAccountingLines = preqItem.getSourceAccountingLines();
            for (PurApAccountingLine lineAcct : preqAccountingLines) {
                this.updateItemAccountLine(pOItem, lineAcct);
            }
        }
    }

    protected PurApItem getPOItem(List<PurApItem> pOItems, Integer itemLineNumber) {
        PurApItem pOItem = null;
        for (PurApItem poItem : pOItems) {
            if (poItem.getItemLineNumber().compareTo(itemLineNumber) != 0) continue;
            return poItem;
        }
        return pOItem;
    }

    protected void updateItemAccountLine(PurApItem pOItem, PurApAccountingLine lineAcct) {
        List<PurApAccountingLine> pOAccountingLines = pOItem.getSourceAccountingLines();
        for (PurApAccountingLine pOLineAcct : pOAccountingLines) {
            if (!lineAcct.getChartOfAccountsCode().equalsIgnoreCase(pOLineAcct.getChartOfAccountsCode()) || !lineAcct.getAccountNumber().equalsIgnoreCase(pOLineAcct.getAccountNumber()) || !lineAcct.getFinancialObjectCode().equalsIgnoreCase(pOLineAcct.getFinancialObjectCode())) continue;
            lineAcct.setAmount(pOLineAcct.getAmount());
            lineAcct.setAccountLinePercent(pOLineAcct.getAccountLinePercent());
        }
    }
}

