/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.lookup;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.krad.lookup.LookupUtils;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.krad.bo.BusinessObject;

public class ThresholdLookupableHelperService
extends AbstractLookupableHelperServiceImpl {
    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        this.validateVendorNumber(fieldValues);
    }

    protected void validateVendorNumber(Map fieldValues) {
        String vendorNumber = (String)fieldValues.get("vendorNumber");
        if (StringUtils.isNotBlank((String)vendorNumber)) {
            int dashPos1 = vendorNumber.indexOf("-");
            if (dashPos1 > -1) {
                if (vendorNumber.indexOf("-", dashPos1 + 1) > -1) {
                    GlobalVariables.getMessageMap().putError("vendorNumber", "error.vendorLookup.vndrNum.dashes.tooMany", new String[0]);
                }
                if (vendorNumber.matches("\\-*")) {
                    GlobalVariables.getMessageMap().putError("vendorNumber", "error.vendorLookup.vndrNum.dashes.only", new String[0]);
                }
            }
            this.extractVendorNumberToVendorIds(fieldValues, vendorNumber);
        }
    }

    protected void extractVendorNumberToVendorIds(Map fieldValues, String vendorNumber) {
        String vendorHeaderGeneratedIdentifier = null;
        String vendorDetailAssignedIdentifier = null;
        int indexOfDash = vendorNumber.indexOf("-");
        if (indexOfDash < 0) {
            vendorHeaderGeneratedIdentifier = vendorNumber;
        } else {
            vendorHeaderGeneratedIdentifier = vendorNumber.substring(0, indexOfDash);
            vendorDetailAssignedIdentifier = vendorNumber.substring(indexOfDash + 1, vendorNumber.length());
        }
        try {
            if (StringUtils.isNotEmpty((String)vendorHeaderGeneratedIdentifier)) {
                Integer.parseInt(vendorHeaderGeneratedIdentifier);
            }
            if (StringUtils.isNotEmpty(vendorDetailAssignedIdentifier)) {
                Integer.parseInt(vendorDetailAssignedIdentifier);
            }
            fieldValues.remove("vendorNumber");
            fieldValues.put("vendorHeaderGeneratedIdentifier", vendorHeaderGeneratedIdentifier);
            fieldValues.put("vendorDetailAssignedIdentifier", vendorDetailAssignedIdentifier);
        }
        catch (NumberFormatException headerExc) {
            GlobalVariables.getMessageMap().putError("vendorNumber", "error.vendorLookup.vndrNum.numeric.dash.separated", new String[0]);
        }
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), false);
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), true);
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        boolean searchUsingOnlyPrimaryKeyValues = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(this.getBusinessObjectClass(), fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List searchResults = (List)this.getLookupService().findCollectionBySearchHelper(this.getBusinessObjectClass(), fieldValues, unbounded);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(this.getDefaultSortColumns(), true));
        }
        return searchResults;
    }
}

