/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.dataaccess.B2BDao;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.B2BPurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.exception.B2BConnectionException;
import org.kuali.kfs.module.purap.exception.CxmlParseError;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.PurchaseOrderResponse;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.ContractManager;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class B2BPurchaseOrderSciquestServiceImpl
implements B2BPurchaseOrderService {
    private static Logger LOG = Logger.getLogger(B2BPurchaseOrderSciquestServiceImpl.class);
    protected B2BDao b2bDao;
    protected RequisitionService requisitionService;
    protected ParameterService parameterService;
    protected PersonService personService;
    private String b2bEnvironment;
    private String b2bUserAgent;
    private String b2bPurchaseOrderURL;
    private String b2bPurchaseOrderIdentity;
    private String b2bPurchaseOrderPassword;

    @Override
    public String sendPurchaseOrder(PurchaseOrderDocument purchaseOrder) {
        String validateErrors;
        ContractManager contractManager = purchaseOrder.getVendorContract().getContractManager();
        String contractManagerEmail = this.getContractManagerEmail(contractManager);
        String vendorDuns = purchaseOrder.getVendorDetail().getVendorDunsNumber();
        RequisitionDocument r = this.requisitionService.getRequisitionById(purchaseOrder.getRequisitionIdentifier());
        WorkflowDocument reqWorkflowDoc = r.getDocumentHeader().getWorkflowDocument();
        String requisitionInitiatorPrincipalId = this.getRequisitionInitiatorPrincipal(reqWorkflowDoc.getInitiatorPrincipalId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sendPurchaseOrder(): b2bPurchaseOrderURL is " + this.b2bPurchaseOrderURL));
        }
        if (!StringUtils.isEmpty((String)(validateErrors = this.verifyCxmlPOData(purchaseOrder, requisitionInitiatorPrincipalId, this.b2bPurchaseOrderPassword, contractManager, contractManagerEmail, vendorDuns)))) {
            return validateErrors;
        }
        StringBuffer transmitErrors = new StringBuffer();
        try {
            LOG.debug((Object)"sendPurchaseOrder() Generating cxml");
            String cxml = this.getCxml(purchaseOrder, requisitionInitiatorPrincipalId, this.b2bPurchaseOrderPassword, contractManager, contractManagerEmail, vendorDuns);
            LOG.info((Object)("sendPurchaseOrder() Sending cxml\n" + cxml));
            String responseCxml = this.b2bDao.sendPunchOutRequest(cxml, this.b2bPurchaseOrderURL);
            LOG.info((Object)("sendPurchaseOrder(): Response cXML for po #" + purchaseOrder.getPurapDocumentIdentifier() + ":\n" + responseCxml));
            PurchaseOrderResponse poResponse = B2BParserHelper.getInstance().parsePurchaseOrderResponse(responseCxml);
            String statusText = poResponse.getStatusText();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sendPurchaseOrder(): statusText is " + statusText));
            }
            if (ObjectUtils.isNull((Object)statusText) || !"success".equalsIgnoreCase(statusText.trim())) {
                LOG.error((Object)("sendPurchaseOrder(): PO cXML for po number " + purchaseOrder.getPurapDocumentIdentifier() + " failed sending to SciQuest:\n" + statusText));
                transmitErrors.append("Unable to send Purchase Order: " + statusText);
                List errorMessages = poResponse.getPOResponseErrorMessages();
                if (ObjectUtils.isNotNull((Object)errorMessages) && !errorMessages.isEmpty()) {
                    for (String errorMessage : errorMessages) {
                        if (!ObjectUtils.isNotNull((Object)errorMessage)) continue;
                        LOG.error((Object)("sendPurchaseOrder(): SciQuest error message for po number " + purchaseOrder.getPurapDocumentIdentifier() + ": " + errorMessage));
                        transmitErrors.append("Error sending Purchase Order: " + errorMessage);
                    }
                }
            }
        }
        catch (B2BConnectionException e) {
            LOG.error((Object)"sendPurchaseOrder() Error connecting to b2b", (Throwable)((Object)e));
            transmitErrors.append("Connection to Sciquest failed.");
        }
        catch (CxmlParseError e) {
            LOG.error((Object)"sendPurchaseOrder() Error Parsing", (Throwable)e);
            transmitErrors.append("Unable to read cxml returned from Sciquest.");
        }
        catch (Throwable e) {
            LOG.error((Object)"sendPurchaseOrder() Unknown Error", e);
            transmitErrors.append("Unexpected error occurred while attempting to transmit Purchase Order.");
        }
        return transmitErrors.toString();
    }

    @Override
    public String getCxml(PurchaseOrderDocument purchaseOrder, String requisitionInitiatorPrincipalId, String password, ContractManager contractManager, String contractManagerEmail, String vendorDuns) {
        StringBuffer cxml = new StringBuffer();
        cxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        cxml.append("<!DOCTYPE PurchaseOrderMessage SYSTEM \"PO.dtd\">\n");
        cxml.append("<PurchaseOrderMessage version=\"2.0\">\n");
        cxml.append("  <Header>\n");
        cxml.append("    <MessageId>KFS_cXML_PO</MessageId>\n");
        Date d = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
        SimpleDateFormat date = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT);
        SimpleDateFormat time = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_TIME_FORMAT);
        cxml.append("    <Timestamp>").append(date.format(d)).append("T").append(time.format(d)).append("+05:30").append("</Timestamp>\n");
        cxml.append("    <Authentication>\n");
        cxml.append("      <Identity>").append(this.b2bPurchaseOrderIdentity).append("</Identity>\n");
        cxml.append("      <SharedSecret>").append(password).append("</SharedSecret>\n");
        cxml.append("    </Authentication>\n");
        cxml.append("  </Header>\n");
        cxml.append("  <PurchaseOrder>\n");
        cxml.append("    <POHeader>\n");
        cxml.append("      <PONumber>").append(purchaseOrder.getPurapDocumentIdentifier()).append("</PONumber>\n");
        cxml.append("      <Requestor>\n");
        cxml.append("        <UserProfile username=\"").append(requisitionInitiatorPrincipalId.toUpperCase()).append("\">\n");
        cxml.append("        </UserProfile>\n");
        cxml.append("      </Requestor>\n");
        cxml.append("      <Priority>High</Priority>\n");
        cxml.append("      <AccountingDate>").append(purchaseOrder.getPurchaseOrderCreateTimestamp()).append("</AccountingDate>\n");
        cxml.append("      <Supplier id=\"").append(purchaseOrder.getExternalOrganizationB2bSupplierIdentifier()).append("\">\n");
        cxml.append("        <DUNS>").append(vendorDuns).append("</DUNS>\n");
        cxml.append("        <SupplierNumber>").append(purchaseOrder.getVendorNumber()).append("</SupplierNumber>\n");
        cxml.append("        <ContactInfo type=\"main\">\n");
        cxml.append("          <Phone>\n");
        cxml.append("            <TelephoneNumber>\n");
        cxml.append("              <CountryCode>1</CountryCode>\n");
        if (contractManager.getContractManagerPhoneNumber().length() > 4) {
            cxml.append("              <AreaCode>").append(contractManager.getContractManagerPhoneNumber().substring(0, 3)).append("</AreaCode>\n");
            cxml.append("              <Number>").append(contractManager.getContractManagerPhoneNumber().substring(3)).append("</Number>\n");
        } else {
            LOG.error((Object)("getCxml() The phone number is invalid for this contract manager: " + contractManager.getContractManagerUserIdentifier() + " " + contractManager.getContractManagerName()));
            cxml.append("              <AreaCode>555</AreaCode>\n");
            cxml.append("              <Number>").append(contractManager.getContractManagerPhoneNumber()).append("</Number>\n");
        }
        cxml.append("            </TelephoneNumber>\n");
        cxml.append("          </Phone>\n");
        cxml.append("        </ContactInfo>\n");
        cxml.append("      </Supplier>\n");
        cxml.append("      <BillTo>\n");
        cxml.append("        <Address>\n");
        cxml.append("          <TemplateName>Bill To</TemplateName>\n");
        cxml.append("          <AddressCode>").append(purchaseOrder.getDeliveryCampusCode()).append("</AddressCode>\n");
        cxml.append("          <Contact label=\"FirstName\" linenumber=\"1\"><![CDATA[Accounts]]></Contact>\n");
        cxml.append("          <Contact label=\"LastName\" linenumber=\"2\"><![CDATA[Payable]]></Contact>\n");
        cxml.append("          <Contact label=\"Company\" linenumber=\"3\"><![CDATA[").append(purchaseOrder.getBillingName().trim()).append("]]></Contact>\n");
        if (!StringUtils.isEmpty((String)purchaseOrder.getBillingEmailAddress())) {
            cxml.append("          <Contact label=\"Email\" linenumber=\"4\"><![CDATA[").append(purchaseOrder.getBillingEmailAddress().trim()).append("]]></Contact>\n");
        }
        if (!StringUtils.isEmpty((String)purchaseOrder.getBillingPhoneNumber())) {
            cxml.append("          <Contact label=\"Phone\" linenumber=\"5\"><![CDATA[").append(purchaseOrder.getBillingPhoneNumber().trim()).append("]]></Contact>\n");
        }
        cxml.append("          <AddressLine label=\"Street1\" linenumber=\"1\"><![CDATA[").append(purchaseOrder.getBillingLine1Address()).append("]]></AddressLine>\n");
        cxml.append("          <AddressLine label=\"Street2\" linenumber=\"2\"><![CDATA[").append(purchaseOrder.getBillingLine2Address()).append("]]></AddressLine>\n");
        cxml.append("          <City><![CDATA[").append(purchaseOrder.getBillingCityName()).append("]]></City>\n");
        cxml.append("          <State>").append(purchaseOrder.getBillingStateCode()).append("</State>\n");
        cxml.append("          <PostalCode>").append(purchaseOrder.getBillingPostalCode()).append("</PostalCode>\n");
        cxml.append("          <Country isocountrycode=\"").append(purchaseOrder.getBillingCountryCode()).append("\">").append(purchaseOrder.getBillingCountryCode()).append("</Country>\n");
        cxml.append("        </Address>\n");
        cxml.append("      </BillTo>\n");
        cxml.append("      <ShipTo>\n");
        cxml.append("        <Address>\n");
        cxml.append("          <TemplateName>Ship To</TemplateName>\n");
        cxml.append("          <AddressCode>").append(purchaseOrder.getDeliveryCampusCode()).append(purchaseOrder.getOrganizationCode()).append("</AddressCode>\n");
        cxml.append("          <Contact label=\"Name\" linenumber=\"1\"><![CDATA[").append(purchaseOrder.getDeliveryToName().trim()).append("]]></Contact>\n");
        cxml.append("          <Contact label=\"PurchasingEmail\" linenumber=\"2\"><![CDATA[").append(contractManagerEmail).append("]]></Contact>\n");
        if (ObjectUtils.isNotNull((Object)purchaseOrder.getInstitutionContactEmailAddress())) {
            cxml.append("          <Contact label=\"ContactEmail\" linenumber=\"3\"><![CDATA[").append(purchaseOrder.getInstitutionContactEmailAddress()).append("]]></Contact>\n");
        } else {
            cxml.append("          <Contact label=\"ContactEmail\" linenumber=\"3\"><![CDATA[").append(purchaseOrder.getRequestorPersonEmailAddress()).append("]]></Contact>\n");
        }
        if (ObjectUtils.isNotNull((Object)purchaseOrder.getInstitutionContactPhoneNumber())) {
            cxml.append("          <Contact label=\"Phone\" linenumber=\"4\"><![CDATA[").append(purchaseOrder.getInstitutionContactPhoneNumber().trim()).append("]]></Contact>\n");
        } else {
            cxml.append("          <Contact label=\"Phone\" linenumber=\"4\"><![CDATA[").append(purchaseOrder.getRequestorPersonPhoneNumber()).append("]]></Contact>\n");
        }
        if (purchaseOrder.getAddressToVendorIndicator()) {
            cxml.append("          <AddressLine label=\"Street1\" linenumber=\"1\"><![CDATA[").append(purchaseOrder.getReceivingName().trim()).append("]]></AddressLine>\n");
            cxml.append("          <AddressLine label=\"Street2\" linenumber=\"2\"><![CDATA[").append(purchaseOrder.getReceivingLine1Address().trim()).append("]]></AddressLine>\n");
            if (ObjectUtils.isNull((Object)purchaseOrder.getReceivingLine2Address())) {
                cxml.append("          <AddressLine label=\"Street3\" linenumber=\"3\"><![CDATA[").append(" ").append("]]></AddressLine>\n");
            } else {
                cxml.append("          <AddressLine label=\"Street3\" linenumber=\"3\"><![CDATA[").append(purchaseOrder.getReceivingLine2Address()).append("]]></AddressLine>\n");
            }
            cxml.append("          <City><![CDATA[").append(purchaseOrder.getReceivingCityName().trim()).append("]]></City>\n");
            cxml.append("          <State>").append(purchaseOrder.getReceivingStateCode()).append("</State>\n");
            cxml.append("          <PostalCode>").append(purchaseOrder.getReceivingPostalCode()).append("</PostalCode>\n");
            cxml.append("          <Country isocountrycode=\"").append(purchaseOrder.getReceivingCountryCode()).append("\">").append(purchaseOrder.getReceivingCountryCode()).append("</Country>\n");
        } else {
            cxml.append(this.getBuildingLine(purchaseOrder));
            cxml.append("          <AddressLine label=\"Street1\" linenumber=\"1\"><![CDATA[").append(purchaseOrder.getDeliveryBuildingLine1Address().trim()).append("]]></AddressLine>\n");
            cxml.append("          <AddressLine label=\"Street2\" linenumber=\"2\"><![CDATA[Room #").append(purchaseOrder.getDeliveryBuildingRoomNumber().trim()).append("]]></AddressLine>\n");
            cxml.append("          <AddressLine label=\"Company\" linenumber=\"4\"><![CDATA[").append(purchaseOrder.getBillingName().trim()).append("]]></AddressLine>\n");
            if (ObjectUtils.isNull((Object)purchaseOrder.getDeliveryBuildingLine2Address())) {
                cxml.append("          <AddressLine label=\"Street3\" linenumber=\"3\"><![CDATA[").append(" ").append("]]></AddressLine>\n");
            } else {
                cxml.append("          <AddressLine label=\"Street3\" linenumber=\"3\"><![CDATA[").append(purchaseOrder.getDeliveryBuildingLine2Address()).append("]]></AddressLine>\n");
            }
            cxml.append("          <City><![CDATA[").append(purchaseOrder.getDeliveryCityName().trim()).append("]]></City>\n");
            cxml.append("          <State>").append(purchaseOrder.getDeliveryStateCode()).append("</State>\n");
            cxml.append("          <PostalCode>").append(purchaseOrder.getDeliveryPostalCode()).append("</PostalCode>\n");
            cxml.append("          <Country isocountrycode=\"").append(purchaseOrder.getDeliveryCountryCode()).append("\">").append(purchaseOrder.getDeliveryCountryCode()).append("</Country>\n");
        }
        cxml.append("        </Address>\n");
        cxml.append("      </ShipTo>\n");
        cxml.append("    </POHeader>\n");
        List detailList = purchaseOrder.getItems();
        for (PurchaseOrderItem poi : detailList) {
            if (!ObjectUtils.isNotNull((Object)((Object)poi.getItemType())) || !poi.getItemType().isLineItemIndicator()) continue;
            cxml.append("    <POLine linenumber=\"").append(poi.getItemLineNumber()).append("\">\n");
            cxml.append("      <Item>\n");
            cxml.append("        <CatalogNumber><![CDATA[").append(poi.getItemCatalogNumber()).append("]]></CatalogNumber>\n");
            if (ObjectUtils.isNotNull((Object)poi.getItemAuxiliaryPartIdentifier())) {
                cxml.append("        <AuxiliaryCatalogNumber><![CDATA[").append(poi.getItemAuxiliaryPartIdentifier()).append("]]></AuxiliaryCatalogNumber>\n");
            }
            cxml.append("        <Description><![CDATA[").append(poi.getItemDescription()).append("]]></Description>\n");
            cxml.append("        <ProductUnitOfMeasure type=\"supplier\"><Measurement><MeasurementValue><![CDATA[").append(poi.getItemUnitOfMeasureCode()).append("]]></MeasurementValue></Measurement></ProductUnitOfMeasure>\n");
            cxml.append("        <ProductUnitOfMeasure type=\"system\"><Measurement><MeasurementValue><![CDATA[").append(poi.getItemUnitOfMeasureCode()).append("]]></MeasurementValue></Measurement></ProductUnitOfMeasure>\n");
            if (poi.getExternalOrganizationB2bProductTypeName().equals("Punchout")) {
                cxml.append("        <ProductReferenceNumber>null</ProductReferenceNumber>\n");
            } else {
                cxml.append("        <ProductReferenceNumber>").append(poi.getExternalOrganizationB2bProductReferenceNumber()).append("</ProductReferenceNumber>\n");
            }
            cxml.append("        <ProductType>").append(poi.getExternalOrganizationB2bProductTypeName()).append("</ProductType>\n");
            cxml.append("      </Item>\n");
            cxml.append("      <Quantity>").append(poi.getItemQuantity()).append("</Quantity>\n");
            cxml.append("      <LineCharges>\n");
            cxml.append("        <UnitPrice>\n");
            cxml.append("          <Money currency=\"USD\">").append(poi.getItemUnitPrice()).append("</Money>\n");
            cxml.append("        </UnitPrice>\n");
            cxml.append("      </LineCharges>\n");
            cxml.append("    </POLine>\n");
        }
        cxml.append("  </PurchaseOrder>\n");
        cxml.append("</PurchaseOrderMessage>");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getCxml(): cXML for po number " + purchaseOrder.getPurapDocumentIdentifier() + ":\n" + cxml.toString()));
        }
        return cxml.toString();
    }

    @Override
    public String verifyCxmlPOData(PurchaseOrderDocument purchaseOrder, String requisitionInitiatorPrincipalName, String password, ContractManager contractManager, String contractManagerEmail, String vendorDuns) {
        StringBuffer errors = new StringBuffer();
        if (ObjectUtils.isNull((Object)purchaseOrder)) {
            LOG.error((Object)"verifyCxmlPOData()  The Purchase Order is null.");
            errors.append("Error occurred retrieving Purchase Order\n");
            return errors.toString();
        }
        if (ObjectUtils.isNull((Object)contractManager)) {
            LOG.error((Object)"verifyCxmlPOData()  The contractManager is null.");
            errors.append("Error occurred retrieving Contract Manager\n");
            return errors.toString();
        }
        if (StringUtils.isEmpty((String)password)) {
            LOG.error((Object)"verifyCxmlPOData()  The B2B PO password is required for the cXML PO but is missing.");
            errors.append("Missing Data: B2B PO password\n");
        }
        if (ObjectUtils.isNull((Object)purchaseOrder.getPurapDocumentIdentifier())) {
            LOG.error((Object)"verifyCxmlPOData()  The purchase order Id is required for the cXML PO but is missing.");
            errors.append("Missing Data: Purchase Order ID\n");
        }
        if (StringUtils.isEmpty((String)requisitionInitiatorPrincipalName)) {
            LOG.error((Object)"verifyCxmlPOData()  The requisition initiator principal name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Requisition Initiator Principal Name\n");
        }
        if (ObjectUtils.isNull((Object)purchaseOrder.getPurchaseOrderCreateTimestamp())) {
            LOG.error((Object)"verifyCxmlPOData()  The PO create date is required for the cXML PO but is null.");
            errors.append("Create Date\n");
        }
        if (StringUtils.isEmpty((String)contractManager.getContractManagerPhoneNumber())) {
            LOG.error((Object)"verifyCxmlPOData()  The contract manager phone number is required for the cXML PO but is missing.");
            errors.append("Missing Data: Contract Manager Phone Number\n");
        }
        if (StringUtils.isEmpty((String)contractManager.getContractManagerName())) {
            LOG.error((Object)"verifyCxmlPOData()  The contract manager name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Contract Manager Name\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryCampusCode())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery Campus Code is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery Campus Code\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingName())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery Billing Name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery Billing Name\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingLine1Address())) {
            LOG.error((Object)"verifyCxmlPOData()  The Billing Line 1 Address is required for the cXML PO but is missing.");
            errors.append("Missing Data: Billing Line 1 Address\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingLine2Address())) {
            LOG.error((Object)"verifyCxmlPOData()  The Billing Line 2 Address is required for the cXML PO but is missing.");
            errors.append("Missing Data: Billing Line 2 Address\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingCityName())) {
            LOG.error((Object)"verifyCxmlPOData()  The Billing Address City Name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Billing Address City Name\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingStateCode())) {
            LOG.error((Object)"verifyCxmlPOData()  The Billing Address State Code is required for the cXML PO but is missing.");
            errors.append("Missing Data: Billing Address State Code\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getBillingPostalCode())) {
            LOG.error((Object)"verifyCxmlPOData()  The Billing Address Postal Code is required for the cXML PO but is missing.");
            errors.append("Missing Data: Billing Address Postal Code\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryToName())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery To Name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery To Name\n");
        }
        if (StringUtils.isEmpty((String)contractManagerEmail)) {
            LOG.error((Object)"verifyCxmlPOData()  The Contract Manager Email is required for the cXML PO but is missing.");
            errors.append("Missing Data: Contract Manager Email\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getRequestorPersonEmailAddress())) {
            LOG.error((Object)"verifyCxmlPOData()  The Requesting Person Email Address is required for the cXML PO but is missing.");
            errors.append("Missing Data: Requesting Person Email Address\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getRequestorPersonPhoneNumber())) {
            LOG.error((Object)"verifyCxmlPOData()  The Requesting Person Phone Number is required for the cXML PO but is missing.");
            errors.append("Missing Data: Requesting Person Phone Number\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryBuildingLine1Address())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery Line 1 Address is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery Line 1 Address\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryToName())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery To Name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery To Name\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryCityName())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery City Name is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery City Name\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryStateCode())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery State is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery State\n");
        }
        if (StringUtils.isEmpty((String)purchaseOrder.getDeliveryPostalCode())) {
            LOG.error((Object)"verifyCxmlPOData()  The Delivery Postal Code is required for the cXML PO but is missing.");
            errors.append("Missing Data: Delivery Postal Code\n");
        }
        List detailList = purchaseOrder.getItems();
        for (PurchaseOrderItem poi : detailList) {
            if (!ObjectUtils.isNotNull((Object)((Object)poi.getItemType())) || !poi.getItemType().isLineItemIndicator()) continue;
            if (ObjectUtils.isNull((Object)poi.getItemLineNumber())) {
                LOG.error((Object)"verifyCxmlPOData()  The Item Line Number is required for the cXML PO but is missing.");
                errors.append("Missing Data: Item Line Number\n");
            }
            if (StringUtils.isEmpty((String)poi.getItemCatalogNumber())) {
                LOG.error((Object)("verifyCxmlPOData()  The Catalog Number for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
                errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - Catalog Number\n");
            }
            if (StringUtils.isEmpty((String)poi.getItemDescription())) {
                LOG.error((Object)("verifyCxmlPOData()  The Description for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
                errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - Description\n");
            }
            if (StringUtils.isEmpty((String)poi.getItemUnitOfMeasureCode())) {
                LOG.error((Object)("verifyCxmlPOData()  The Unit Of Measure Code for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
                errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - Unit Of Measure\n");
            }
            if (StringUtils.isEmpty((String)poi.getExternalOrganizationB2bProductTypeName())) {
                LOG.error((Object)("verifyCxmlPOData()  The External Org B2B Product Type Name for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
                errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - External Org B2B Product Type Name\n");
            }
            if (poi.getItemQuantity() == null) {
                LOG.error((Object)("verifyCxmlPOData()  The Order Quantity for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
                errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - Order Quantity\n");
            }
            if (poi.getItemUnitPrice() != null) continue;
            LOG.error((Object)("verifyCxmlPOData()  The Unit Price for item number " + poi.getItemLineNumber() + " is required for the cXML PO but is missing."));
            errors.append("Missing Data: Item#" + poi.getItemLineNumber() + " - Unit Price\n");
        }
        return errors.toString();
    }

    protected String getContractManagerEmail(ContractManager cm) {
        Person contractManager = this.getPersonService().getPerson(cm.getContractManagerUserIdentifier());
        if (ObjectUtils.isNotNull((Object)contractManager)) {
            return contractManager.getEmailAddressUnmasked();
        }
        return "";
    }

    protected String getRequisitionInitiatorPrincipal(String requisitionInitiatorPrincipalId) {
        Principal requisitionInitiator = KimApiServiceLocator.getIdentityService().getPrincipal(requisitionInitiatorPrincipalId);
        if (ObjectUtils.isNotNull((Object)requisitionInitiator)) {
            return requisitionInitiator.getPrincipalName();
        }
        return "";
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setB2bDao(B2BDao b2bDao) {
        this.b2bDao = b2bDao;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }

    public void setB2bEnvironment(String environment) {
        this.b2bEnvironment = environment;
    }

    public void setB2bUserAgent(String userAgent) {
        this.b2bUserAgent = userAgent;
    }

    public void setB2bPurchaseOrderURL(String purchaseOrderURL) {
        this.b2bPurchaseOrderURL = purchaseOrderURL;
    }

    public void setB2bPurchaseOrderIdentity(String b2bPurchaseOrderIdentity) {
        this.b2bPurchaseOrderIdentity = b2bPurchaseOrderIdentity;
    }

    public void setB2bPurchaseOrderPassword(String purchaseOrderPassword) {
        this.b2bPurchaseOrderPassword = purchaseOrderPassword;
    }

    public String getB2bEnvironment() {
        return this.b2bEnvironment;
    }

    public String getB2bUserAgent() {
        return this.b2bUserAgent;
    }

    public String getB2bPurchaseOrderURL() {
        return this.b2bPurchaseOrderURL;
    }

    public String getB2bPurchaseOrderIdentity() {
        return this.b2bPurchaseOrderIdentity;
    }

    public String getB2bPurchaseOrderPassword() {
        return this.b2bPurchaseOrderPassword;
    }

    public String getBuildingLine(PurchaseOrderDocument purchaseOrder) {
        StringBuffer line = new StringBuffer();
        if (StringUtils.isNotEmpty((String)purchaseOrder.getDeliveryBuildingName())) {
            line.append("          <Contact label=\"Building\" linenumber=\"5\"><![CDATA[").append(purchaseOrder.getDeliveryBuildingName()).append(" (").append(purchaseOrder.getDeliveryBuildingCode()).append(")]]></Contact>\n");
        }
        return line.toString();
    }
}

