/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableAddItemValidation;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class PurchasingAddItemValidation
extends PurchasingAccountsPayableAddItemValidation {
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("newPurchasingItemLine");
        PurApItem refreshedItem = this.getItemForValidation();
        refreshedItem.refreshReferenceObject("itemType");
        super.setItemForValidation(refreshedItem);
        valid &= super.validate(event);
        valid &= this.validateItemUnitPrice(this.getItemForValidation());
        valid &= this.validateUnitOfMeasure(this.getItemForValidation());
        if (this.getItemForValidation().getItemType().isLineItemIndicator()) {
            valid &= this.validateItemDescription(this.getItemForValidation());
            valid &= this.validateItemQuantity(this.getItemForValidation());
            valid &= this.validateCommodityCodes(this.getItemForValidation(), this.commodityCodeIsRequired());
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingItemLine");
        return valid;
    }

    protected boolean validateCommodityCodes(PurApItem item, boolean commodityCodeRequired) {
        boolean valid = true;
        String identifierString = item.getItemIdentifierString();
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        if (commodityCodeRequired && StringUtils.isBlank((String)purItem.getPurchasingCommodityCode())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(CommodityCode.class.getName()).getAttributeDefinition("purchasingCommodityCode").getLabel();
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.required", new String[]{attributeLabel + " in " + identifierString});
        } else if (StringUtils.isNotBlank((String)purItem.getPurchasingCommodityCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("purchasingCommodityCode", purItem.getPurchasingCommodityCode());
            if (this.businessObjectService.countMatching(CommodityCode.class, fieldValues) != 1) {
                valid = false;
                GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.invalid", new String[]{" in " + identifierString});
            } else {
                valid &= this.validateThatCommodityCodeIsActive(item);
            }
        }
        return valid;
    }

    public boolean validateItemUnitPrice(PurApItem item) {
        boolean valid = true;
        if (item.getItemType().isLineItemIndicator() && ObjectUtils.isNull((Object)item.getItemUnitPrice())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitPrice").getLabel();
            GlobalVariables.getMessageMap().putError("itemUnitPrice", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        if (ObjectUtils.isNotNull((Object)item.getItemUnitPrice())) {
            if (BigDecimal.ZERO.compareTo(item.getItemUnitPrice()) > 0 && !item.getItemTypeCode().equals("ORDS") && !item.getItemTypeCode().equals("TRDI")) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.belowZero", new String[]{"Unit Cost", item.getItemIdentifierString()});
                valid = false;
            } else if (BigDecimal.ZERO.compareTo(item.getItemUnitPrice()) < 0 && (item.getItemTypeCode().equals("ORDS") || item.getItemTypeCode().equals("TRDI"))) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.notBelowZero", new String[]{"Unit Cost", item.getItemIdentifierString()});
                valid = false;
            }
        }
        return valid;
    }

    public boolean validateUnitOfMeasure(PurApItem item) {
        boolean valid = true;
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        if (purItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
            String uomCode = purItem.getItemUnitOfMeasureCode();
            if (StringUtils.isEmpty((String)uomCode)) {
                valid = false;
                String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
                GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
            } else {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("itemUnitOfMeasureCode", purItem.getItemUnitOfMeasureCode());
                if (this.businessObjectService.countMatching(UnitOfMeasure.class, fieldValues) != 1) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "error.item.unitOfMeasureCode.invalid", new String[]{" in " + item.getItemIdentifierString()});
                }
                if (ObjectUtils.isNotNull((Object)purItem.getItemUnitOfMeasure()) && !purItem.getItemUnitOfMeasure().isActive()) {
                    valid = false;
                    String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
                    GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "errors.item.uom.inactive", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
                }
            }
        }
        if (purItem.getItemType().isAmountBasedGeneralLedgerIndicator() && StringUtils.isNotBlank((String)purItem.getItemUnitOfMeasureCode())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
            GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "errors.item.uom.isNotAllowed", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        return valid;
    }

    public boolean validateItemDescription(PurApItem item) {
        boolean valid = true;
        if (StringUtils.isEmpty((String)item.getItemDescription())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemDescription").getLabel();
            GlobalVariables.getMessageMap().putError("itemDescription", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        return valid;
    }

    public boolean validateItemQuantity(PurApItem item) {
        boolean valid = true;
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        if (purItem.getItemType().isQuantityBasedGeneralLedgerIndicator() && ObjectUtils.isNull((Object)purItem.getItemQuantity())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemQuantity").getLabel();
            GlobalVariables.getMessageMap().putError("itemQuantity", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        } else if (purItem.getItemType().isAmountBasedGeneralLedgerIndicator() && ObjectUtils.isNotNull((Object)purItem.getItemQuantity())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemQuantity").getLabel();
            GlobalVariables.getMessageMap().putError("itemQuantity", "errors.item.quantity.isNotAllowed", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        return valid;
    }

    protected boolean commodityCodeIsRequired() {
        return false;
    }

    protected boolean validateThatCommodityCodeIsActive(PurApItem item) {
        if (!((PurchasingItemBase)item).getCommodityCode().isActive()) {
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.inactive", new String[]{" in " + item.getItemIdentifierString()});
            return false;
        }
        return true;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

