/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetLocation;
import org.kuali.kfs.module.purap.fixture.PurchasingCapitalAssetLocationFixture;

public enum PurchasingCapitalAssetSystemFixture {
    ASSET_SYSTEM_BASIC_1("Asset 1", false, "TYPE1", "manufacturer", "description", "note text", new PurchasingCapitalAssetLocationFixture[]{PurchasingCapitalAssetLocationFixture.LOCATION_BASIC}),
    ASSET_SYSTEM_BASIC_2("Asset 2", false, "TYPE2", "manufacturer", "description", "note text", new PurchasingCapitalAssetLocationFixture[]{PurchasingCapitalAssetLocationFixture.LOCATION_BASIC});

    private String capitalAssetSystemDescription;
    private boolean capitalAssetNotReceivedCurrentFiscalYearIndicator;
    private String capitalAssetTypeCode;
    private String capitalAssetManufacturerName;
    private String capitalAssetModelDescription;
    private String capitalAssetNoteText;
    private PurchasingCapitalAssetLocationFixture[] locations;

    private PurchasingCapitalAssetSystemFixture(String capitalAssetSystemDescription, boolean capitalAssetNotReceivedCurrentFiscalYearIndicator, String capitalAssetTypeCode, String capitalAssetManufacturerName, String capitalAssetModelDescription, String capitalAssetNoteText, PurchasingCapitalAssetLocationFixture[] locations) {
        this.capitalAssetSystemDescription = capitalAssetSystemDescription;
        this.capitalAssetNotReceivedCurrentFiscalYearIndicator = capitalAssetNotReceivedCurrentFiscalYearIndicator;
        this.capitalAssetTypeCode = capitalAssetTypeCode;
        this.capitalAssetManufacturerName = capitalAssetManufacturerName;
        this.capitalAssetModelDescription = capitalAssetModelDescription;
        this.capitalAssetNoteText = capitalAssetNoteText;
        this.locations = locations;
    }

    public CapitalAssetSystem createPurchasingCapitalAssetSystem(Class clazz) {
        CapitalAssetSystem assetSystem = null;
        try {
            assetSystem = (CapitalAssetSystem)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("asset system creation failed. class = " + clazz);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("asset system creation failed. class = " + clazz);
        }
        assetSystem.setCapitalAssetSystemDescription(this.capitalAssetSystemDescription);
        assetSystem.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(this.capitalAssetNotReceivedCurrentFiscalYearIndicator);
        assetSystem.setCapitalAssetTypeCode(this.capitalAssetTypeCode);
        assetSystem.setCapitalAssetManufacturerName(this.capitalAssetManufacturerName);
        assetSystem.setCapitalAssetModelDescription(this.capitalAssetModelDescription);
        assetSystem.setCapitalAssetNoteText(this.capitalAssetNoteText);
        for (PurchasingCapitalAssetLocationFixture locationFixture : this.locations) {
            CapitalAssetLocation location = locationFixture.createPurchasingCapitalAssetLocation(RequisitionCapitalAssetLocation.class);
            assetSystem.getCapitalAssetLocations().add(location);
        }
        return assetSystem;
    }
}

