/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class AccountsPayableDocumentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static Logger LOG = Logger.getLogger(AccountsPayableDocumentDerivedRoleTypeServiceImpl.class);
    protected static final String FISCAL_OFFICER_ROLE_NAME = "Fiscal Officer";
    protected static final String SUB_ACCOUNT_ROLE_NAME = "Sub-Account Reviewer";
    protected static final String ACCOUNTING_REVIEWER_ROLE_NAME = "Accounting Reviewer";

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String docId = qualification.get("documentNumber");
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName("KFS-SYS", FISCAL_OFFICER_ROLE_NAME));
        roleIds.add(KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName("KFS-PURAP", SUB_ACCOUNT_ROLE_NAME));
        roleIds.add(KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName("KFS-SYS", ACCOUNTING_REVIEWER_ROLE_NAME));
        try {
            AccountsPayableDocument apDocument = (AccountsPayableDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
            for (SourceAccountingLine accountingLine : apDocument.getSourceAccountingLines()) {
                HashMap<String, String> roleQualifier = new HashMap<String, String>();
                roleQualifier.put("documentTypeName", apDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                roleQualifier.put("financialDocumentTotalAmount", apDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount().toString());
                roleQualifier.put("chartOfAccountsCode", accountingLine.getChartOfAccountsCode());
                roleQualifier.put("organizationCode", accountingLine.getAccount().getOrganizationCode());
                roleQualifier.put("accountNumber", accountingLine.getAccountNumber());
                roleQualifier.put("subAccountNumber", accountingLine.getSubAccountNumber());
                roleQualifier.put("accountingLineOverrideCode", accountingLine.getOverrideCode());
                if (!KimApiServiceLocator.getRoleService().principalHasRole(principalId, roleIds, roleQualifier)) continue;
                return true;
            }
        }
        catch (WorkflowException we) {
            LOG.error((Object)("Exception encountered when retrieving document number " + docId + "."), (Throwable)we);
            throw new RuntimeException("Exception encountered when retrieving document number " + docId + ".", we);
        }
        return false;
    }
}

